<?php namespace App\Controllers\Admin\Auth;

use App\Controllers\Admin\BaseController;
use App\Controllers\Common\SessionConstant;
use App\Helpers\AuthHelpers;
use App\Models\AccountManagerModel;
use App\Models\MemberModel;
use CodeIgniter\HTTP\Request;

class LoginController extends BaseController
{
    protected $accountManagerModel;
    public function __construct()
    {
        parent::__construct();
        $this->accountManagerModel = new AccountManagerModel();
    }

    public function index()
    {
        AuthHelpers::clearLoginAdmin();
        return view('admin/auth/login_lte');
    }

    public function login(){
        $this->rules = [
            'member_email' => 'required',
            'password' => 'required|min_length[3]'
        ];
        if( $this->checkValidation() ){
            $email = $this->request->getVar('member_email');
            $password = $this->request->getVar('password');
            $remember = $this->request->getVar('remember');

            if($account = $this->accountManagerModel->checkLogin($email, $password)){
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginAdmin($account->toSession());
                return redirect()->route('admin.home');
            }else{
                $this->validator->setError('error_common',lang_common('login_incorrect_email_or_pass'));
                return view('admin/auth/login_lte', [
                    'validator' => $this->validator
                ]);
            }
        }else{
            return view('admin/auth/login_lte', [
                'validator' => $this->validator
            ]);
        }
    }

    public function logout(){
        AuthHelpers::clearLoginAdmin();
        return redirect()->route('admin.show_login')->withInput();
    }

    //--------------------------------------------------------------------

}

