<?php namespace App\Controllers\Admin;

use App\Entities\Bannerinfos;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\BannerinfoCategoryModel;
use App\Models\BannerinfoFileModel;
use App\Models\BannerinfoModel;
use App\Services\BannerinfosService;

class BannerinfosController extends BaseController
{
    protected $bannerinfosModel;
    protected $bannerinfosFileModel;
    protected $bannerinfosService;
    protected $bannerinfoCategoryModel;

    public function __construct()
    {
        $this->bannerinfosModel = new BannerinfoModel();
        $this->bannerinfosFileModel = new BannerinfoFileModel();
        $this->bannerinfosService = new BannerinfosService();
        $this->bannerinfoCategoryModel = new BannerinfoCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->bannerinfoCategoryModel->findAll();
        $data = $this->bannerinfosModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        //exit;
        return $this->viewAdmin('bannerinfos/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'sub_title' => lang_common('sub_title')
        ];
    }

    public function showCreate(){
        $this->rules = $this->bannerinfosModel->getValidationRules();
        $categories = $this->bannerinfoCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('bannerinfos/create',$data);
    }

    public function create(){
        $this->rules = $this->bannerinfosModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->bannerinfosService->saveBannerinfos($this->request,$accountManger->account_id);
            $message = 'Create bannerinfos success.';
            return redirect()->route('admin.bannerinfos.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('bannerinfos/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->bannerinfosModel->getValidationRules();
        $bannerinfosItem = $this->bannerinfosModel->find($id);
        $files = $this->bannerinfosFileModel->where('bannerinfos_id',$id)->findAll();
        $categories = $this->bannerinfoCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $bannerinfosItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('bannerinfos/update', $data);
    }

    public function update($id){
        $this->rules = $this->bannerinfosModel->getValidationRules();
        if($this->checkValidation()){
            $this->bannerinfosService->updateBannerinfos($id,$this->request);
            $message = "Update bannerinfos success";
            return redirect()->route('admin.bannerinfos.index')->with('message',$message);
        }else{
            return view('admin/bannerinfos/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteBannerinfos($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->bannerinfosService->deleteBannerinfos($ids);
            if($result) $message = "Delete bannerinfos success";
        }
        return redirect()->route('admin.bannerinfos.index')->with('message',$message);
    }

    public function deleteFile($bannerinfosId,$fileNo){
        $this->bannerinfosFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.bannerinfos.update',[$bannerinfosId])->with('message',$message);;
    }

}
