<?php
namespace App\Controllers\Admin;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 *
 * @package CodeIgniter
 */

use App\Helpers\AuthHelpers;
use App\Helpers\ValidatorHelper;
use App\Libraries\Excel\Excel;
use App\Libraries\NaverPay\NHNAPISCL;
use App\Libraries\NaverPay\Naver_pay_lib;
use CodeIgniter\Controller;
use \Config\Services;

class BaseController extends Controller
{

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = [
        "App\Helpers\Admin\app_helpers",
        "App\Helpers\Common\app_helpers",
        "form_validation",
        'cookie'
    ];

    /**
     * @var \CodeIgniter\Session\Session
     */
    protected $session;

    protected $breadcrumb;

    /**
     * Libary excel custom
     * @var Excel
     */
    protected $excel;

    protected $rules;
    protected $messages;

    protected $base_view = 'admin';
    protected $base_view_layout = 'admin/layouts/partials';

    public function __construct()
    {
    }

    /**
     * Constructor.
     */
    public function initController(\CodeIgniter\HTTP\RequestInterface $request, \CodeIgniter\HTTP\ResponseInterface $response, \Psr\Log\LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        //--------------------------------------------------------------------
        // Preload any models, libraries, etc, here.
        //--------------------------------------------------------------------
        // E.g.:
        $this->session = \Config\Services::session();
        $this->validator = \Config\Services::validation();
        $this->breadcrumb = \Config\Services::breadcrumb();
        $this->excel = \Config\Services::excel();
    }

    protected function validationMapFieldLabels(){
        return [];
    }

    protected function checkValidation($data = null){
        $this->validator->setRules(isset($this->rules) ? $this->rules : [] ,
            isset($this->messages) ? $this->messages : []);
        if(isset($data)) {
            return $this->validator->run($data);
        }else{
            return $this->validator->withRequest($this->request)->run();
        }
    }

    protected function viewAdmin($viewName, $params = []){
        $accountManager = AuthHelpers::getLoginInfoAdmin();
        if(isset($accountManager) && $accountManager->remember ==1){
            helper('cookie');
            AuthHelpers::setCookieLoginAdmin($accountManager);
        }
        $params['breadcrumb'] = $this->breadcrumb;
        $params['session'] = $this->session;
        $params['validator'] = $this->validator;
        if(isset($this->rules) && count($this->rules) > 0){
            $this->validator->setRules($this->rules);
            $mapFields = $this->validationMapFieldLabels();
            if(isset($mapFields) && count($mapFields) > 0) $this->validator->setMapFieldLabels($mapFields);
            $validation = $this->validator->validatorToJs();
            $params['validation'] = $validation;
            $params['validation']['str_rules'] = str_replace('rules:','',$validation['rules']);
            $params['validation']['str_messages'] = str_replace('messages:','',$validation['messages']);
        }
        return view($this->base_view.'/'.$viewName, $params);
    }

    protected function setHeaderDownload($fileName, $fileUrl){
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.$fileName.'"');
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($fileUrl)); //Absolute URL
        ob_clean();
        flush();
        readfile($fileUrl); //Absolute URL
    }

}
