<?php namespace App\Controllers\Admin;

use App\Entities\Deferredpay;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\DeferredpayCategoryModel;
use App\Models\DeferredpayFileModel;
use App\Models\DeferredpayModel;
use App\Services\DeferredpayService;

class DeferredpayController extends BaseController
{
    protected $deferredpayModel;
    protected $deferredpayFileModel;
    protected $deferredpayService;
    protected $deferredpayCategoryModel;

    public function __construct()
    {
        $this->deferredpayModel = new DeferredpayModel();
        $this->deferredpayFileModel = new DeferredpayFileModel();
        $this->deferredpayService = new DeferredpayService();
        $this->deferredpayCategoryModel = new DeferredpayCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->deferredpayCategoryModel->findAll();
        $data = $this->deferredpayModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('deferredpay/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->deferredpayModel->getValidationRules();
        $categories = $this->deferredpayCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('deferredpay/create',$data);
    }

    public function create(){
        $this->rules = $this->deferredpayModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->deferredpayService->saveDeferredpay($this->request,$accountManger->account_id);
            $message = 'Create deferredpay success.';
            return redirect()->route('admin.deferredpay.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('deferredpay/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->deferredpayModel->getValidationRules();
        $deferredpayItem = $this->deferredpayModel->find($id);
        $files = $this->deferredpayFileModel->where('deferredpay_id',$id)->findAll();
        $categories = $this->deferredpayCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $deferredpayItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('deferredpay/update', $data);
    }

    public function update($id){
        $this->rules = $this->deferredpayModel->getValidationRules();
        if($this->checkValidation()){
            $this->deferredpayService->updateDeferredpay($id,$this->request);
            $message = "Update deferredpay success";
            return redirect()->route('admin.deferredpay.index')->with('message',$message);
        }else{
            return view('admin/deferredpay/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteDeferredpay($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->deferredpayService->deleteDeferredpay($ids);
            if($result) $message = "Delete deferredpay success";
        }
        return redirect()->route('admin.deferredpay.index')->with('message',$message);
    }

    public function deleteFile($deferredpayId,$fileNo){
        $this->deferredpayFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.deferredpay.update',[$deferredpayId])->with('message',$message);;
    }

}
