<?php namespace App\Controllers\Admin;

use App\Entities\Deliverycodes;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\DeliverycodeCategoryModel;
use App\Models\DeliverycodeModel;
use App\Services\DeliverycodesService;

class DeliverycodesController extends BaseController
{
    protected $deliverycodesModel;
    protected $deliverycodesService;
    protected $deliverycodeCategoryModel;

    public function __construct()
    {
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->deliverycodesService = new DeliverycodesService();
        $this->deliverycodeCategoryModel = new DeliverycodeCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data = $this->deliverycodesModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('deliverycodes/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->deliverycodesModel->getValidationRules();
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('deliverycodes/create',$data);
    }

    public function create(){
        $this->rules = $this->deliverycodesModel->getValidationRules();
        if($this->checkValidation()){

            $this->deliverycodesService->saveDeliverycodes($this->request);
            $message = 'Create deliverycodes success.';
            return redirect()->route('admin.deliverycodes.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('deliverycodes/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->deliverycodesModel->getValidationRules();
        $deliverycodesItem = $this->deliverycodesModel->find($id);
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $deliverycodesItem;
        return $this->viewAdmin('deliverycodes/update', $data);
    }

    public function update($id){
        $this->rules = $this->deliverycodesModel->getValidationRules();
        if($this->checkValidation()){
            $this->deliverycodesService->updateDeliverycodes($id,$this->request);
            $message = "Update deliverycodes success";
            return redirect()->route('admin.deliverycodes.index')->with('message',$message);
        }else{
            return view('admin/deliverycodes/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteDeliverycodes($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->deliverycodesService->deleteDeliverycodes($ids);
            if($result) $message = "Delete deliverycodes success";
        }
        return redirect()->route('admin.deliverycodes.index')->with('message',$message);
    }

    public function deleteFile($deliverycodesId,$fileNo){
        $message = "Delete file success";
        return redirect()->route('admin.deliverycodes.update',[$deliverycodesId])->with('message',$message);;
    }

}
