<?php namespace App\Controllers\Admin;

use App\Entities\Displayinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
//use App\Models\DisplayinfoCategoryModel;
//use App\Models\DisplayinfoFileModel;
use App\Models\DisplayinfoModel;
use App\Services\DisplayinfoService;
use App\Models\ManufacturerModel;


class DisplayinfoController extends BaseController
{
    protected $displayinfoModel;
  //  protected $displayinfoFileModel;
    protected $displayinfoService;
  //  protected $displayCategoryModel;
    protected $manufacturerModel;

    public function __construct()
    {
        $this->displayinfoModel = new DisplayinfoModel();
        //$this->displayinfoFileModel = new DisplayinfoFileModel();
        $this->displayinfoService = new DisplayinfoService();
        //$this->displayCategoryModel = new DisplayinfoCategoryModel();
        $this->manufacturerModel = new ManufacturerModel();

    }


    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['display_code']) && $searchInput['display_code'] != '') || ( isset($searchInput['display_name']) && $searchInput['display_name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        //$categories = $this->displayCategoryModel->findAll();
        $data = $this->displayinfoModel->getSearch($searchInput,$perPage);
        //$data['categories'] = $categories;
        
        //var_dump ($data);
        //exit;
        return $this->viewAdmin('displayinfo/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'display_name' => lang_common('display_name'),
            'display_code' => lang_common('display_code')
        ];
    }

    public function showCreate(){
        $this->rules = $this->displayinfoModel->getValidationRules();

        //var_dump ($data);
        //exit;

        $data['displayinfo_code'] = 'DC01M'.time();
        $data['manufacturers'] = $this->manufacturerModel->selectAll();

        return $this->viewAdmin('displayinfo/create',$data);
    }

    public function create(){
        $this->rules = $this->displayinfoModel->getValidationRules();
        if($this->checkValidation()){
            //$accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->displayinfoService->saveDisplayinfo($this->request,$accountManger->account_id);
            $message = 'Create Displayinfo success.';
            return redirect()->route('admin.displayinfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('displayinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->displayinfoModel->getValidationRules();
        $displayinfoItem = $this->displayinfoModel->find($id);

        //$code = $displayinfoItem->manufacturer_id;
        //$manufacturer = $this->manufacturerModel->findByCode($code);
        //$displayinfoItem->manufacturer_name = $manufacturer->name;

        $data['manufacturers'] =$this->manufacturerModel->selectAll();

        $data['item'] = $displayinfoItem;

        return $this->viewAdmin('displayinfo/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->displayinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->displayinfoService->updateDisplayinfo($id,$this->request);

            $message = "Update displayinfo success";
            return redirect()->route('admin.displayinfo.index')->with('message',$message);
        }else{
            return view('admin/displayinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteDisplayinfo($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->displayinfoService->deleteDisplayinfo($ids);
            if($result) $message = "Delete displayinfo success";
        }
        return redirect()->route('admin.displayinfo.index')->with('message',$message);
    }

}
