<?php namespace App\Controllers\Admin;

use App\Entities\Eventinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
//use App\Models\EventinfoCategoryModel;
//use App\Models\EventinfoFileModel;
use App\Models\EventinfoModel;
use App\Services\EventinfoService;

class EventinfoController extends BaseController
{
    protected $eventinfoModel;
  //  protected $eventinfoFileModel;
    protected $eventinfoService;
  //  protected $eventCategoryModel;

    public function __construct()
    {
        $this->eventinfoModel = new EventinfoModel();
        //$this->eventinfoFileModel = new EventinfoFileModel();
        $this->eventinfoService = new EventinfoService();
        //$this->eventCategoryModel = new EventinfoCategoryModel();
    }


    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['event_title']) && $searchInput['event_title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        //$categories = $this->eventCategoryModel->findAll();
        $data = $this->eventinfoModel->getSearch($searchInput,$perPage);
        //$data['categories'] = $categories;
        
        //var_dump ($data);
        //exit;
        return $this->viewAdmin('eventinfo/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'event_title' => lang_common('event_title')
        ];
    }

    public function showCreate(){
        $this->rules = $this->eventinfoModel->getValidationRules();
        // $data['eventinfo_code'] = 'DC01M'.time();

        return $this->viewAdmin('eventinfo/create',$data);
    }


    public function create(){
        $this->rules = $this->eventinfoModel->getValidationRules();
        if($this->checkValidation()){
            //$accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->eventinfoService->saveEventinfo($this->request,$accountManger->account_id);
            $message = 'Create Eventinfo success.';
            return redirect()->route('admin.eventinfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('eventinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->eventinfoModel->getValidationRules();
        $eventinfoItem = $this->eventinfoModel->find($id);

        $data['item'] = $eventinfoItem;
        return $this->viewAdmin('eventinfo/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->eventinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->eventinfoService->updateEventinfo($id,$this->request);

            $message = "Update eventinfo success";
            return redirect()->route('admin.eventinfo.index')->with('message',$message);
        }else{
            return view('admin/eventinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteEventinfo($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->eventinfoService->deleteEventinfo($ids);
            if($result) $message = "Delete eventinfo success";
        }
        return redirect()->route('admin.eventinfo.index')->with('message',$message);
    }

}
