<?php namespace App\Controllers\Admin;

use App\Helpers\DateHelper;
use App\Services\ProductService;

class ExcelUploadController extends BaseController
{

    protected $productService;

    public function __construct()
    {
        parent::__construct();
        $this->productService = new ProductService();
    }

    public function validationMapFieldLabels()
    {
        return [
            'file_upload' => 'File upload'
        ];
    }

    public function index()
    {
        $this->rules = [
            'file_upload' => 'required|ext_in[file_upload,xlsx,xls]'
        ];
        return $this->viewAdmin('products/upload/index');
    }

    public function downloadTemplate(){
        $fileName = 'sallist_sample_download.xls';
        $filePath = PUBLIC_PATH. 'upload/excel/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }

    public function upload(){
        ini_set('display_errors',1);
        $inputs = $this->request->getPost();
        $file = $this->request->getFile('file_upload');

        //var_dump($inputs);
        //echo"<br>";
        //exit;

        $message = "Upload success";

        if(isset($file)){

            $uploadType = $inputs['upload_type'];


            $headerColumns = [
                //'product_code' => lang_product('excel_product_code'),
                'part_category' => lang_product('excel_part_category'),
                'part_category2' => lang_product('excel_part_category2'),
                'part_category3' => lang_product('excel_part_category3'),
                'maker_seq' => lang_product('excel_maker_seq'),
                'location_code' => lang_product('excel_location_code'),
                'part_number' => lang_product('excel_part_number'),
                'part_number_sequence' => lang_product('excel_part_number_sequence'),
                'search_word' => lang_product('excel_search_word'),
                'brief_description' => lang_product('excel_brief_description'),
                'date_code' => lang_product('excel_date_code'),
                'image_dir' => lang_product('excel_image_dir'),
                'pdf_dir' => lang_product('excel_pdf_dir'),
                'delivery_code' => lang_product('excel_delivery_code'),
                'api_flg' => lang_product('excel_api_flg'),
                'api_code' => lang_product('excel_api_code'),
                // 'tariff_rate' => lang_product('excel_tariff_rate'),
                'product_api_id' => lang_product('excel_product_api_id'),
                'qty' => lang_product('excel_qty'),
                'packing_code' => lang_product('excel_packing_code'),
                'wearing_price' => lang_product('excel_wearing_price'),
                'price' => lang_product('excel_price'),
                'leadtime' => lang_product('excel_leadtime'),
                'moq' => lang_product('excel_moq'),
                'mpq' => lang_product('excel_mpq'),
                'stock_location' => lang_product('excel_stock_location'),
                'taxable' => lang_product('excel_taxable'),

                'selling_price1' => lang_product('excel_selling_price1'),
                'margin_rate1' => lang_product('excel_margin_rate1'),
                'unit_mini_quantity1' => lang_product('excel_unit_mini_quantity1'),
                'unit_max_quantity1' => lang_product('excel_unit_max_quantity1'),

                'selling_price2' => lang_product('excel_selling_price2'),
                'margin_rate2' => lang_product('excel_margin_rate2'),
                'unit_mini_quantity2' => lang_product('excel_unit_mini_quantity2'),
                'unit_max_quantity2' => lang_product('excel_unit_max_quantity2'),

                'selling_price3' => lang_product('excel_selling_price3'),
                'margin_rate3' => lang_product('excel_margin_rate3'),
                'unit_mini_quantity3' => lang_product('excel_unit_mini_quantity3'),
                'unit_max_quantity3' => lang_product('excel_unit_max_quantity3'),

                'selling_price4' => lang_product('excel_selling_price4'),
                'margin_rate4' => lang_product('excel_margin_rate4'),
                'unit_mini_quantity4' => lang_product('excel_unit_mini_quantity4'),
                'unit_max_quantity4' => lang_product('excel_unit_max_quantity4'),

                'selling_price5' => lang_product('excel_selling_price5'),
                'margin_rate5' => lang_product('excel_margin_rate5'),
                'unit_mini_quantity5' => lang_product('excel_unit_mini_quantity5'),
                'unit_max_quantity5' => lang_product('excel_unit_max_quantity5'),

                'selling_price6' => lang_product('excel_selling_price6'),
                'margin_rate6' => lang_product('excel_margin_rate6'),
                'unit_mini_quantity6' => lang_product('excel_unit_mini_quantity6'),
                'unit_max_quantity6' => lang_product('excel_unit_max_quantity6'),
            ];

            //var_dump($headerColumns);
            //echo"<br>";
            //exit;
    


            if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType) { //Mode add item
                $headerColumns = [
                    'product_id' => lang_product('excel_product_id'),
                    'product_code' => lang_product('excel_product_code'),
                    'part_category' => lang_product('excel_part_category'),
                    'part_category2' => lang_product('excel_part_category2'),
                    'part_category3' => lang_product('excel_part_category3'),
                    'maker_seq' => lang_product('excel_maker_seq'),
                    'location_code' => lang_product('excel_location_code'),
                    'part_number' => lang_product('excel_part_number'),
                    'part_number_sequence' => lang_product('excel_part_number_sequence'),
                    'search_word' => lang_product('excel_search_word'),
                    'brief_description' => lang_product('excel_brief_description'),
                    'date_code' => lang_product('excel_date_code'),
                    'image_dir' => lang_product('excel_image_dir'),
                    'pdf_dir' => lang_product('excel_pdf_dir'),
                    'delivery_code' => lang_product('excel_delivery_code'),
                    'api_flg' => lang_product('excel_api_flg'),
                    'api_code' => lang_product('excel_api_code'),
                    // 'tariff_rate' => lang_product('excel_tariff_rate'),
                    'product_api_id' => lang_product('excel_product_api_id'),
                    'qty' => lang_product('excel_qty'),
                    'packing_code' => lang_product('excel_packing_code'),
                    'wearing_price' => lang_product('excel_wearing_price'),
                    'price' => lang_product('excel_price'),
                    'leadtime' => lang_product('excel_leadtime'),
                    'moq' => lang_product('excel_moq'),
                    'mpq' => lang_product('excel_mpq'),
                    'stock_location' => lang_product('excel_stock_location'),
                    'taxable' => lang_product('excel_taxable'),

                    'selling_price1' => lang_product('excel_selling_price1'),
                    'margin_rate1' => lang_product('excel_margin_rate1'),
                    'unit_mini_quantity1' => lang_product('excel_unit_mini_quantity1'),
                    'unit_max_quantity1' => lang_product('excel_unit_max_quantity1'),

                    'selling_price2' => lang_product('excel_selling_price2'),
                    'margin_rate2' => lang_product('excel_margin_rate2'),
                    'unit_mini_quantity2' => lang_product('excel_unit_mini_quantity2'),
                    'unit_max_quantity2' => lang_product('excel_unit_max_quantity2'),

                    'selling_price3' => lang_product('excel_selling_price3'),
                    'margin_rate3' => lang_product('excel_margin_rate3'),
                    'unit_mini_quantity3' => lang_product('excel_unit_mini_quantity3'),
                    'unit_max_quantity3' => lang_product('excel_unit_max_quantity3'),

                    'selling_price4' => lang_product('excel_selling_price4'),
                    'margin_rate4' => lang_product('excel_margin_rate4'),
                    'unit_mini_quantity4' => lang_product('excel_unit_mini_quantity4'),
                    'unit_max_quantity4' => lang_product('excel_unit_max_quantity4'),

                    'selling_price5' => lang_product('excel_selling_price5'),
                    'margin_rate5' => lang_product('excel_margin_rate5'),
                    'unit_mini_quantity5' => lang_product('excel_unit_mini_quantity5'),
                    'unit_max_quantity5' => lang_product('excel_unit_max_quantity5'),

                    'selling_price6' => lang_product('excel_selling_price6'),
                    'margin_rate6' => lang_product('excel_margin_rate6'),
                    'unit_mini_quantity6' => lang_product('excel_unit_mini_quantity6'),
                    'unit_max_quantity6' => lang_product('excel_unit_max_quantity6'),
                ];
            }

            $excelData = $this->excel->import($file, $headerColumns);


        var_dump($inputs);
        echo"<br>";
        var_dump($$excelData);
        echo"<br>";
        var_dump($headerColumns);
        echo"<br>";
        exit;


            $ret = $this->productService->importProduct($inputs,$excelData, $headerColumns);

            //var_dump($ret);
            //exit;

            if($ret['status'] == 1){
                return redirect()->route('admin.product.excel_upload.index')->with('error_message', $ret['error']);
            }
            $message = $ret['message'];
        }

        return redirect()->route('admin.product.excel_upload.index')->with('message', $message);
    }

}
