<?php namespace App\Controllers\Admin;

use App\Entities\LcscProductinfo;
use App\Entities\ExchangeInfo;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\LcscProductinfoModel;
//use App\Services\LcscProductinfoService;
use App\Models\ExchangeInfoModel;

class LcscProductinfoController extends BaseController
{
    protected $lcscProductinfoModel;
    //protected $lcscProductinfoService;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->lcscProductinfoModel = new LcscProductinfoModel();
        //$this->lcscProductinfoService = new LcscProductinfoService();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index()
    {
        // echo "Test OK!!";
        // exit;
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['mpn']) && $searchInput['mpn'] != '') $searchInput['is_search'] = true;
        $data = $this->lcscProductinfoModel->getAdmin($searchInput,$perPage);
        return $this->viewAdmin('lcscproductinfo/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels(){
        return [
            'mpn' => lang_common('mpn')
        ];
    }


    public function looptmp()
    {
        $data['maxFiles'] = 5;
        return $this->viewAdmin('lcscproductinfo/looptmp',$data);
    }

    public function upload(){
        $files = $this->request->getFiles();

        if(isset($files)){
            $file_count= 1;

            foreach ($files as $file){
                $fileName = $file->getClientName();

                if(isset($fileName) && !empty($fileName)){
                    $filePath = FileHelper::saveExFile($file, FileHelper::FOLDER_PATCH_UPLOAD_LOOPEXCEL, $file_count);
                }
            }
        }

        return redirect()->route('admin.lcscproductinfo.looptmp');  
    }

    public function deleteFile(){
        FileHelper::deleteCSVFile( FileHelper::FOLDER_PATCH_UPLOAD_LOOPEXCEL);
        // $this->lcscProductinfoModel->eraseTempProducts();

        $message = "이전 작업파일을 삭제했습니다.";
        return redirect()->route('admin.lcscproductinfo.looptmp')->with('message',$message);;
    }

    function loop_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;
		$cfg['upload_path']	    =  PUBLIC_PATH. 'upload/loopexcel/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}

    public function importCsvToDb()
    {

        // 디렉토리 갯수와 파일의 갯수 구하기

        $file_count =0;

		$loopexcel_path =  PUBLIC_PATH. 'upload/loopexcel/';
        $isDir = is_dir($loopexcel_path);

        if ($isDir) {

        $result = opendir($loopexcel_path); 

		while($file=readdir($result)) {
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
			} else {
			$file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
			}
		}

        // echo"디렉토리 갯수는:".$dir_count."<br>";
  		// echo"파일의 갯수는:".$file_count."<br>";
        // var_dump($file_count);
        // exit;

        // 디렉토리 갯수와 파일의 갯수 구하기 끝

	$file_countend = $file_count;

	for ($file_count =1;$file_count < $file_countend;$file_count ++) {
			
            $filecon = $file_count;
            $bs_filename = 'loop_data_';

            $this->loop_file_check($bs_filename, $filecon, 'csv');
            $loopfilepath = $this->filePath;

            //var_dump($loopfilepath);
            //echo"<br>";
            //exit;

                $file = fopen($loopfilepath,"r");
                
                $i = 0;
                $numberOfFields = 53;
                $csvArr = array();

                while (($filedata = fgetcsv($file, 5000, ",")) !== FALSE) {
                    $num = count($filedata);
                    //var_dump($num);
                    //exit;

                    if($i > 0 && $num == $numberOfFields){                         
                        // $timestr = date(time());

                        $csvArr[$i]['item_id'] = $filedata[0];
                        $csvArr[$i]['item_number'] = $filedata[1];
                        $csvArr[$i]['category_id1'] = $filedata[2];
                        $csvArr[$i]['category_name1'] = $filedata[3];
                        $csvArr[$i]['category_id2'] = $filedata[4];
                        $csvArr[$i]['category_name2'] = $filedata[5];
                        $csvArr[$i]['manufacturer_id'] = $filedata[6];
                        $csvArr[$i]['manufacturer_name'] = $filedata[7];
                        $csvArr[$i]['package'] = $filedata[8];
                        $csvArr[$i]['title'] = $filedata[9];
                        $csvArr[$i]['mpn'] = $filedata[10];
                        $csvArr[$i]['quantity'] = $filedata[11];
                        $csvArr[$i]['whs_js'] = $filedata[12];
                        $csvArr[$i]['whs_zh'] = $filedata[13];
                        $csvArr[$i]['whs_hk'] = $filedata[14];
                        $csvArr[$i]['moq'] = $filedata[15];
                        $csvArr[$i]['order_multiple'] = $filedata[16];
                        $csvArr[$i]['weight'] = $filedata[17];
                        $csvArr[$i]['packaging'] = $filedata[18];
                        $csvArr[$i]['sell_unit'] = $filedata[19];
                        $csvArr[$i]['packing_num'] = $filedata[20];
                        $csvArr[$i]['packing_unit'] = $filedata[21];
                        $csvArr[$i]['prices0_min_qty'] = $filedata[22];
                        $csvArr[$i]['prices0_max_qty'] = $filedata[23];
                        $csvArr[$i]['prices0_currency'] = $filedata[24];
                        $csvArr[$i]['prices0_price'] = $filedata[25];
                        $csvArr[$i]['prices1_min_qty'] = $filedata[26];
                        $csvArr[$i]['prices1_max_qty'] = $filedata[27];
                        $csvArr[$i]['prices1_currency'] = $filedata[28];
                        $csvArr[$i]['prices1_price'] = $filedata[29];
                        $csvArr[$i]['prices2_min_qty'] = $filedata[30];
                        $csvArr[$i]['prices2_max_qty'] = $filedata[31];
                        $csvArr[$i]['prices2_currency'] = $filedata[32];
                        $csvArr[$i]['prices2_price'] = $filedata[33];
                        $csvArr[$i]['prices3_min_qty'] = $filedata[34];
                        $csvArr[$i]['prices3_max_qty'] = $filedata[35];
                        $csvArr[$i]['prices3_currency'] = $filedata[36];
                        $csvArr[$i]['prices3_price'] = $filedata[37];
                        $csvArr[$i]['prices4_min_qty'] = $filedata[38];
                        $csvArr[$i]['prices4_max_qty'] = $filedata[39];
                        $csvArr[$i]['prices4_currency'] = $filedata[40];
                        $csvArr[$i]['prices4_price'] = $filedata[41];
                        $csvArr[$i]['prices5_min_qty'] = $filedata[42];
                        $csvArr[$i]['prices5_max_qty'] = $filedata[43];
                        $csvArr[$i]['prices5_currency'] = $filedata[44];
                        $csvArr[$i]['prices5_price'] = $filedata[45];
                        $csvArr[$i]['datasheet_pdf'] = $filedata[46];
                        $csvArr[$i]['images0'] = $filedata[47];
                        $csvArr[$i]['images1'] = $filedata[48];
                        $csvArr[$i]['images2'] = $filedata[49];
                        $csvArr[$i]['rohs'] = $filedata[50];
                        $csvArr[$i]['description'] = $filedata[51];
                        $csvArr[$i]['isPreSale'] = $filedata[52];

                        /*
                        $csvArr[$i]['item_id'] = $filedata[0];
                        $csvArr[$i]['item_number'] = $filedata[1];
                        $csvArr[$i]['category_id1'] = $filedata[2];
                        $csvArr[$i]['category_name1'] = $filedata[3];
                        $csvArr[$i]['category_id2'] = $filedata[4];
                        $csvArr[$i]['category_name2'] = $filedata[5];
                        $csvArr[$i]['manufacturer_id'] = $filedata[7];
                        $csvArr[$i]['manufacturer_name'] = $filedata[8];
                        $csvArr[$i]['package'] = $filedata[9];
                        $csvArr[$i]['title'] = $filedata[10];
                        $csvArr[$i]['mpn'] = $filedata[11];
                        $csvArr[$i]['quantity'] = $filedata[12];
                        $csvArr[$i]['whs_js'] = $filedata[13];
                        $csvArr[$i]['whs_zh'] = $filedata[14];
                        $csvArr[$i]['whs_hk'] = $filedata[15];
                        $csvArr[$i]['moq'] = $filedata[16];
                        $csvArr[$i]['order_multiple'] = $filedata[17];
                        $csvArr[$i]['weight'] = $filedata[18];
                        $csvArr[$i]['packaging'] = $filedata[19];
                        $csvArr[$i]['sell_unit'] = $filedata[20];
                        $csvArr[$i]['packing_num'] = $filedata[21];
                        $csvArr[$i]['packing_unit'] = $filedata[22];
                        $csvArr[$i]['prices0_min_qty'] = $filedata[23];
                        $csvArr[$i]['prices0_max_qty'] = $filedata[24];
                        $csvArr[$i]['prices0_currency'] = $filedata[25];
                        $csvArr[$i]['prices0_price'] = $filedata[26];
                        $csvArr[$i]['prices1_min_qty'] = $filedata[27];
                        $csvArr[$i]['prices1_max_qty'] = $filedata[28];
                        $csvArr[$i]['prices1_currency'] = $filedata[29];
                        $csvArr[$i]['prices1_price'] = $filedata[30];
                        $csvArr[$i]['prices2_min_qty'] = $filedata[31];
                        $csvArr[$i]['prices2_max_qty'] = $filedata[32];
                        $csvArr[$i]['prices2_currency'] = $filedata[33];
                        $csvArr[$i]['prices2_price'] = $filedata[34];
                        $csvArr[$i]['prices3_min_qty'] = $filedata[35];
                        $csvArr[$i]['prices3_max_qty'] = $filedata[36];
                        $csvArr[$i]['prices3_currency'] = $filedata[37];
                        $csvArr[$i]['prices3_price'] = $filedata[38];
                        $csvArr[$i]['prices4_min_qty'] = $filedata[39];
                        $csvArr[$i]['prices4_max_qty'] = $filedata[40];
                        $csvArr[$i]['prices4_currency'] = $filedata[41];
                        $csvArr[$i]['prices4_price'] = $filedata[42];
                        $csvArr[$i]['prices5_min_qty'] = $filedata[43];
                        $csvArr[$i]['prices5_max_qty'] = $filedata[44];
                        $csvArr[$i]['prices5_currency'] = $filedata[45];
                        $csvArr[$i]['prices5_price'] = $filedata[46];
                        $csvArr[$i]['datasheet_pdf'] = $filedata[47];
                        $csvArr[$i]['images0'] = $filedata[48];
                        $csvArr[$i]['images1'] = $filedata[49];
                        $csvArr[$i]['images2'] = $filedata[50];
                        $csvArr[$i]['rohs'] = $filedata[51];
                        $csvArr[$i]['description'] = $filedata[52];
                        $csvArr[$i]['isPreSale'] = $filedata[53];
                        */
                            
                        // var_dump($csvArr[$i]);
                        // exit;
                    }
                    $i++;

                }
                fclose($file);

                $count = 0;
                $lcscproductinfo = new LcscProductinfo();

                foreach($csvArr as $exceldata){
                    $lcscproductinfo->item_id = $exceldata['item_id'];
                    $lcscproductinfo->item_number = $exceldata['item_number'];
                    $lcscproductinfo->category_id1 = $exceldata['category_id1'];
                    $lcscproductinfo->category_name1 = $exceldata['category_name1'];
                    $lcscproductinfo->category_id2 = $exceldata['category_id2'];
                    $lcscproductinfo->category_name2 = $exceldata['category_name2'];
                    $lcscproductinfo->manufacturer_id = $exceldata['manufacturer_id'];
                    $lcscproductinfo->manufacturer_name = $exceldata['manufacturer_name'];
                    $lcscproductinfo->package = $exceldata['package'];
                    $lcscproductinfo->title = $exceldata['title'];
                    $lcscproductinfo->mpn = $exceldata['mpn'];
                    $lcscproductinfo->quantity = $exceldata['quantity'];
                    $lcscproductinfo->whs_js = $exceldata['whs_js'];
                    $lcscproductinfo->whs_zh = $exceldata['whs_zh'];
                    $lcscproductinfo->whs_hk = $exceldata['whs_hk'];
                    $lcscproductinfo->moq = $exceldata['moq'];
                    $lcscproductinfo->order_multiple = $exceldata['order_multiple'];
                    $lcscproductinfo->weight = $exceldata['weight'];
                    $lcscproductinfo->packaging = $exceldata['packaging'];
                    $lcscproductinfo->sell_unit = $exceldata['sell_unit'];
                    $lcscproductinfo->packing_num = $exceldata['packing_num'];
                    $lcscproductinfo->packing_unit = $exceldata['packing_unit'];
                    $lcscproductinfo->prices0_min_qty = $exceldata['prices0_min_qty'];
                    $lcscproductinfo->prices0_max_qty = $exceldata['prices0_max_qty'];
                    $lcscproductinfo->prices0_currency = $exceldata['prices0_currency'];
                    $lcscproductinfo->prices0_price = $exceldata['prices0_price'];
                    $lcscproductinfo->prices1_min_qty = $exceldata['prices1_min_qty'];
                    $lcscproductinfo->prices1_max_qty = $exceldata['prices1_max_qty'];
                    $lcscproductinfo->prices1_currency = $exceldata['prices1_currency'];
                    $lcscproductinfo->prices1_price = $exceldata['prices1_price'];
                    $lcscproductinfo->prices2_min_qty = $exceldata['prices2_min_qty'];
                    $lcscproductinfo->prices2_max_qty = $exceldata['prices2_max_qty'];
                    $lcscproductinfo->prices2_currency = $exceldata['prices2_currency'];
                    $lcscproductinfo->prices2_price = $exceldata['prices2_price'];
                    $lcscproductinfo->prices3_min_qty = $exceldata['prices3_min_qty'];
                    $lcscproductinfo->prices3_max_qty = $exceldata['prices3_max_qty'];
                    $lcscproductinfo->prices3_currency = $exceldata['prices3_currency'];
                    $lcscproductinfo->prices3_price = $exceldata['prices3_price'];
                    $lcscproductinfo->prices4_min_qty = $exceldata['prices4_min_qty'];
                    $lcscproductinfo->prices4_max_qty = $exceldata['prices4_max_qty'];
                    $lcscproductinfo->prices4_currency = $exceldata['prices4_currency'];
                    $lcscproductinfo->prices4_price = $exceldata['prices4_price'];
                    $lcscproductinfo->prices5_min_qty = $exceldata['prices5_min_qty'];
                    $lcscproductinfo->prices5_max_qty = $exceldata['prices5_max_qty'];
                    $lcscproductinfo->prices5_currency = $exceldata['prices5_currency'];
                    $lcscproductinfo->prices5_price = $exceldata['prices5_price'];
                    $lcscproductinfo->datasheet_pdf = $exceldata['datasheet_pdf'];
                    $lcscproductinfo->images0 = $exceldata['images0'];
                    $lcscproductinfo->images1 = $exceldata['images1'];
                    $lcscproductinfo->images2 = $exceldata['images2'];
                    $lcscproductinfo->rohs = $exceldata['rohs'];
                    $lcscproductinfo->description = $exceldata['description'];
                    $lcscproductinfo->isPreSale = $exceldata['isPreSale'];
                
                    // var_dump($lcscproductinfo);
                    // exit;

                    if( $this->lcscProductinfoModel->insert($lcscproductinfo)){
                        $count++;
                    }

                }

                $count_all = $count_all + $count;

    }

        $message = $count_all."개의 제품이 임시등록되었습니다.";
            return redirect()->route('admin.lcscproductinfo.index')->with('message',$message);
        } else {
            $message = "등록된 파일이 없습니다.";
            return redirect()->route('admin.lcscproductinfo.index')->with('message',$message);
        }

    }

    public function standardInfo(){
        $this->lcscProductinfoModel->insertSeqdata();

        $message = 'Pndata update success.';
        return redirect()->route('admin.lcscproductinfo.index')->with('message' , $message);
    }

    public function showCreate(){
        $this->rules = $this->lcscProductinfoModel->getValidationRules();

        return $this->viewAdmin('lcscproductinfo/create',$data);
    }


    public function create(){
        $this->rules = $this->lcscProductinfoModel->getValidationRules();
        if($this->checkValidation()){
            $this->lcscProductinfoService->saveLcscProductinfo($this->request,$accountManger->account_id);
            $message = 'Create LcscProductinfo success.';
            return redirect()->route('admin.lcscproductinfo.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('lcscproductinfo/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->lcscProductinfoModel->getValidationRules();
        $lcscProductinfoItem = $this->lcscProductinfoModel->find($id);

        $data['item'] = $lcscProductinfoItem;
        return $this->viewAdmin('lcscproductinfo/update', $data);
    }

    public function update($id){
        //var_dump($this->request);
        //exit;
        $this->rules = $this->lcscProductinfoModel->getValidationRules();

        if($this->checkValidation()){
            $this->lcscProductinfoService->updateLcscProductinfo($id,$this->request);

            $message = "Update lcscProductinfo success";
            return redirect()->route('admin.lcscproductinfo.index')->with('message',$message);
        }else{
            return view('admin/lcscProductinfo/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->lcscProductinfoService->deleteLcscProductinfo($ids);
            if($result) $message = "Delete lcscProductinfo success";
        }
        return redirect()->route('admin.lcscproductinfo.index')->with('message',$message);
    }

    public function inCode(){

        $dataRow = "3000";

        for($i=1;$i <= $dataRow;$i++){
            $lcscProductItem = $this->lcscProductinfoModel->where('product_code','0')->first();
            $id = $lcscProductItem->id;
            $categorylevel2_code = $lcscProductItem->categorylevel2_code;

            $insertcount = count($this->lcscProductinfoModel->where('categorylevel2_code',$categorylevel2_code)->where('product_code !=','0')->findAll())+1;
            $product_code = "CD".$categorylevel2_code.sprintf('%06d',$insertcount);

            $this->lcscProductinfoModel->updateCategoryCode($id, $product_code);

            echo $categorylevel2_code." / ".$id." / ".$product_code."<br>";
        }
    exit;

    }


    public function exchangeRat(){

        // $url = 'https://v6.exchangerate-api.com/v6/c8b12ee70053da2aeacac2f6/latest/HKD';
        $url = 'https://v6.exchangerate-api.com/v6/c8b12ee70053da2aeacac2f6/latest/USD';
        
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        $jsonExchange = json_decode($response,true);
        $standard_amount = round($jsonExchange["conversion_rates"]["KRW"], 2); 
        $counrty_code = $jsonExchange["base_code"];

        $exchangeInfo = new ExchangeInfo;
        $exchangeInfo = [
            'counrty_code'       => $counrty_code,
            'standard_amount'    => $standard_amount,
            'del_flg' => 0
        ];

        $this->exchangeInfoModel->save($exchangeInfo);
        return $exchangeInfo;
    }

    public function toProductInfo(){

        // $ExchangeRat = $this->exchangeRat();
        // $exchange_rat = $ExchangeRat["standard_amount"];
        $counrty_code = "USD";
        $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
        $exchange_rat = $ExchangeRat->standard_amount;

        $this->lcscProductinfoModel->insertProductInfo($exchange_rat);

        $this->lcscProductinfoModel->replaceProductInfo();

        $message = '제품정보를 등록 했습니다.';
        return redirect()->route('admin.productcreate.create_ok')->with('message', $message);

    }

}
