<?php namespace App\Controllers\Admin;

use App\Entities\LeadtimeCategory;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\LeadtimeCategoryModel;
use App\Services\LeadtimeCategorysService;

class LeadtimeController extends BaseController
{
    protected $leadtimeCategorysModel;
    protected $leadtimeCategorysService;

    public function __construct()
    {
        $this->leadtimeCategorysModel = new LeadtimeCategoryModel();
        $this->leadtimeCategorysService = new LeadtimeCategorysService();
    }

    public function index()
    {
        // echo "Packaging Unit.";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['days']) && $searchInput['days'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->leadtimeCategorysModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('leadtimecategory/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'days' => lang_common('days'),
            'leadtime_info' => lang_common('leadtime_info')
        ];
    }

    public function showCreate(){
        // echo "Packaging Unit.";
        // exit;
        $this->rules = $this->leadtimeCategorysModel->getValidationRules();
        return $this->viewAdmin('leadtimecategory/create',$data);
    }

    public function create(){
        $this->rules = $this->leadtimeCategorysModel->getValidationRules();

        if($this->checkValidation()){
            $this->leadtimeCategorysService->saveLeadtimeCategory($this->request);
            $message = '납기정보 등록 성공!';
            return redirect()->route('admin.leadtimecategorys.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('leadtimecategory/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($leadtime_id){
        $this->rules = $this->leadtimeCategorysModel->getValidationRules();
        $shippingCompanyItem = $this->leadtimeCategorysModel->find($leadtime_id);
        $data['item'] = $shippingCompanyItem;
        return $this->viewAdmin('leadtimecategory/update', $data);
    }

    public function update($leadtime_id){
        $this->rules = $this->leadtimeCategorysModel->getValidationRules();
        if($this->checkValidation()){
            $this->leadtimeCategorysService->updateLeadtimeCategory($leadtime_id,$this->request);
            $message = "납기정보 수정 성공!";
            return redirect()->route('admin.leadtimecategorys.index')->with('message',$message);
        }else{
            return view('admin/leadtimecategory/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $leadtime_ids = explode(',',$strIds);
            $result = $this->leadtimeCategorysService->deleteLeadtimeCategory($leadtime_ids);
            if($result) $message = "납기정보 삭제 성공!";
        }
        return redirect()->route('admin.leadtimecategorys.index')->with('message',$message);
    }

}
