<?php namespace App\Controllers\Admin;

use App\Helpers\DateHelper;
use App\Services\ProductService;
use CodeIgniter\HTTP\Files\UploadedFile;

class LoopUploadController extends BaseController
{

    protected $productService;

    public function __construct()
    {
        parent::__construct();
        $this->productService = new ProductService();
    }

    public function validationMapFieldLabels()
    {
        return [
            'file_upload' => 'File upload'
        ];
    }

    public function index()
    {
        $this->rules = [
            'file_upload' => 'required|ext_in[file_upload,xlsx,xls]'
        ];
        return $this->viewAdmin('products/loop/index');
    }

    public function downloadTemplate(){
        $fileName = 'sallist_sample_download.xls';
        $filePath = PUBLIC_PATH. 'upload/excel/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }


    function loop_file_check($filename, $filecon, $fileexe){

		$cfg					= array();
		$cfg['allowed_types']	= $fileexe;
		$cfg['file_name']		= $filename.$filecon;
		$cfg['upload_path']	    =  PUBLIC_PATH. 'upload/loopexcel/';
		$cfg['overwrite']		= TRUE;

			$this->fileName = $fileName;
			$this->filePath = $cfg['upload_path'] . $cfg['file_name'] . '.' . $cfg['allowed_types'];

	}

            /*
    public function curlupload() {

       // echo"작업테스트<br>";
       // exit;

        //------------------//
        $loopexcel_path =  PUBLIC_PATH. 'upload/loopexcel/loop_data_1.xlsx';

        $data = array();
        $data["excel"] = curl_file_create("FILE_REAL_PATH");
        
        $header = array();
        $header[] = 'Content-Type: multipart/form-data';
        $url = "https://chipdirect.co.kr/admin/product/excel/upload/import";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $res = curl_exec($ch);
        curl_close($ch);
        //------------------//

        $excel_path =  PUBLIC_PATH. 'upload/loopexcel/loop_data_1.xlsx';

        //------------------//
        $post_data = [
            'foo'      => 'bar',
            'file_upload' => new \CURLFile($excel_path),
        ];
        //------------------//

        //var_dump($post_data);
        //exit;

        //------------------//
        $client->request('POST', '/post', [
            'form_params' => [
                'foo' => 'bar',
                'baz' => ['hi', 'there'],
                'file_upload' => new \CURLFile($excel_path),
            ],
        ]);
        //------------------//

        $file =  new \CURLFile($excel_path);
        var_dump($file);
        exit;
    }
    */

    public function setMultipartFormData($arrayData){
	
        $fileData = $arrayData['fileContents'];
        $boundary = "^*******^";
        $data = "";
        unset($arrayData['fileContents']);
    
        foreach ($arrayData as $name => $content) {
            $data .= '--' . $boundary . '\r\n'
            . 'Content-Disposition: form-data; name="' . $name . '\"\r\n\r\n'
            . $content . '\r\n';
        }
            
        // 파일 데이터 저장
        $data .= '--' . $boundary . '\r\n'
            . 'Content-Disposition: form-data; name="file_upload"; filename="' . $arrayData['fileDir'] . '"' . '\r\n'
            . 'Content-Type:application/octet-stream' . '\r\n\r\n';
        $data .= $fileData . '\r\n';
        $data .= "--" . $boundary . '--\r\n';
    
        return $data;
       }

    public function upload(){
    

        // 디렉토리 갯수와 파일의 갯수 구하기

        $file_count =0;

		$loopexcel_path =  PUBLIC_PATH. 'upload/loopexcel/';
		$result=opendir($loopexcel_path); 

		while($file=readdir($result)) {
			
			if($file=="."||$file=="..") {continue;} // file명이 ".", ".." 이면 무시함
			$fileInfo = pathinfo($file);
			$fileExt = $fileInfo['extension']; // 파일의 확장자를 구함

			If (empty($fileExt)){
			$dir_count++; // 파일에 확장자가 없으면 디렉토리로 판단하여 dir_count를 증가시킴
			} else {
			$file_count++;// 파일에 확장자가 있으면 file_count를 증가시킴
			}

		}

        // echo"디렉토리 갯수는:".$dir_count."<br>";
  		// echo"파일의 갯수는:".$file_count."<br>";
        // var_dump($file_count);
        // exit;

        // 디렉토리 갯수와 파일의 갯수 구하기 끝

	$file_countend = $file_count + 1;

	for ($file_count =1;$file_count < $file_countend;$file_count ++) {
			
            $filecon = $file_count;
    
            $bs_filename = 'loop_data_';

            $this->loop_file_check($bs_filename, $filecon, 'xlsx');
            $loopfilepath = $this->filePath;
            var_dump($loopfilepath);
            echo"<br>";

            // $inputs = $this->request->getPost();
            // $file = $this->request->getFile('file_upload');
            // var_dump($file);
            // exit;

            // $filename = $_FILES[$loopfilepath]['tmp_name']; 
            // $handle = fopen($filename, "r"); 
            // $data = base64_encode(fread($handle, filesize($filename))); 
            // var_dump($data);
            // exit;



            
            ini_set('display_errors',1);

            $inputs = array('upload_type' => "2",);	
            var_dump($inputs);

            // $fileDir = "D:/00_Bitnami_Doc/RnD_SHOP/public/loop_data_1.xlsx";
            // $data = array(
            //     'upload_type' => "2",
            //     'fileDir' => $fileDir,	// 파일경로
            //     'fileContents' => file_get_contents($fileDir)	// 파일 내용
            // );	

            // $real_filename = $bs_filename.$filecon;
            // $file = new UploadedFile($fileDir, $real_filename,$mimeType,$size,$error);
            // var_dump($file);

            exit;

            /*
            $file = $loopfilepath;
            $is_file_exist = file_exists($loopfilepath);
            if ($is_file_exist) {
              echo 'Found it';
            }
            else {
              echo 'Not found.';
            }
            */

            /* --- */
            $message = "Upload success";
            if(isset($file)){
                $uploadType = $inputs['upload_type'];
                $headerColumns = [
                    //'product_code' => lang_product('loop_product_code'),
                    'part_category' => lang_product('loop_part_category'),
                    'part_category2' => lang_product('loop_part_category2'),
                    'part_category3' => lang_product('loop_part_category3'),
                    'maker_seq' => lang_product('loop_maker_seq'),
                    'location_code' => lang_product('loop_location_code'),
                    'part_number' => lang_product('loop_part_number'),
                    'part_number_sequence' => lang_product('loop_part_number_sequence'),
                    'search_word' => lang_product('loop_search_word'),
                    'brief_description' => lang_product('loop_brief_description'),
                    'date_code' => lang_product('loop_date_code'),
                    'image_dir' => lang_product('loop_image_dir'),
                    'pdf_dir' => lang_product('loop_pdf_dir'),
                    'delivery_code' => lang_product('loop_delivery_code'),
                    'api_flg' => lang_product('loop_api_flg'),
                    // 'api_code' => lang_product('loop_api_code'),
                    // 'tariff_rate' => lang_product('loop_tariff_rate'),
                    'product_api_id' => lang_product('loop_product_api_id'),
                    'qty' => lang_product('loop_qty'),
                    'packing_code' => lang_product('loop_packing_code'),
                    'wearing_price' => lang_product('loop_wearing_price'),
                    'price' => lang_product('loop_price'),
                    'leadtime' => lang_product('loop_leadtime'),
                    'moq' => lang_product('loop_moq'),
                    'mpq' => lang_product('loop_mpq'),
                    'stock_location' => lang_product('loop_stock_location'),
                    'taxable' => lang_product('loop_taxable'),
                    
                    'selling_price1' => lang_product('loop_selling_price1'),
                    'margin_rate1' => lang_product('loop_margin_rate1'),
                    'unit_mini_quantity1' => lang_product('loop_unit_mini_quantity1'),
                    'unit_max_quantity1' => lang_product('loop_unit_max_quantity1'),

                    'selling_price2' => lang_product('loop_selling_price2'),
                    'margin_rate2' => lang_product('loop_margin_rate2'),
                    'unit_mini_quantity2' => lang_product('loop_unit_mini_quantity2'),
                    'unit_max_quantity2' => lang_product('loop_unit_max_quantity2'),

                    'selling_price3' => lang_product('loop_selling_price3'),
                    'margin_rate3' => lang_product('loop_margin_rate3'),
                    'unit_mini_quantity3' => lang_product('loop_unit_mini_quantity3'),
                    'unit_max_quantity3' => lang_product('loop_unit_max_quantity3'),

                    'selling_price4' => lang_product('loop_selling_price4'),
                    'margin_rate4' => lang_product('loop_margin_rate4'),
                    'unit_mini_quantity4' => lang_product('loop_unit_mini_quantity4'),
                    'unit_max_quantity4' => lang_product('loop_unit_max_quantity4'),

                    'selling_price5' => lang_product('loop_selling_price5'),
                    'margin_rate5' => lang_product('loop_margin_rate5'),
                    'unit_mini_quantity5' => lang_product('loop_unit_mini_quantity5'),
                    'unit_max_quantity5' => lang_product('loop_unit_max_quantity5'),

                    'selling_price6' => lang_product('loop_selling_price6'),
                    'margin_rate6' => lang_product('loop_margin_rate6'),
                    'unit_mini_quantity6' => lang_product('loop_unit_mini_quantity6'),
                    'unit_max_quantity6' => lang_product('loop_unit_max_quantity6'),
                ];
                if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType) { //Mode add item
                    $headerColumns = [
                        'product_id' => lang_product('loop_product_id'),
                        'product_code' => lang_product('loop_product_code'),
                        'part_category' => lang_product('loop_part_category'),
                        'part_category2' => lang_product('loop_part_category2'),
                        'part_category3' => lang_product('loop_part_category3'),
                        'maker_seq' => lang_product('loop_maker_seq'),
                        'location_code' => lang_product('loop_location_code'),
                        'part_number' => lang_product('loop_part_number'),
                        'part_number_sequence' => lang_product('loop_part_number_sequence'),
                        'search_word' => lang_product('loop_search_word'),
                        'brief_description' => lang_product('loop_brief_description'),
                        'date_code' => lang_product('loop_date_code'),
                        'image_dir' => lang_product('loop_image_dir'),
                        'pdf_dir' => lang_product('loop_pdf_dir'),
                        'delivery_code' => lang_product('loop_delivery_code'),
                        'api_flg' => lang_product('loop_api_flg'),
                        // 'api_code' => lang_product('loop_api_code'),
                        // 'tariff_rate' => lang_product('loop_tariff_rate'),
                        'product_api_id' => lang_product('loop_product_api_id'),
                        'qty' => lang_product('loop_qty'),
                        'packing_code' => lang_product('loop_packing_code'),
                        'wearing_price' => lang_product('loop_wearing_price'),
                        'price' => lang_product('loop_price'),
                        'leadtime' => lang_product('loop_leadtime'),
                        'moq' => lang_product('loop_moq'),
                        'mpq' => lang_product('loop_mpq'),
                        'stock_location' => lang_product('loop_stock_location'),
                        'taxable' => lang_product('loop_taxable'),

                        'selling_price1' => lang_product('loop_selling_price1'),
                        'margin_rate1' => lang_product('loop_margin_rate1'),
                        'unit_mini_quantity1' => lang_product('loop_unit_mini_quantity1'),
                        'unit_max_quantity1' => lang_product('loop_unit_max_quantity1'),

                        'selling_price2' => lang_product('loop_selling_price2'),
                        'margin_rate2' => lang_product('loop_margin_rate2'),
                        'unit_mini_quantity2' => lang_product('loop_unit_mini_quantity2'),
                        'unit_max_quantity2' => lang_product('loop_unit_max_quantity2'),

                        'selling_price3' => lang_product('loop_selling_price3'),
                        'margin_rate3' => lang_product('loop_margin_rate3'),
                        'unit_mini_quantity3' => lang_product('loop_unit_mini_quantity3'),
                        'unit_max_quantity3' => lang_product('loop_unit_max_quantity3'),

                        'selling_price4' => lang_product('loop_selling_price4'),
                        'margin_rate4' => lang_product('loop_margin_rate4'),
                        'unit_mini_quantity4' => lang_product('loop_unit_mini_quantity4'),
                        'unit_max_quantity4' => lang_product('loop_unit_max_quantity4'),

                        'selling_price5' => lang_product('loop_selling_price5'),
                        'margin_rate5' => lang_product('loop_margin_rate5'),
                        'unit_mini_quantity5' => lang_product('loop_unit_mini_quantity5'),
                        'unit_max_quantity5' => lang_product('loop_unit_max_quantity5'),

                        'selling_price6' => lang_product('loop_selling_price6'),
                        'margin_rate6' => lang_product('loop_margin_rate6'),
                        'unit_mini_quantity6' => lang_product('loop_unit_mini_quantity6'),
                        'unit_max_quantity6' => lang_product('loop_unit_max_quantity6'),
                    ];
                }
                $excelData = $this->excel->import($file, $headerColumns);
                $ret = $this->productService->importProduct($inputs,$excelData, $headerColumns);
                if($ret['status'] == 1){
                    return redirect()->route('admin.product.loop_upload.index')->with('error_message', $ret['error']);
                }
                $message = $ret['message'];
            }

            /* -- */
            
        }

    exit;

        return redirect()->route('admin.product.loop_upload.index')->with('message', $message);
    }

}
