<?php namespace App\Controllers\Admin;

use App\Entities\AccountManager;
use App\Helpers\AuthHelpers;
use App\Helpers\FileHelper;
use App\Helpers\DateHelper;

use App\Models\AccountManagerModel;
use App\Models\AccountTypeModel;
use App\Services\AccountManagerService;

class ManagerController extends BaseController
{
    protected $accountModel;
    protected $accountTypeModel;
    protected $managerService;

    public function __construct()
    {
        $this->accountModel = new AccountManagerModel();
        $this->accountTypeModel = new AccountTypeModel();
        $this->managerService = new AccountManagerService();

    }

    public function index()
    {
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['full_name']) && $searchInput['full_name'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $types = $this->accountTypeModel->findAll();
        $data = $this->accountModel->getSearch($searchInput,$perPage);
        $data['types'] = $types;
        return $this->viewAdmin('manager/index',array_merge($data,$searchInput));
    }


    protected function validationMapFieldLabels()
    {
        return [
            'full_name' => 'Name',
            'email' => 'Email',
            'old_password' => 'Old Password',
            'new_password' => 'New Password',
            'pass_confirm' => 'Password Confirm',
        ];
    }

    public function showCreate(){
        $this->rules = $this->accountModel->getValidationRules();
        $types = $this->accountTypeModel->findAll();
        $data['types'] = $types;
        return $this->viewAdmin('manager/create',$data);
    }

    public function create(){
        $this->rules = $this->accountModel->getValidationRules(
            [
                'only' => ['full_name', 'email'],
                'except_rule' => [
                    'email' => 'is_unique'
                ]
            ]
        );

        $email = $this->request->getPost('email');

        if(isset($email)){

            // $inputs = $this->request->getPost();
            // var_dump($inputs);
            // exit;

            $this->managerService->saveAccountManager($this->request);

            $message = 'Create manager success.';
            return redirect()->route('admin.manager.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('manager/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($account_id){
        $account = $this->accountModel->find($account_id);
        $types = $this->accountTypeModel->findAll();
        $data['types'] = $types;
        $data['account'] = $account;
        $this->rules = $this->accountModel->getValidationRules(
            [
                'except_rule' => [
                    'email' => 'is_unique'
                ]
            ]
        );
        $this->rules['email'] = $this->rules['email'].'|is_unique[account_managers.email,account_id,'.$account->account_id.']';
        return $this->viewAdmin('manager/update',$data);
    }

    public function update($account_id){
        $this->rules = $this->accountModel->getValidationRules(
            [
                'only' => ['full_name', 'email'],
                'except_rule' => [
                    'email' => 'is_unique'
                ]
            ]
        );

        $info = $this->accountModel->find($account_id);
        $inputs = $this->request->getPost();
        if(isset($info)){
            $this->rules['email'] = $this->rules['email'].'|is_unique[account_managers.email,account_id,'.$account_id.']';
            $info->full_name = $this->request->getPost('full_name');
            $info->account_name = $this->request->getPost('account_name');
            $info->email = $this->request->getPost('email');
            $info->account_type_id = $this->request->getPost('account_type_id');
            if($this->checkValidation($inputs)){
                $fileImage = $this->request->getFile('avatar_dir');

                if(isset($fileImage) && !empty($fileImage->getClientName())){
                    FileHelper::deleteFile($info->avatar_dir);
                    $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_ACCOUNT, $account_id);
                    $info->avatar_dir = $fileImagePath;

                }

                $this->accountModel->save($info);
                AuthHelpers::setLoginAdmin($info->toSession());
                
                return redirect()->route('admin.manager.show_update',[$account_id])->with('message', 'Update Info Success');
            }else{
                return redirect()->route('admin.manager.show_update',[$account_id])->withInput();
            }
        }

        return redirect()->route('admin.manager.show_update',[$account_id])->with('error_message', 'Account do not exit.');
    }


}
