<?php namespace App\Controllers\Admin;

use App\Entities\Member;
use App\Entities\MemberSub;
use App\Entities\MemberFile;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use App\Models\MemberSubModel;
use App\Models\MemberFileModel;
use App\Services\MemberService;

class MemberController extends BaseController
{
    protected $memberModel;
    protected $memberSubModel;
    protected $memberFileModel;
    protected $memberService;

    public function __construct()
    {
        parent::__construct();
        $this->memberModel = new MemberModel();
        $this->memberSubModel = new MemberSubModel();
        $this->memberFileModel = new MemberFileModel();
        $this->memberService = new MemberService();
    }

    public function index(){
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['member_name']) && $searchInput['member_name'] != '' ) $searchInput['is_search'] = true;
        $data = $this->memberModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('members/index',array_merge($data, $searchInput));
    }

    public function showUpdate($memberId){
        $item = $this->memberModel->find($memberId);
        $membercode = $item->member_code;
        // var_dump($membercode);
        $subinfo = $this->memberSubModel->findByMemberCode($membercode);
        $files = $this->memberFileModel->where('members_id',$membercode)->findAll();

        $data['item'] = $item;
        $data['itemsub'] = $subinfo;
        $data['files'] = $files;
        return $this->viewAdmin('members/update',$data);
    }

    public function update($memberId){
        $member = $this->memberModel->find($memberId);
        if(isset($member)){
            $member->active_flg = get_public_id($this->request->getPost('active_flg'));
            $this->memberModel->save($member);
        }
        $message = "Update member success";
        return redirect()->route('admin.member.index')->with('message', $message);
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->memberService->deleteMember($ids);
            if($result) $message = "Delete member success";
        }
        return redirect()->route('admin.member.index')->with('message',$message);
    }

    public function accept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->memberService->acceptMember($ids);
            if($result) $message = "Accept member success";
        }
        return redirect()->to(route_to('admin.member.index').'?page=' . $page)->with('message',$message);
    }

    public function notAccept($strIds){
        $message = "";
        $page = $this->request->getGet('page');
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->memberService->acceptMember($ids, MEMBER_ACCEPT_OFF);
            if($result) $message = "Not Accept member success";
        }
        return redirect()->to(route_to('admin.member.index').'?page=' . $page)->with('message',$message);
    }

    public function resetPassword($memberId){
        ini_set('display_errors',1);
        $member = $this->memberModel->find($memberId);
        if(isset($member)){
            $pass = $digitsRandom = NumberHelper::generateRandom();
            $passMd5 = md5($pass);
            $member->password = $passMd5;
            $member->password_random = $pass;
            $this->memberModel->save($member);
        }
        $message = "Random password success";
        return redirect()->route('admin.member.update', [$memberId])->with('message',$message);
    }

    /*
    public function viewFile($membersId, $fileNo){
        $file = $this->memberFileModel->findMembersFile($membersId, $fileNo);
        //var_dump($file);
        //exit;
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }
    */

    
    public function downloadExcel(){

        ini_set('max_execution_time',600);
        $data = $this->memberModel->getSearchExl(17000);
        // var_dump($data["lists"]);
        // exit;

        $headerColumns = [

            lang_member('excel_member_id'),
            lang_member('excel_member_code'),
            lang_member('excel_member_name'),
            lang_member('excel_member_email'),
            lang_member('excel_category_id'),
            // lang_member('excel_password'),
            // lang_member('excel_password_random'),
            lang_member('excel_member_phone'),
            lang_member('excel_member_zipcode'),
            lang_member('excel_member_address1'),
            lang_member('excel_member_address2'),
            lang_member('excel_last_login_date'),
            lang_member('excel_api_type'),
            // lang_member('excel_avatar_dir'),
            // lang_member('excel_access_code'),
            // lang_member('excel_access_flg'),
            lang_member('excel_active_flg'),
            // lang_member('excel_del_flg'),
            lang_member('excel_created_at'),
            lang_member('excel_updated_at')
        ];


        $dataColumns = [
            Member::MEMBER_ID,
            Member::MEMBER_CODE,
            Member::MEMBER_NAME,
            Member::MEMBER_EMAIL,
            Member::CATEGORY_ID,
            // Member::PASSWORD,
            // Member::PASSWORD_RANDOM,
            Member::MEMBER_PHONE,
            Member::MEMBER_ZIPCODE,
            Member::MEMBER_ADDRESS1,
            Member::MEMBER_ADDRESS2,
            Member::LAST_LOGIN_DATE,
            Member::API_TYPE,
            // Member::AVATAR_DIR,
            // Member::ACCESS_CODE,
            // Member::ACCESS_FLG,
            Member::ACTIVE_FLG,
            // Member::DEL_FLG,
            Member::CREATED_AT,
            Member::UPDATED_AT
        ];

        $fileName = 'Member_List';
        $filePath = $this->excel->export($headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }

}
