<?php namespace App\Controllers\Admin;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use App\Services\NaverPayService;
use App\Models\OrderPartinfoModel;

class NaverCommerceApiController extends BaseController
{

    protected $memberModel;
    protected $emailHelper;
    protected $naverPayService;
    protected $orderpartinfoModel;   

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->emailHelper = new EmailHelper();
        $this->naverPayService = new NaverPayService();
        $this->orderpartinfoModel = new OrderPartinfoModel();
    }

    public function index(){   
        echo "There is a Naver Commerce Intro.";
        exit;
    }

    /*주문 수집 api*/
    public function ncGetorder(){
        $this->naverPayService->getOrder_get();

    }

    /*발주 처리 api*/    
    public function ncAllowOrder(){
        $seller_order_refer_no = $_GET['seller_order_refer_no'];
        $this->naverPayService->allowOrder($seller_order_refer_no);

    }

     /*자동발주 처리 api*/    
    public function ncAutoOrder(){
        $npay_newinfo = $this->orderpartinfoModel->where('orderchk_flg', "0")->Like('order_type',"NAV")->select("nav_productorder_code")->findAll();
        
        foreach ($npay_newinfo as $key => $item){
            $seller_order_refer_no =  $item->nav_productorder_code;
            $this->naverPayService->allowOrder($seller_order_refer_no);
        }

    }

    /*송장 연동 apii*/
    public function ncSetDelivery(){
        $seller_order_refer_no = $_GET['seller_order_refer_no'];
        $seller_deliver_code = $_GET['seller_deliver_code'];
        $seller_invoice_code = $_GET['seller_invoice_code'];

        $this->naverPayService->setDelivery($seller_order_refer_no,$seller_deliver_code,$seller_invoice_code);

    }

    /*취소 주문 수집 api*/
    public function ncGetCancel(){   
        $this->naverPayService->getCancel_get();
    }

    /*반품 주문 수집 api*/
    public function ncGetReturn(){   
        $this->naverPayService->getReturn_get();
    }

}
