<?php namespace App\Controllers\Admin;

use App\Entities\One2one;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\One2oneCategoryModel;
use App\Models\One2oneFileModel;
use App\Models\One2oneModel;
use App\Services\One2oneService;

class One2oneController extends BaseController
{
    protected $one2oneModel;
    protected $one2oneFileModel;
    protected $one2oneService;
    protected $one2oneCategoryModel;

    public function __construct()
    {
        $this->one2oneModel = new One2oneModel();
        $this->one2oneFileModel = new One2oneFileModel();
        $this->one2oneService = new One2oneService();
        $this->one2oneCategoryModel = new One2oneCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['category_id']) && $searchInput['category_id'] != '') || ( isset($searchInput['title']) && $searchInput['title'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $categories = $this->one2oneCategoryModel->findAll();
        $data = $this->one2oneModel->getSearch($searchInput,$perPage);
        $data['categories'] = $categories;
        return $this->viewAdmin('one2one/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->one2oneModel->getValidationRules();
        $categories = $this->one2oneCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('one2one/create',$data);
    }

    public function create(){
        $this->rules = $this->one2oneModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->one2oneService->saveOne2one($this->request,$accountManger->account_id);
            $message = 'Create one2one success.';
            return redirect()->route('admin.one2one.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('one2one/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->one2oneModel->getValidationRules();
        $one2oneItem = $this->one2oneModel->find($id);
        $files = $this->one2oneFileModel->where('one2one_id',$id)->findAll();
        $categories = $this->one2oneCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $one2oneItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('one2one/update', $data);
    }

    public function update($id){
        $this->rules = $this->one2oneModel->getValidationRules();
        if($this->checkValidation()){
            $this->one2oneService->updateOne2one($id,$this->request);
            $message = "Update one2one success";
            return redirect()->route('admin.one2one.index')->with('message',$message);
        }else{
            return view('admin/one2one/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteOne2one($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->one2oneService->deleteOne2one($ids);
            if($result) $message = "Delete one2one success";
        }
        return redirect()->route('admin.one2one.index')->with('message',$message);
    }

    public function deleteFile($one2oneId,$fileNo){
        $this->one2oneFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('admin.one2one.update',[$one2oneId])->with('message',$message);;
    }

}
