<?php namespace App\Controllers\Admin;

use App\Entities\PackagingUnit;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\PackagingUnitModel;
use App\Models\ApiinfoModel;
use App\Services\PackagingUnitService;

class PackagingUnitController extends BaseController
{
    protected $packagingUnitModel;
    protected $packagingUnitService;
    protected $apiinfoModel;

    public function __construct()
    {
        $this->packagingUnitModel = new PackagingUnitModel();
        $this->packagingUnitService = new PackagingUnitService();
        $this->apiinfoModel = new ApiinfoModel();
    }

    public function index()
    {
        // echo "Packaging Unit.";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['packing_code']) && $searchInput['packing_code'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->packagingUnitModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('packagingunit/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'packing_code' => lang_common('packing_code'),
            'packing_name' => lang_common('packing_name')
        ];
    }

    public function showCreate(){
        // echo "Packaging Unit.";
        // exit;
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $this->rules = $this->packagingUnitModel->getValidationRules();
        return $this->viewAdmin('packagingunit/create',$data);
    }

    public function create(){
        $this->rules = $this->packagingUnitModel->getValidationRules();
        if($this->checkValidation()){
            $this->packagingUnitService->savePackagingUnit($this->request);
            $message = 'Create packagingUnit success.';
            return redirect()->route('admin.packagingunit.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('packagingunit/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($packing_id){
        $this->rules = $this->packagingUnitModel->getValidationRules();
        $packagingUnitItem = $this->packagingUnitModel->find($packing_id);
        $data['item'] = $packagingUnitItem;
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        return $this->viewAdmin('packagingunit/update', $data);
    }

    public function update($packing_id){
        $this->rules = $this->packagingUnitModel->getValidationRules();
        if($this->checkValidation()){
            $this->packagingUnitService->updatePackagingUnit($packing_id,$this->request);
            $message = "Update packagingUnit success";
            return redirect()->route('admin.packagingunit.index')->with('message',$message);
        }else{
            return view('admin/packagingunit/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deletePackagingUnit($strIds){
        $message = "";
        if(isset($strIds)){
            $packing_ids = explode(',',$strIds);
            $result = $this->packagingUnitService->deletePackagingUnit($packing_ids);
            if($result) $message = "Delete packagingUnit success";
        }
        return redirect()->route('admin.packagingunit.index')->with('message',$message);
    }

}
