<?php namespace App\Controllers\Admin;

use App\Entities\Product;
use App\Helpers\AuthHelpers;
use App\Models\ProductModel;
use App\Models\ProductdetailModel;

// use App\Entities\ProductsShipping;

use App\Models\ProductsShippingModel;
use App\Models\ManufacturerModel;
use App\Services\ProductService;

use App\Models\LocationinfoModel;
use App\Models\DisplayinfoModel;
use App\Models\EventinfoModel;
use App\Models\ApiinfoModel;

use App\Models\Categorylevel1Model;
use App\Models\Categorylevel2Model;
use App\Models\Categorylevel3Model;
use App\Models\StocklocationCategoryModel;
use App\Models\LeadtimeCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\PackagingUnitModel;
use App\Models\ExchangeCounrtyModel;
use App\Models\ExchangeInfoModel;

class ProductController extends BaseController
{
    protected $productModel;
    protected $productdetailModel;
    protected $productsShippingModel;
    protected $productService;
    protected $manufacturerModel;
    protected $locationinfoModel;
    protected $displayinfoModel;
    protected $apiinfoModel;
    protected $eventinfoModel;
    protected $categorylevel1Model;
    protected $categorylevel2Model;
    protected $categorylevel3Model;
    protected $stocklocationCategoryModel;
    protected $leadtimeCategoryModel;
    protected $deliverycodesModel;
    protected $packagingUnitModel;
    protected $exchangeCounrtyModel;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->productModel = new ProductModel();
        $this->productdetailModel = new ProductdetailModel();
        $this->productService = new ProductService();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->manufacturerModel = new ManufacturerModel();

        $this->locationinfoModel = new LocationinfoModel();
        $this->displayinfoModel = new DisplayinfoModel();
        $this->eventinfoModel = new EventinfoModel();
        $this->apiinfoModel = new ApiinfoModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->categorylevel2Model = new Categorylevel2Model();
        $this->categorylevel3Model = new Categorylevel3Model();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->leadtimeCategoryModel = new LeadtimeCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->packagingUnitModel = new PackagingUnitModel();
        $this->exchangeCounrtyModel = new ExchangeCounrtyModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();

        if( isset($searchInput['part_number']) && $searchInput['part_number'] != '' ) $searchInput['is_search'] = true;
        $data = $this->productModel->getAdmin($searchInput, $perPage);
        return $this->viewAdmin('products/lists/index',array_merge($data, $searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'part_number' => lang_product('list_part_number'),
            'qty' => lang_product('list_qty'),
            'id' => lang_product('list_manufacturer'),
            'pdf_file' => 'PDF file'
        ];
    }

    public function showCreate(){
        $this->rules = $this->productModel->getValidationRules();
        $this->productModel->getMaxLengthRules();

        $data['manufacturers'] = $this->manufacturerModel->orderBy('name', 'ASC')->selectAll();
        $data['locationinfos'] = $this->locationinfoModel->selectAll();
        $data['displayinfos'] = $this->displayinfoModel->selectAll();
        $data['eventinfos'] = $this->eventinfoModel->getEventinfo();
        $data['exchangecounrty'] = $this->exchangeCounrtyModel->selectAll();
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->where('del_flg', 0)->findAll();
        $data['leadtimecategorys'] = $this->leadtimeCategoryModel->where('del_flg', 0)->findAll();
        $data['deliverycodes'] = $this->deliverycodesModel->where('del_flg', 0)->findAll();
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $data['packagingunits'] = $this->packagingUnitModel->where('del_flg', 0)->findAll();

        $categorylevel1Model = new Categorylevel1Model();
		$data['categorylevel1'] = $categorylevel1Model->where('del_flg', 0)->orderBy('categorylevel1_name', 'ASC')->findAll();

        AuthHelpers::clearProdCode();
        $product_code = AuthHelpers::getProdCode();
        
        if(!$product_code) {
        $lastProduct = $this->productModel->getLastproduct();
        $lists = $lastProduct["lists"];

            foreach ($lists as $item){
                // var_dump($item->product_code);
                // echo "<br>";
                $lastcout = substr($item->product_code, 1);
                // var_dump($lastcout);
            }

        $totalproduct_count = $lastcout+1;
        $codecount = str_pad($totalproduct_count, 9, "0", STR_PAD_LEFT);
        $productcode = "C".$codecount;
        AuthHelpers::setProdCode($productcode);
        }

        return $this->viewAdmin('products/lists/create',$data);
    }

    public function create(){
        $insertId = $this->productService->saveProductList($this->request);

        $message = '제품정보를 등록 했습니다.';
        return redirect()->route('admin.productcreate.create_ok')->with('message', $message);

    }


    public function createOk(){

        return $this->viewAdmin('products/lists/createok', $data);

    }

    
    public function showUpdate($id){
        $product = $this->productModel->find($id);
        $product_code = $product->product_code;        

        $productdetail = $this->productdetailModel->where('product_code',$product_code)->first();
        $productsshipping = $this->productsShippingModel->getProductsshipping($product_code);

        // var_dump($productdetail);
        // exit;
        
        $this->rules = $this->productModel->getValidationRules();

        $data['manufacturers'] =$this->manufacturerModel->orderBy('name', 'ASC')->selectAll();
		$data['categorylevel1'] = $this->categorylevel1Model->where('del_flg', 0)->orderBy('categorylevel1_name', 'ASC')->findAll();
		$data['categorylevel2'] = $this->categorylevel2Model->where('del_flg', 0)->orderBy('categorylevel2_name', 'ASC')->findAll();
		$data['categorylevel3'] = $this->categorylevel3Model->where('del_flg', 0)->orderBy('categorylevel3_name', 'ASC')->findAll();
        $data['locationinfos'] = $this->locationinfoModel->selectAll();
        $data['eventinfos'] = $this->eventinfoModel->getEventinfo();
        $data['exchangecounrty'] = $this->exchangeCounrtyModel->selectAll();
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->where('del_flg', 0)->findAll();
        $data['leadtimecategorys'] = $this->leadtimeCategoryModel->where('del_flg', 0)->findAll();
        $data['deliverycodes'] = $this->deliverycodesModel->where('del_flg', 0)->findAll();
        $data['apiinfos'] = $this->apiinfoModel->selectAll();
        $data['packagingunits'] = $this->packagingUnitModel->where('del_flg', 0)->findAll();

        $data['product'] = $product;
        $data['productdetail'] = $productdetail;
        $data['productsshipping'] = $productsshipping;

        return $this->viewAdmin('products/lists/update', $data);
    }

    public function update($id){
            $this->productService->uploadProductListProduct($id,$this->request);

            $message = '제품정보를 업데이트 했습니다.';
            return redirect()->route('admin.product.index')->with('message', $message);

    }


    public function upshowwindow($id){
        $showwindow_mode = $this->request->getPost('showwindow_mode');
        $this->productModel->insertShowwindow($id,$showwindow_mode);
        // exit;

        $message = '제품정보를 메인페이지 추가했습니다.';
        return redirect()->route('admin.product.index')->with('message', $message);
    }


    public function delete($strIds){

        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->productService->deleteProductProduct($ids);
            if($result) $message = "제품정보를 삭제했습니다.";
        }
        return redirect()->route('admin.product.index')->with('message',$message);
    }

    public function deleteAll(){
        $message = "제품정보를 모두 삭제했습니다.";
        $this->productService->deleteAllProductProduct();
        return redirect()->route('admin.product.index')->with('message',$message);
    }

    public function downloadExcel(){
        $searchInput = $this->request->getGet();
        ini_set('max_execution_time',600);
        $data = $this->productModel->getSearchExcel($searchInput, 10000, true);
        // $data = $this->productModel->getSearch(null, 300000, true);

        //var_dump($data["lists"]);
        //exit;

        $headerColumns = [
            // lang_product('excel_product_id'),
            lang_product('excel_product_code'),
            // lang_product('excel_part_category'),
            lang_product('excel_category1_name'),
            // lang_product('excel_part_category2'),
            lang_product('excel_category2_name'),
            // lang_product('excel_part_category3'),
            // lang_product('excel_category3_name'),
            // lang_product('excel_maker_seq'),
            lang_product('excel_maker_name'),
            // lang_product('excel_display_set'),
            // lang_product('excel_newproduct_chk'),
            // lang_product('excel_bestproduct_chk'),
            // lang_product('excel_recomproduct_chk'),
            // lang_product('excel_brandproduct_chk'),
            // lang_product('excel_event_set'),
            lang_product('excel_part_number'),
            lang_product('excel_part_number_sequence'),
            // lang_product('excel_search_word'),
            lang_product('excel_brief_description'),
            // lang_product('excel_situation'),
            // lang_product('excel_exposure'),
            // lang_product('excel_product_related'),
            lang_product('excel_date_code'),
            lang_product('excel_image_dir'),
            lang_product('excel_delivery_code'),
            lang_product('excel_api_flg'),
            lang_product('excel_api_code'),
            // lang_product('excel_tariff_rate'),
            lang_product('excel_product_api_id'),
            lang_product('excel_qty'),
            lang_product('excel_packing_code'),
            // lang_product('excel_wearing_price'),
            // lang_product('excel_price'),
            lang_product('excel_leadtime'),
            lang_product('excel_moq'),
            lang_product('excel_mpq'),
            lang_product('excel_stock_location'),
            // lang_product('excel_taxable'),

            lang_product('excel_selling_price1'),
            // lang_product('excel_margin_rate1'),
            lang_product('excel_unit_mini_quantity1'),
            lang_product('excel_unit_max_quantity1'),

            lang_product('excel_selling_price2'),
            // lang_product('excel_margin_rate2'),
            lang_product('excel_unit_mini_quantity2'),
            lang_product('excel_unit_max_quantity2'),

            lang_product('excel_selling_price3'),
            // lang_product('excel_margin_rate3'),
            lang_product('excel_unit_mini_quantity3'),
            lang_product('excel_unit_max_quantity3'),

            lang_product('excel_selling_price4'),
            // lang_product('excel_margin_rate4'),
            lang_product('excel_unit_mini_quantity4'),
            lang_product('excel_unit_max_quantity4'),

            lang_product('excel_selling_price5'),
            // lang_product('excel_margin_rate5'),
            lang_product('excel_unit_mini_quantity5'),
            lang_product('excel_unit_max_quantity5'),

            lang_product('excel_selling_price6'),
            // lang_product('excel_margin_rate6'),
            lang_product('excel_unit_mini_quantity6'),
            lang_product('excel_unit_max_quantity6'),

            // lang_product('excel_active_flg'),
            // lang_product('excel_del_flg'),
            // lang_product('excel_created_at'),
            lang_product('excel_updated_at')
        ];


        $dataColumns = [
            // Product::PRODUCT_ID,
            Product::PRODUCT_CODE,
            // Product::PART_CATEGORY,
            Product::PART_CATEGORY_NAME,
            // Product::PART_CATEGORY2,
            Product::PART_CATEGORY2_NAME,
            // Product::PART_CATEGORY3,
            // Product::PART_CATEGORY3_NAME,
            // Product::MAKER_SEQ,
            Product::MAKER_NAME,
            // Product::DISPLAY_SET,
            // Product::NEWPRODUCT_CHK,
            // Product::BESTPRODUCT_CHK,
            // Product::RECOMPRODUCT_CHK,
            // Product::BRANDPRODUCT_CHK,
            // Product::EVENT_SET,
            Product::PART_NUMBER,
            Product::part_number_sequence,
            // Product::SEARCH_WORD,
            Product::BRIEF_DESCRIPTION,
            // Product::SITUATION,
            // Product::EXPOSURE,
            // Product::PRODUCT_RELATED,
            Product::DATE_CODE,
            Product::IMAGE_DIR,
            Product::DELIVERY_CODE,
            Product::API_FLG,
            Product::API_CODE,
            // Product::TARIFF_RATE,
            Product::PRODUCT_API_ID,
            Product::QTY,
            Product::PACKING_CODE,
            // Product::WEARING_PRICE,
            // Product::PRICE,
            Product::LEADTIME,
            Product::MOQ,
            Product::MPQ,
            Product::STOCK_LOCATION,
            // Product::TAXABLE,

            Product::SELLING_PRICE1,
            // Product::MARGIN_RATE1,
            Product::unit_mini_quantity1,
            Product::UNIT_MAX_QUANTITY1,

            Product::SELLING_PRICE2,
            // Product::MARGIN_RATE2,
            Product::unit_mini_quantity2,
            Product::UNIT_MAX_QUANTITY2,

            Product::SELLING_PRICE3,
            // Product::MARGIN_RATE3,
            Product::unit_mini_quantity3,
            Product::UNIT_MAX_QUANTITY3,

            Product::SELLING_PRICE4,
            // Product::MARGIN_RATE4,
            Product::unit_mini_quantity4,
            Product::UNIT_MAX_QUANTITY4,

            Product::SELLING_PRICE5,
            // Product::MARGIN_RATE5,
            Product::unit_mini_quantity5,
            Product::UNIT_MAX_QUANTITY5,

            Product::SELLING_PRICE6,
            // Product::MARGIN_RATE6,
            Product::unit_mini_quantity6,
            Product::UNIT_MAX_QUANTITY6,

            // Product::ACTIVE_FLG,
            // Product::DEL_FLG,
            // Product::CREATED_AT,
            Product::UPDATED_AT
        ];

        // var_dump($data["lists"]);
        // exit;

        $fileName = 'Product_List';
        $filePath = $this->excel->export($headerColumns, $data["lists"], $dataColumns,['file_name' => $fileName]);
        $this->setHeaderDownload($fileName.'.xlsx', PUBLIC_PATH . $filePath);
        exit;
    }

//  Function Input
    public function showInput(){
        return $this->viewAdmin('products/inputs/index');
    }

    public function updatePrice(){
        $this->productModel->updatePriceExch();

        $message = '최신 환율정보로 업데이트했습니다.';
        return redirect()->route('admin.product.index')->with('message', $message);
    }

}
