<?php namespace App\Controllers\Admin;

use App\Entities\SearchRanking;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
//use App\Models\SearchRankingCategoryModel;
use App\Models\SearchRankingModel;
use App\Services\SearchRankingService;

class SearchRankingController extends BaseController
{
    protected $searchrankingModel;
    protected $searchrankingService;
    //protected $deliverycodeCategoryModel;

    public function __construct()
    {
        $this->searchrankingModel = new SearchRankingModel();
        $this->searchrankingService = new SearchRankingService();
        //$this->deliverycodeCategoryModel = new SearchRankingCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if((isset($searchInput['word']) && $searchInput['word'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        // $categories = $this->deliverycodeCategoryModel->findAll();
        $data = $this->searchrankingModel->getSearch($searchInput,$perPage);
        //$data['categories'] = $categories;

        return $this->viewAdmin('searchranking/index',array_merge($data,$searchInput));
    }

    /*
    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->searchrankingModel->getValidationRules();
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('searchranking/create',$data);
    }

    public function create(){
        $this->rules = $this->searchrankingModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->searchrankingService->saveSearchRanking($this->request,$accountManger->account_id);
            $message = 'Create searchranking success.';
            return redirect()->route('admin.searchranking.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('searchranking/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->searchrankingModel->getValidationRules();
        $searchrankingItem = $this->searchrankingModel->find($id);
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $searchrankingItem;
        return $this->viewAdmin('searchranking/update', $data);
    }

    public function update($id){
        $this->rules = $this->searchrankingModel->getValidationRules();
        if($this->checkValidation()){
            $this->searchrankingService->updateSearchRanking($id,$this->request);
            $message = "Update searchranking success";
            return redirect()->route('admin.searchranking.index')->with('message',$message);
        }else{
            return view('admin/searchranking/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteSearchRanking($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->searchrankingService->deleteSearchRanking($ids);
            if($result) $message = "Delete searchranking success";
        }
        return redirect()->route('admin.searchranking.index')->with('message',$message);
    }

    public function deleteFile($searchrankingId,$fileNo){
        $message = "Delete file success";
        return redirect()->route('admin.searchranking.update',[$searchrankingId])->with('message',$message);;
    }
    */

}
