<?php namespace App\Controllers\Admin;

use App\Entities\SearchToday;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
//use App\Models\SearchTodayCategoryModel;
use App\Models\SearchTodayModel;
use App\Services\SearchTodayService;

class SearchTodayController extends BaseController
{
    protected $searchtodayModel;
    protected $searchtodayService;
    //protected $deliverycodeCategoryModel;

    public function __construct()
    {
        $this->searchtodayModel = new SearchTodayModel();
        $this->searchtodayService = new SearchTodayService();
        //$this->deliverycodeCategoryModel = new SearchTodayCategoryModel();
    }

    public function index()
    {
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if((isset($searchInput['word']) && $searchInput['word'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        // $categories = $this->deliverycodeCategoryModel->findAll();
        $data = $this->searchtodayModel->getSearch($searchInput,$perPage);
        //$data['categories'] = $categories;

        return $this->viewAdmin('searchtoday/index',array_merge($data,$searchInput));
    }

    /*
    protected function validationMapFieldLabels(){
        return [
            'title' => lang_common('title'),
            'content' => lang_common('content')
        ];
    }

    public function showCreate(){
        $this->rules = $this->searchtodayModel->getValidationRules();
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        return $this->viewAdmin('searchtoday/create',$data);
    }

    public function create(){
        $this->rules = $this->searchtodayModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->searchtodayService->saveSearchToday($this->request,$accountManger->account_id);
            $message = 'Create searchtoday success.';
            return redirect()->route('admin.searchtoday.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('searchtoday/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->searchtodayModel->getValidationRules();
        $searchtodayItem = $this->searchtodayModel->find($id);
        $categories = $this->deliverycodeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $searchtodayItem;
        return $this->viewAdmin('searchtoday/update', $data);
    }

    public function update($id){
        $this->rules = $this->searchtodayModel->getValidationRules();
        if($this->checkValidation()){
            $this->searchtodayService->updateSearchToday($id,$this->request);
            $message = "Update searchtoday success";
            return redirect()->route('admin.searchtoday.index')->with('message',$message);
        }else{
            return view('admin/searchtoday/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteSearchToday($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->searchtodayService->deleteSearchToday($ids);
            if($result) $message = "Delete searchtoday success";
        }
        return redirect()->route('admin.searchtoday.index')->with('message',$message);
    }

    public function deleteFile($searchtodayId,$fileNo){
        $message = "Delete file success";
        return redirect()->route('admin.searchtoday.update',[$searchtodayId])->with('message',$message);;
    }
    */

}
