<?php namespace App\Controllers\Admin;

use App\Entities\SelpaDataInfo;
use App\Entities\ExchangeInfo;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\SelpaDataInfoModel;
use App\Models\ExchangeInfoModel;

class SelpaDataInfoController extends BaseController
{
    protected $selpaDataInfoModel;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->selpaDataInfoModel = new SelpaDataInfoModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index()
    {
        // echo "Test OK!!";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(isset($searchInput['mpn']) && $searchInput['mpn'] != '') $searchInput['is_search'] = true;
        $data = $this->selpaDataInfoModel->getAdmin($searchInput,$perPage);
        return $this->viewAdmin('selpadatainfo/index',array_merge($data,$searchInput));
    }


    public function itemToDb()
    {
        // echo "Test itemToDb!!";
        // exit;

    }

    public function toProductInfo(){

        // $this->selpaDataInfoModel->tidyupProductInfo();
        $this->selpaDataInfoModel->insertProductInfo();
        // $this->selpaDataInfoModel->replaceProductInfo();

        $message = '제품정보를 등록 했습니다.';
        return redirect()->route('admin.productcreate.create_ok')->with('message', $message);

    }

    public function skuInfo()
    {
    
        $appid = 'SELPASEMICOM$CO$LTD_690';
        $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
        $timestamp = time();

        $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

        $url = 'https://openapi.ickey.cn/v2/new-token/create';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {

            echo 'no response';
            exit;
        }else{

            $tokenres = json_decode($response,true);
            $token = $tokenres["result"]["token"];
        
            $limit = 5;
            $skulist = $this->selpaDataInfoModel->getSku($limit);

            foreach ($skulist['lists'] as $key => $item){
                $sku .= '&sku['.$key.']='.$item->sku;

            }

            echo $sku;
            exit;

            $url = 'https://openapi.ickey.cn/search-v1/products/sku-info';
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';
        
            $host_info = explode("/", $url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $ch_item = curl_init();
        
            curl_setopt($ch_item, CURLOPT_PORT, $port);
            curl_setopt($ch_item, CURLOPT_URL, $url);
            curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.''.$sku);
        
            $response_item = curl_exec($ch_item);
        
            curl_close($ch_item);
        
            if (!$response_item) {
                echo '<br>no response';
            }else{
                echo $response_item;
            }
        
        }

    }
    
    
    public function standardInfo(){
        $this->selpaDataInfoModel->insertSeqdata();

        $message = 'Pndata update success.';
        return redirect()->route('admin.selpadatainfo.index')->with('message' , $message);
    }

}
