<?php namespace App\Controllers\Admin;

use App\Entities\StocklocationCategory;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\StocklocationCategoryModel;
use App\Services\StocklocationCategorysService;

class StocklocationController extends BaseController
{
    protected $stocklocationCategorysModel;
    protected $stocklocationCategorysService;

    public function __construct()
    {
        $this->stocklocationCategorysModel = new StocklocationCategoryModel();
        $this->stocklocationCategorysService = new StocklocationCategorysService();
    }

    public function index()
    {
        //echo "Packaging Unit.";
        //exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if(( isset($searchInput['location_info']) && $searchInput['location_info'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->stocklocationCategorysModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('stocklocationcategory/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'location_info' => lang_common('location_info')
        ];
    }

    public function showCreate(){
        $this->rules = $this->stocklocationCategorysModel->getValidationRules();
        return $this->viewAdmin('stocklocationcategory/create',$data);
    }

    public function create(){
        $this->rules = $this->stocklocationCategorysModel->getValidationRules();

        if($this->checkValidation()){
            $this->stocklocationCategorysService->saveStocklocationCategory($this->request);
            $message = '배송사정보 등록 성공!';
            return redirect()->route('admin.stocklocationcategorys.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('stocklocationcategory/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($location_id){
        $this->rules = $this->stocklocationCategorysModel->getValidationRules();
        $shippingCompanyItem = $this->stocklocationCategorysModel->find($location_id);
        $data['item'] = $shippingCompanyItem;
        return $this->viewAdmin('stocklocationcategory/update', $data);
    }

    public function update($location_id){
        $this->rules = $this->stocklocationCategorysModel->getValidationRules();
        if($this->checkValidation()){
            $this->stocklocationCategorysService->updateStocklocationCategory($location_id,$this->request);
            $message = "배송사정보 수정 성공!";
            return redirect()->route('admin.stocklocationcategorys.index')->with('message',$message);
        }else{
            return view('admin/stocklocationcategory/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function delete($strIds){
        $message = "";
        if(isset($strIds)){
            $location_ids = explode(',',$strIds);
            $result = $this->stocklocationCategorysService->deleteStocklocationCategory($location_ids);
            if($result) $message = "배송사정보 삭제 성공!";
        }
        return redirect()->route('admin.stocklocationcategorys.index')->with('message',$message);
    }

}
