<?php namespace App\Controllers\Admin;

use App\Entities\Todaystat;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\TodaystatModel;
use App\Services\TodaystatService;


class TodayStatController extends BaseController
{
    protected $todaystatModel;
    protected $todaystatService;

    public function __construct()
    {
        $this->todaystatModel = new TodaystatModel();
        $this->todaystatService = new TodaystatService();
    }

    public function index()
    {
        // echo "Test";
        // exit;

        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( ( isset($searchInput['todaypayment']) && $searchInput['todaypayment'] != '') || ( isset($searchInput['todayorder']) && $searchInput['todayorder'] != '')) $searchInput['is_search'] = true;
        $searchInput['is_search'] = true;
        $data = $this->todaystatModel->getSearch($searchInput,$perPage);
        return $this->viewAdmin('todaystat/index',array_merge($data,$searchInput));
    }

    protected function validationMapFieldLabels(){
        return [
            'todayorder' => lang_common('todayorder'),
            'todaysales' => lang_common('todaysales')
        ];
    }

    public function showCreate(){
        $this->rules = $this->todaystatModel->getValidationRules();
        //$categories = $this->todaystatCategoryModel->findAll();
        //$data['categories'] = $categories;
        //$data['maxFiles'] = 10;
        return $this->viewAdmin('todaystat/create',$data);
    }

    public function create(){
        $this->rules = $this->todaystatModel->getValidationRules();
        if($this->checkValidation()){
            $accountManger = AuthHelpers::getLoginInfoAdmin();
            $this->todaystatService->saveTodaystat($this->request,$accountManger->account_id);
            $message = 'Create todaystat success.';
            return redirect()->route('admin.todaystat.index')->with('message' , $message);
        }else{
            return $this->viewAdmin('todaystat/create', [
                'validator' => $this->validator
            ]);
        }
    }

    public function showUpdate($id){
        $this->rules = $this->todaystatModel->getValidationRules();
        $todaystatItem = $this->todaystatModel->find($id);
        //$files = $this->todaystatFileModel->where('todaystat_id',$id)->findAll();
        $data['item'] = $todaystatItem;

        $item_code = $todaystatItem->item_code;
        //$productinfo = $this->productModel->findByProductCode($item_code);
        //$data['productinfo'] = $productinfo;
        // var_dump ($data['productinfo']);
        // exit;

        //$categories = $this->todaystatCategoryModel->findAll();
        //$data['categories'] = $categories;
        //$data['item'] = $todaystatItem;
        //$data['files'] = $files;
        //$data['maxFiles'] = 10 - count($files);
        return $this->viewAdmin('todaystat/update', $data);
    }

    public function update($id){
        $this->rules = $this->todaystatModel->getValidationRules();
        if($this->checkValidation()){
            $this->todaystatService->updateTodaystat($id,$this->request);
            $message = "Update todaystat success";
            return redirect()->route('admin.todaystat.index')->with('message',$message);
        }else{
            return view('admin/todaystat/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteTodaystat($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->todaystatService->deleteTodaystat($ids);
            if($result) $message = "Delete todaystat success";
        }
        return redirect()->route('admin.todaystat.index')->with('message',$message);
    }

}
