<?php namespace App\Controllers\Common;

use App\Controllers\BaseController;
use Config\Database;

class ValidationController extends BaseController
{
    private $db;

    public function __construct()
    {
        $this->db = Database::connect();
    }

    public function is_unique_ajax(){
        $str = $this->request->getGet('param1');
        $field = $this->request->getGet('param2');

        try{
            // Grab any data for exclusion of a single row.
            list($field, $ignoreField, $ignoreValue) = array_pad(explode(',', $field), 3, null);

            // Break the table and field apart
            sscanf($field, '%[^.].%[^.]', $table, $field);

            $exitDel = $this->db->fieldExists('del_flg',$table);

            if($exitDel){
                $row = $this->db->table($table)
                    ->select('1')
                    ->where('del_flg', DELETE_FLG_OFF)
                    ->where($field, $str)
                    ->limit(1);
            }else{
                $row = $this->db->table($table)
                    ->select('1')
                    ->where($field, $str)
                    ->limit(1);
            }

            if (! empty($ignoreField) && ! empty($ignoreValue))
            {
                $row = $row->where("{$ignoreField} !=", $ignoreValue);
            }

            $result = ($row->get()
                    ->getRow() === null);
            $data = ['status' => $result];
            return json_encode($data);
        }catch (\Throwable $ex){}

        $data = ['status' => false];
        return json_encode($data);
    }

    //--------------------------------------------------------------------

}
