<?php 
namespace App\Controllers\Guest;

use App\Controllers\Guest\BaseController;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use Config\Services;

// use App\Entities\Member;
use App\Entities\SearchToday;
use App\Entities\SearchRanking;

// use App\Models\MemberModel;
use App\Models\SearchTodayModel;
use App\Models\SearchRankingModel;

class AutoEventController extends BaseController
{

    // protected $memberModel;
    protected $searchTodayModel;
    protected $searchRankingModel;

    public function __construct()
    {
        // $this->memberModel = new MemberModel();
        $this->searchTodayModel = new SearchTodayModel();
        $this->searchRankingModel = new SearchRankingModel();

    }

    public function index(){   
        echo "There is a Test.";
        exit;
        //return $this->viewGuest('autoevent/index');
    }

    public function searchRanking(){   
        // $today = date('Y-m-d h:i:s ', time());
        $todayKeyword = $this->searchTodayModel->orderBy('created_at', 'ASC')->findAll();

        //$day_ago = date('Y-m-d h:i:s', strtotime('-1 Day'));
        //$todayKeyword = $this->searchTodayModel->where("created_at >=", DateHelper::setFirstHourMinuteDate(esc($day_ago)))->findAll();

        if ($todayKeyword) {
            foreach ($todayKeyword as $keyword){  
                $word = $keyword->word;
                $count = $keyword->count;
                $created_at = $keyword->created_at;

                $cartCount = $this->searchRankingModel->getKeywordCount($word);

                if ($cartCount == 0) {
                    $searchRanking = new SearchRanking;

                    $searchRanking = [
                        'word'    => $word,
                        'count'   => $count,
                        'del_flg' => 0
                    ];

                    $this->searchRankingModel->save($searchRanking);
                } else {
                    $keywordInfo = $this->searchRankingModel->findKeywordInfo($word);
                    $wordId = $keywordInfo->id;                
                    $this->searchRankingModel->update(['id' => $wordId], ['count' => $keywordInfo->count + $count]);
                }

            }

            $this->searchTodayModel->truncate();
        }

    }

    public function autoEventInfo(){   
       echo "There is a autoEventInfo.";
       exit;

    }

}
