<?php
namespace App\Controllers\Guest;

/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 *
 * @package CodeIgniter
 */

use App\Helpers\AuthHelpers;
use App\Models\AppInfoModel;
use App\Libraries\Excel\Excel;
use App\Libraries\NaverPay\NHNAPISCL;
use App\Libraries\NaverPay\Naver_pay_lib;
use CodeIgniter\Controller;

class BaseController extends Controller
{

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var array
     */
    protected $helpers = [
        "App\Helpers\Common\app_helpers",
        "App\Helpers\Guest\app_helpers",
        "form_validation",
        'cookie'
    ];

    protected $rules;
    protected $messages;
    protected $breadcrumb;

    /**
     * Libary excel custom
     * @var Excel
     */
    protected $excel;

    /**
     * @var \CodeIgniter\Session\Session
     */
    protected $session;
    /**
     * @var \CodeIgniter\HTTP\Response
     */
    protected $redirectResponse;

    protected $base_view = 'guest';
    protected $base_view_layout = 'guest/layouts/partials';

    protected $appInfoModel;

    /**
     * Constructor.
     */
    public function initController(\CodeIgniter\HTTP\RequestInterface $request, \CodeIgniter\HTTP\ResponseInterface $response, \Psr\Log\LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        //--------------------------------------------------------------------
        // Preload any models, libraries, etc, here.
        //--------------------------------------------------------------------
        // E.g.:
        $this->session = \Config\Services::session();
        $this->validator = \Config\Services::validation();
        $this->breadcrumb = \Config\Services::breadcrumb(false);
        $this->excel = \Config\Services::excel();
        $this->redirectResponse = \Config\Services::redirectResponse();

        foreach ($this->helpers as $helper){
            helper($helper);
        }

        $this->appInfoModel = new AppInfoModel();
    }

    protected function validationMapFieldLabels(){
        return [];
    }

    protected function checkValidation($data = null){
        $this->validator->setRules(isset($this->rules) ? $this->rules : [] ,
            isset($this->messages) ? $this->messages : []);
        if(isset($data)) {
            return $this->validator->run($data);
        }else{
            return $this->validator->withRequest($this->request)->run();
        }
    }

    /**
     * @param $viewName
     * @param array $params
     * @return string
     */
    protected function viewGuest($viewName, $params = []){
        $params['breadcrumb'] = $this->breadcrumb;
        $params['session'] = $this->session;
        $params['validator'] = $this->validator;
        $params['settingInfo'] = $this->appInfoModel->fistInfo();
        if(isset($this->rules) && count($this->rules) > 0){
            $this->validator->setRules($this->rules);
            $mapFields = $this->validationMapFieldLabels();
            if(isset($mapFields) && count($mapFields) > 0) $this->validator->setMapFieldLabels($mapFields);
            $validation = $this->validator->validatorToJs();
            $params['validation'] = $validation;
            $params['validation']['str_rules'] = str_replace('rules:','',$validation['rules']);
            $params['validation']['str_messages'] = str_replace('messages:','',$validation['messages']);
        }
        return view($this->base_view.'/'.$viewName, $params);
    }

    protected function setHeaderViewPdf($fileName, $fileUrl){
        // Header content type
        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $fileName . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($fileUrl));

        header('Accept-Ranges: bytes');

        ob_clean();
        flush();
        readfile($fileUrl); //Absolute URL
    }

    protected function setHeaderViewFile($fileName, $fileUrl){
        // Header content type
        $file_parts = pathinfo($fileName);
        $type = 'application/octet-stream';
        $file_parts = pathinfo($fileName);
        if(isset($file_parts['extension'])){
            $ext = trim($file_parts['extension']);
            $allowed = array('jpg','jpge','png','gif');
            if( in_array( strtolower($ext), $allowed ) ) {  $type = 'image/png'; }
            if($ext == 'pdf') { $type = 'application/pdf'; }
        }

        header("Content-type: $type");

        header('Content-Disposition: inline; filename="' . $fileName . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($fileUrl));

        header('Accept-Ranges: bytes');

        ob_clean();
        flush();
        readfile($fileUrl); //Absolute URL
    }

    protected function toJson($data){
        return json_encode($data);
    }

    protected function toJsonSuccess($message = null, $data = []){
        if(!isset($message)) $message = "Success";
        $dataJson = [
            'status' => 0,
            'message' => $message
        ];
        $dataJson = array_merge($dataJson, $data);
        return $this->toJson($dataJson);
    }

    protected function toJsonError($message = null){
        if(!isset($message)) $message = "Error";
        $data = [
            'status' => 1,
            'message' => $message
        ];
        return $this->toJson($data);
    }

    protected function setHeaderDownload($fileName, $fileUrl){
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.$fileName.'"');
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($fileUrl)); //Absolute URL
        ob_clean();
        flush();
        readfile($fileUrl); //Absolute URL
    }

}
