<?php 
namespace App\Controllers\Guest;

use App\Entities\Estimate;
use App\Entities\EstimatePartinfo;
use App\Helpers\AuthHelpers;
use App\Models\EstimateModel;
use App\Models\EstimateCategoryModel;
use App\Services\EstimateService;
use App\Helpers\FileHelper;
use App\Models\EstimateFileModel;
use App\Entities\EstimateFile;

use App\Models\ProductModel;
use App\Models\ProductsShippingModel;
use App\Models\StocklocationCategoryModel;
use App\Models\DeliverycodeModel;

use App\Models\EstimatePartinfoModel;

class BomController extends BaseController
{
    protected $estimateModel;
    protected $estimateFileModel;
    protected $estimateCategoryModel;
    protected $estimateService;

    public function __construct()
    {
        $this->estimateModel = new EstimateModel();
        $this->estimateFileModel = new EstimateFileModel();
        $this->estimateCategoryModel = new EstimateCategoryModel();
        $this->estimateService = new EstimateService();

    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }

    public function index(){   
        //echo "There is a Test.";
        //exit;
        return $this->viewGuest('bom/index');
    }

    public function downloadBom(){
        $fileName = 'bom_sample.xls';
        $filePath = PUBLIC_PATH. 'upload/document/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }

}
