<?php namespace App\Controllers\Guest;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

use App\Entities\PartInquiry;
use App\Entities\CartPartinfo;
use App\Entities\OrderInfo;
use App\Entities\OrderPartinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\PartInquiryModel;
use App\Models\CartPartinfoModel;
use App\Models\InquiryInfoModel;
// use App\Services\SaleService;
use App\Models\ProductModel;
use App\Models\ProductsShippingModel;
use App\Models\StocklocationCategoryModel;
use App\Models\DeliverycodeModel;
use App\Models\OrderPartinfoModel;
use App\Models\OrderInfoModel;
use App\Models\LeadtimeCategoryModel;
use App\Entities\Member;
use App\Models\MemberModel;
use App\Models\MemberSubModel;

class CartController extends BaseController
{
    private $iqrpartModel;
    private $iqrinfoModel;
    // private $saleService;
    private $productModel;
    private $productsShippingModel;
    protected $stocklocationCategoryModel;
    protected $deliverycodesModel;
    protected $orderpartinfoModel;
    protected $orderinfoModel;
    protected $leadtimeCategoryModel;
    protected $cartPartinfoModel;
    protected $memberModel;
    protected $memberSubModel;

    public function __construct()
    {
        $this->partInquiryModel = new PartInquiryModel();
        $this->iqrpartModel = new CartPartinfoModel();
        $this->iqrinfoModel = new InquiryInfoModel();
        // $this->saleService = new SaleService();
        $this->productModel = new ProductModel();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->orderpartinfoModel = new OrderPartinfoModel();
        $this->orderinfoModel = new OrderInfoModel();
        $this->leadtimeCategoryModel = new LeadtimeCategoryModel();
        $this->cartPartinfoModel = new CartPartinfoModel();
        $this->memberModel = new MemberModel();
        $this->memberSubModel = new MemberSubModel();
    }


    /*
    public function index() {         
        helper(['form', 'url']);

        $inquiry_code = AuthHelpers::getIqrCode();

        $this->iqrpartModel->offByCheckFlg($inquiry_code);
 
        //$data['lists'] = $this->iqrpartModel->getPartinfo($inquiry_code);

        $data['lists'] = $this->iqrpartModel->get_all_carts();

        return $this->viewGuest('cart/index', $data);
    }
    */
 

    public function index()
    {

       $inquiry_code = AuthHelpers::getIqrCode();
       // var_dump($inquiry_code);
       // exit;

       $this->iqrpartModel->offByCheckFlg($inquiry_code);

       $data = $this->iqrpartModel->getPartinfo($inquiry_code);
       $lists = $data['lists'];
       //var_dump($lists);
       //exit;

       foreach ($lists as $key => $item){
           $part_sequence =  $item->part_sequence;
           //echo $key." : ".$part_sequence."<br>";

           $now_product_info = $this->productModel->findByProductInfo($part_sequence);

           //var_dump($now_product_info);
           //echo "<br>";
           //exit;

           $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'category3_code'   => $now_product_info ->part_category3,
            'part_number' => $now_product_info ->part_number,
            'qty'   => $now_product_info ->qty,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'unit_mini_quantity1' => $now_product_info ->unit_mini_quantity1,
            'selling_price1' => $now_product_info ->selling_price1,
            'unit_mini_quantity2' => $now_product_info ->unit_mini_quantity2,
            'selling_price2' => $now_product_info ->selling_price2,
            'unit_mini_quantity3' => $now_product_info ->unit_mini_quantity3,
            'selling_price3' => $now_product_info ->selling_price3,
            'unit_mini_quantity4' => $now_product_info ->unit_mini_quantity4,
            'selling_price4' => $now_product_info ->selling_price4,
            'unit_mini_quantity5' => $now_product_info ->unit_mini_quantity5,
            'selling_price5' => $now_product_info ->selling_price5,
            'unit_mini_quantity6' => $now_product_info ->unit_mini_quantity6,
            'selling_price6' => $now_product_info ->selling_price6,            
            'leadtime' => $now_product_info ->leadtime,
            'delivery_code' => $now_product_info ->delivery_code
        ];

           $lists[$key]->nowinfo = $nowinfo;
           $leadtime_id =  $item->leadtime;

           $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
           $lists[$key]->leadtime_info = $leadtime_info->days;

       }
       // exit;

       $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
       $data['device_type'] = $this->get_device_type();
       // var_dump($data['device_type']);
       // exit;

       return $this->viewGuest('cart/index',array_merge($data));
    }

    
    function get_device_type() {
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $mobile_agents = array('iphone','ipod','ipad','android','webos','blackberry','nokia','opera mini','windows mobile','windows phone','iemobile');
        foreach($mobile_agents as $mobile_agent) {
            if (strpos(strtolower($user_agent), strtolower($mobile_agent)) !== false) {
                return 'mobile';
            }
        }
        return 'PC';
    }


    public function printEstimate()
    {
       $inquiry_code = AuthHelpers::getIqrCode();
       $this->iqrpartModel->offByCheckFlg($inquiry_code);

       $data = $this->iqrpartModel->getPartinfo($inquiry_code);
       $lists = $data['lists'];

       foreach ($lists as $key => $item){
           $part_sequence =  $item->part_sequence;

           $now_product_info = $this->productModel->findByProductInfo($part_sequence);

           $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'category3_code'   => $now_product_info ->part_category3,
            'part_number' => $now_product_info ->part_number,
            'qty'   => $now_product_info ->qty,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'unit_mini_quantity1' => $now_product_info ->unit_mini_quantity1,
            'selling_price1' => $now_product_info ->selling_price1,
            'unit_mini_quantity2' => $now_product_info ->unit_mini_quantity2,
            'selling_price2' => $now_product_info ->selling_price2,
            'unit_mini_quantity3' => $now_product_info ->unit_mini_quantity3,
            'selling_price3' => $now_product_info ->selling_price3,
            'unit_mini_quantity4' => $now_product_info ->unit_mini_quantity4,
            'selling_price4' => $now_product_info ->selling_price4,
            'unit_mini_quantity5' => $now_product_info ->unit_mini_quantity5,
            'selling_price5' => $now_product_info ->selling_price5,
            'unit_mini_quantity6' => $now_product_info ->unit_mini_quantity6,
            'selling_price6' => $now_product_info ->selling_price6,            
            'leadtime' => $now_product_info ->leadtime,
            'delivery_code' => $now_product_info ->delivery_code
        ];

           $lists[$key]->nowinfo = $nowinfo;
           $leadtime_id =  $item->leadtime;

           $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
           $lists[$key]->leadtime_info = $leadtime_info->days;
       }

        /*회원정보 호출 시작 */
        $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
        $info = $this->memberModel->find($memberId);
        $data['userinfo'] = $info;

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
       return $this->viewGuest('cart/printestimate',array_merge($data));
    }

    public function mailEstimate()
    {
        $username = $this->request->getPost("buyername");
        $useremail = $this->request->getPost("buyeremail");
        $estimatemessage1 = $this->request->getPost("estimatemessage1");

        // $estimatemessage2 = $this->request->getPost("estimatemessage2");
        $estimatemessage2 = "<tr><td width='30%' style='text-align:center; border: 1px solid #000;'>수신자</td><td style='text-align:left; border: 1px solid #000;'>".$username."</td></tr><tr><td width='30%' style='text-align:center; border: 1px solid #000;'>수신 E-Mail</td><td style='text-align:left; border: 1px solid #000;'>".$useremail."</td></tr>";
        $estimatemessage3 = $this->request->getPost("estimatemessage3");

        // var_dump($username);
        // var_dump($useremail);
        // var_dump($estimatemessage1);
        // var_dump($estimatemessage2);
        // var_dump($estimatemessage3);
        // echo "<br>견적서가 메일로 전달됩니다.";
        // exit;

        $email = \Config\Services::email();

        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo($useremail);
        $email->setSubject('[견적정보]'. $username .'님이 요청하신 견적정보입니다.');
        $email->setMessage($username .'님이 요청하신 저희 칩다이렉트의의 견적정보입니다.<br> 
        '. $estimatemessage1 .''. $estimatemessage2 .'
        '. $estimatemessage3);

        if($email->send(false)){
            echo "<!DOCTYPE html><html lang='ko'>
                <head>
                    <meta charset='UTF-8'>
                    <meta http-equiv='X-UA-Compatible' content='IE=edge'>
                    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                    <title>견적서가 메일로 전달</title>
                </head>
                <body>
                    <div>
                        <p>견적서가 메일로 전달했습니다.</p>
                    </div>
                    <div>
                        <button onclick='closeTabClick()'>확인</button>
                    </div>
                    <script>
                        function newTabClick() {
                            window.open('new-tab.html', '_blank');
                        }
                        function closeTabClick() {
                            window.close();
                        }
                    </script>
                </body></html>";
        }else{
            echo "<!DOCTYPE html><html lang='ko'>
            <head>
                <meta charset='UTF-8'>
                <meta http-equiv='X-UA-Compatible' content='IE=edge'>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                <title>견적서가 메일로 전달</title>
            </head>
            <body>
                <div>
                    <p>메일 전송에 문제가 있습니다.</p>
                </div>
                <div>
                    <button onclick='closeTabClick()'>확인인</button>
                </div>
                <script>
                    function newTabClick() {
                        window.open('new-tab.html', '_blank');
                    }
                    function closeTabClick() {
                        window.close();
                    }
                </script>
            </body></html>";
        }

    }

    public function deletePart()
    {
       return redirect()->route('guest.cart');
       //exit;

    }

/*
    public function cartSheetMbr()
    {
        $inquiry = new PartInquiry($this->request->getPost());
        $inquiry_code = AuthHelpers::getIqrCode();

            $cartPartinfo = new CartPartinfo();
            $dataRow = $this->request->getPost('dataRow');

            for($i=1;$i <= $dataRow;$i++):
                $cartPartinfo->check_flg = "";
                
                $cartPartinfo->inquiry_id = $this->request->getPost('inquiry_id'.$i);
                $cartPartinfo->qty = $this->request->getPost('p_num'.$i);
                $cartPartinfo->price = $this->request->getPost('price'.$i);
                $cartPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
                $cartPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

                $member_id = $this->request->getPost('member_id'.$i);
                $chk[$i] = $this->request->getPost('chk'.$i);
                $chk_ok = "active".$i;
                if ($chk[$i] == $chk_ok) {
                    $cartPartinfo->check_flg = "1";
                }

                if (!$member_id) {
                    $cartPartinfo->member_id = AuthHelpers::getLoginInfoGuest()->member_email;
                }

                $qty = $cartPartinfo->qty;
                $inquiry_code_ch = $this->request->getPost('inquiry_code'.$i);

                if ($inquiry_code == $inquiry_code_ch) {
                    if ($qty != 0) {
                        $insertId = $this->iqrpartModel->save($cartPartinfo, true);
                    }
                }

            endfor;

        $data = $this->iqrpartModel->getChkPartinfo($inquiry_code);
        $lists = $data['lists'];
        $num = count($lists);

        if ($num == 0) {
            $refererUrl = $_SERVER['HTTP_REFERER'];
            session()->setFlashdata('status_text', '1.선택주문은 구매하실 부품을 선택(채크)하셔야 합니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '진행할 수 없습니다.');
        
            } else {

            foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            if ($item->qty > $now_product_info->qty) {
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '['.$now_product_info->part_number.']의 재고수량을 확인 바랍니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '주문가능수량 부족');
            }

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
            $leadtime_id =  $item->leadtime;
            $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
            $lists[$key]->leadtime_info = $leadtime_info->days;
            $delivery_code = $now_product_info ->delivery_code;
            $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
            $lists[$key]->delivery_price = $delivery_code_info->price;
            }

            $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
            $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
            $info = $this->memberModel->find($memberId);
            $membercode = $info->member_code;
            $subinfo = $this->memberSubModel->findByMemberCode($membercode);

            $data['userinfo'] = $info;
            $data['usersubinfo'] = $subinfo;
            $data['selectinfo'] = "not_all";

            return $this->viewGuest('cart/sheet',array_merge($data));

        }
    }
*/
    
    public function cartSheet()
    {        
        // $inquiry = new PartInquiry($this->request->getPost());

        // Create Inquiry
        $inquiry_code = AuthHelpers::getIqrCode();

        $cartPartinfo = new CartPartinfo();
        $dataRow = $this->request->getPost('dataRow');

        for($i=1;$i <= $dataRow;$i++):
            $cartPartinfo->check_flg = "";
            $cartPartinfo->inquiry_id = $this->request->getPost('inquiry_id'.$i);
            $cartPartinfo->qty = $this->request->getPost('p_num'.$i);
            $cartPartinfo->price = $this->request->getPost('price'.$i);
            $cartPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
            $cartPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

            $member_id = $this->request->getPost('member_id'.$i);
            $chk[$i] = $this->request->getPost('chk'.$i);
            $chk_ok = "active".$i;

            //echo $i." || ".$chk[$i]." || ".$chk_ok;
            //echo "<br>";
            //exit;

            if ($chk[$i] == $chk_ok) {
                $cartPartinfo->check_flg = "1";
            }

            if (!$member_id) {
                $cartPartinfo->member_id = AuthHelpers::getLoginInfoGuest()->member_email;
            }

            $qty = $cartPartinfo->qty;
            $inquiry_code_ch = $this->request->getPost('inquiry_code'.$i);

            if ($inquiry_code == $inquiry_code_ch) {
                if ($qty != 0) {
                    $insertId = $this->iqrpartModel->save($cartPartinfo, true);
                }
            }
        endfor;

        $data = $this->iqrpartModel->getChkPartinfo($inquiry_code);
        $lists = $data['lists'];
        $num = count($lists);

        //var_dump($num);
        //exit;

        if ($num == 0) {

            // To Back url page
            $refererUrl = $_SERVER['HTTP_REFERER'];
            session()->setFlashdata('status_text', '2.선택주문은 구매하실 부품을 선택(채크)하셔야 합니다.');

            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '진행할 수 없습니다.');
        
        } else {

            foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            //echo $key." : ".$part_sequence."<br>";

            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            if ($item->qty > $now_product_info->qty) {

                $refererUrl = $_SERVER['HTTP_REFERER'];
    
                session()->setFlashdata('status_text', '['.$now_product_info->part_number.']의 재고수량을 확인 바랍니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '주문가능수량 부족');

               }

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
            $leadtime_id =  $item->leadtime;

            $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
            // var_dump($leadtime_info->days);
 
            $lists[$key]->leadtime_info = $leadtime_info->days;
 
            $delivery_code = $now_product_info ->delivery_code;
            $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
            $lists[$key]->delivery_price = $delivery_code_info->price;
            // var_dump($delivery_code_info->price);
            }

            $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
            //var_dump($data['lists']);

            /*회원정보 호출 시작 */
            $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
            $info = $this->memberModel->find($memberId);
            $membercode = $info->member_code;
            $subinfo = $this->memberSubModel->findByMemberCode($membercode);

            $data['userinfo'] = $info;
            $data['usersubinfo'] = $subinfo;
                /*회원정보 호출 끝 */
            $data['nonmember'] = $this->request->getPost('nonmember');
            $data['selectinfo'] = "not_all";
            return $this->viewGuest('cart/cartsheet',array_merge($data));

        }
    }

    /*
    public function cartSheetAllMbr()
    {

        $inquiry_code = AuthHelpers::getIqrCode();
        $this->iqrpartModel->offByCheckFlg($inquiry_code);
        $data = $this->iqrpartModel->getPartinfo($inquiry_code);
        $lists = $data['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;

            $now_product_info = $this->productModel->findByProductInfo($part_sequence);
            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'category3_code'   => $now_product_info ->part_category3,
                'part_number' => $now_product_info ->part_number,
                'qty'   => $now_product_info ->qty,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'unit_mini_quantity1' => $now_product_info ->unit_mini_quantity1,
                'selling_price1' => $now_product_info ->selling_price1,
                'unit_mini_quantity2' => $now_product_info ->unit_mini_quantity2,
                'selling_price2' => $now_product_info ->selling_price2,
                'unit_mini_quantity3' => $now_product_info ->unit_mini_quantity3,
                'selling_price3' => $now_product_info ->selling_price3,
                'unit_mini_quantity4' => $now_product_info ->unit_mini_quantity4,
                'selling_price4' => $now_product_info ->selling_price4,
                'unit_mini_quantity5' => $now_product_info ->unit_mini_quantity5,
                'selling_price5' => $now_product_info ->selling_price5,
                'unit_mini_quantity6' => $now_product_info ->unit_mini_quantity6,
                'selling_price6' => $now_product_info ->selling_price6,            
                'leadtime' => $now_product_info ->leadtime,
                'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
            $leadtime_id =  $item->leadtime;
            $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
            $lists[$key]->leadtime_info = $leadtime_info->days;
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        return $this->viewGuest('cart/sheetall',array_merge($data));
    }
    */

    public function cartSheetAll()
    {

        // Create Inquiry
        $inquiry_code = AuthHelpers::getIqrCode();

            $cartPartinfo = new CartPartinfo();
            $dataRow = $this->request->getPost('dataRow');
             
            for($i=1;$i <= $dataRow;$i++):
                $cartPartinfo->inquiry_id = $this->request->getPost('inquiry_id'.$i);
                $cartPartinfo->qty = $this->request->getPost('p_num'.$i);
                $cartPartinfo->price = $this->request->getPost('price'.$i);
                $cartPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
                $cartPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);
                $member_id = $this->request->getPost('member_id['.$i.']');

                if (!$member_id) {
                    $cartPartinfo->member_id = AuthHelpers::getLoginInfoGuest()->member_email;
                }

                $qty = $cartPartinfo->qty;
                $inquiry_code_ch = $this->request->getPost('inquiry_code'.$i);

                if ($inquiry_code == $inquiry_code_ch) {
                    if ($qty != 0) {
                        $insertId = $this->iqrpartModel->save($cartPartinfo, true);
                    }
                }

            endfor;


       $data = $this->iqrpartModel->getPartinfo($inquiry_code);

       $lists = $data['lists'];

       // $data['item_counts'] = $this->iqrpartModel->getPartinfoCount($inquiry_code);
       // $data['firstitem_code'] = $lists[0]->part_sequence;
       // $data['firstitem_number'] = $lists[0]->part_number;
       // $data['firstitem_image'] = $lists[0]->image_dir;

       foreach ($lists as $key => $item){
           $part_sequence =  $item->part_sequence;
           $now_product_info = $this->productModel->findByProductInfo($part_sequence);

           if ($item->qty > $now_product_info->qty) {

            $refererUrl = $_SERVER['HTTP_REFERER'];

            session()->setFlashdata('status_text', '['.$now_product_info->part_number.']의 재고수량을 확인 바랍니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '주문가능수량 부족');

           }

           $nowinfo = [
            'product_code'   => $now_product_info ->product_code,
            'part_number' => $now_product_info ->part_number,
            'qty'   => $now_product_info ->qty,
            'image_dir'   => $now_product_info ->image_dir,
            'api_flg'   => $now_product_info ->api_flg,
            'part_category3' => $now_product_info ->part_category3,
            'selling_price1' => $now_product_info ->selling_price1,
            'part_number_sequence' => $now_product_info ->part_number_sequence,
            'brief_description' => $now_product_info ->brief_description,
            'product_related' => $now_product_info ->product_related,
            'stock_location' => $now_product_info ->stock_location,
            'delivery_code' => $now_product_info ->delivery_code
        ];


           $lists[$key]->nowinfo = $nowinfo;

           $leadtime_id =  $item->leadtime;

           $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
           $lists[$key]->leadtime_info = $leadtime_info->days;

           $delivery_code = $now_product_info ->delivery_code;
           $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
           $lists[$key]->delivery_price = $delivery_code_info->price;
           // var_dump($delivery_code_info->price);
       }

       $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

       /*회원정보 호출 시작 */
       $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
       $info = $this->memberModel->find($memberId);
       $membercode = $info->member_code;
       //var_dump($info);

       $subinfo = $this->memberSubModel->findByMemberCode($membercode);
       //var_dump($subinfo);
       //exit;

       //$shop_id = AuthHelpers::getShopId();
       //$phone_num = AuthHelpers::getPhoneNum();
       //$userinfo = $this->iqrinfoModel->findByInquiryUser($phone_num);
       //$data['userinfo'] = $userinfo;

       $data['userinfo'] = $info;
       $data['usersubinfo'] = $subinfo;
        /*회원정보 호출 끝 */
       $data['nonmember'] = $this->request->getPost('nonmember');
       $data['selectinfo'] = "all";
       return $this->viewGuest('cart/cartsheet',array_merge($data));
    }


    public function accountTransfer()
    {

        //echo "결제방법 2<br>";
        //exit;
        $inquiry_code = $this->request->getPost('inquiry_code');
        $dataRow = $this->request->getPost('dataRow');
        
        $inquiry = new PartInquiry($this->request->getPost());

        for($i=1;$i <= $dataRow;$i++):
        $inquiry_id_array[$i] = $this->request->getPost('inquiry_id'.$i);
        endfor;
        
        $data = $this->iqrpartModel->getBuyPartinfo($inquiry_code, $inquiry_id_array);
        $lists = $data['lists'];
        // var_dump($lists);

        $order_code = $this->request->getPost('order_code');
        $orderPartinfo = new OrderPartinfo();

        foreach ($lists as $key => $item){

            // 판매시재고감소

            $product_code = $item->part_sequence;
            $orderproduct_info = $this->productModel->findByProductInfo($product_code);
            $adjusted_qty = $orderproduct_info->qty - $item->qty;


            $supply_price = $item->price * $item->qty;
            $price_vat = $supply_price*0.1;
            $amount_price = $supply_price+$price_vat;

            $inquiry_id = $item->inquiry_id;
            $orderPartinfo->order_code = $order_code;
            $orderPartinfo->item_code = $item->part_sequence;
            $orderPartinfo->category3_code = $item->category3_code;
            $orderPartinfo->part_number = $item->part_number;
            $orderPartinfo->manufacturer_name = $item->name;
            $orderPartinfo->qty = $item->qty;
            $orderPartinfo->price = $item->price;
            $orderPartinfo->supply_price = $supply_price;
            $orderPartinfo->vat = $price_vat;
            $orderPartinfo->amount = $amount_price;
            $orderPartinfo->stock_location = $item->stock_location;
            $orderPartinfo->delivery_code = $item->delivery_code;
            // var_dump($orderPartinfo);
            //exit;

                if ($orderPartinfo->qty != 0) {
                    $insertId = $this->orderpartinfoModel->save($orderPartinfo, true);
                    //$this->iqrpartModel->updateIdActiveFlg($inquiry_code, $inquiry_id);
                    $this->productModel->updateProductQty($product_code, $adjusted_qty);
                    $this->iqrpartModel->deleteInquiryId($inquiry_id);
                }

        }

        /*
        $inquiry_code = AuthHelpers::getIqrCode();
        $inquiry = new PartInquiry($this->request->getPost());
        var_dump($inquiry);
        
             //Update Inquiry
            $cartPartinfo = new CartPartinfo();
            $dataRow = $this->request->getPost('dataRow');
            //var_dump($dataRow);
            //echo "<br>";
        */

        $orderInfo  = new OrderInfo();

        $orderInfo->order_code = $order_code;
        $orderInfo->order_status = '1';
        $orderInfo->member_code = $this->request->getPost('member_code');
        $orderInfo->orderer_name = $this->request->getPost('buyername');
        $orderInfo->orderer_email = $this->request->getPost('buyeremail');
        $orderInfo->orderer_phone = $this->request->getPost('buyertel');
        $orderInfo->shipping_name = $this->request->getPost('shipping_name');
        $orderInfo->delivery_phone = $this->request->getPost('delivery_phone');
        $orderInfo->shipping_phone = $this->request->getPost('shipping_phone');
        $orderInfo->company_name = $this->request->getPost('company_name');
        $orderInfo->shipping_zipocode = $this->request->getPost('shipping_zipocode');
        $orderInfo->shipping_add1 = $this->request->getPost('shipping_add1');
        $orderInfo->shipping_add2 = $this->request->getPost('shipping_add2');
        $orderInfo->shipping_message = $this->request->getPost('shipping_message');
        $orderInfo->notice = $this->request->getPost('notice');
        $orderInfo->invoice_type = $this->request->getPost('invoice_type');
        $orderInfo->invoice_com = $this->request->getPost('invoice_com');
        $orderInfo->invoice_biznum = $this->request->getPost('invoice_biznum');
        $orderInfo->invoice_ceo = $this->request->getPost('invoice_ceo');
        $orderInfo->firstitem_code = $this->request->getPost('firstitem_code');
        $orderInfo->firstitem_number = $this->request->getPost('firstitem_number');
        $orderInfo->firstitem_image = $this->request->getPost('firstitem_image');
        $orderInfo->item_counts = $this->request->getPost('item_counts');
        $orderInfo->supply_price = $this->request->getPost('supply_price');
        $orderInfo->vat = $this->request->getPost('vat');
        $orderInfo->amount_total = $this->request->getPost('amount_total');
        $orderInfo->delivery_fee = $this->request->getPost('delivery_fee');
        $orderInfo->delivery_date = $this->request->getPost('delivery_date');
        // $orderInfo->payment_date = date('Y-m-d h:i:s ', time());
        $orderInfo->payment_date = "";
        $orderInfo->payment_flg = $this->request->getPost('payment_flg');
        $orderInfo->deposit_name = $this->request->getPost('deposit_name');
        $orderInfo->deposit_bank = $this->request->getPost('deposit_bank');
        $orderInfo->deposit_date = $this->request->getPost('deposit_date');


        // var_dump($orderInfo);
        // exit;

        $this->orderinfoModel->save($orderInfo);

        $email = \Config\Services::email();

        //$buyeremail = $this->request->getPost('buyeremail');
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo($orderInfo->orderer_email);
        $email->setSubject('[구매정보] 셀파세미컴 결제계좌정보입니다.');
        $email->setMessage('저희 셀파세미컴 결제계좌정보입니다.<br> 
        주문번호 : '. $order_code .'<br>
        결제금액 : '. $orderInfo->amount_total .'(VAT포함)<br>
        은행명 : 하나은행<br> 
        계좌번호 : 138-910044-11204<br> 
        예금주 : 주식회사셀파세미컴<br> 
        감사합니다.');


        /****************** 메시지 시작 ******************/
        $handphone = $orderInfo->orderer_phone;
        $member_name = $orderInfo->orderer_name;
        $content = "\n주문이 접수되었습니다. 결제정보가 메일로 전달되었습니다.";
        if ($handphone) {
            $receiver_name = $member_name;
            $receiver_phone = str_replace('-','',$handphone);
        
            /****************** 인증정보 시작 ******************/
            $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
            $sms['user_id'] = "chipdirect"; // SMS 아이디
            $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키
            /****************** 인증정보 끝 ********************/
            /****************** 전송정보 설정시작 ****************/
            $_POST['msg'] = '%고객명% '.$member_name.'님. '.$content; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)
            $_POST['receiver'] = $receiver_phone; // 수신번호
            $_POST['destination'] = $receiver_phone.'|'.$receiver_name; // 수신인 %고객명% 치환
            $_POST['sender'] =""; // 발신번호
            $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
            $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
            $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
            $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
            // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
            $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정
            // ※ msg_type 미지정시 글자수/그림유무가 판단되어 자동변환됩니다. 단, 개행문자/특수문자등이 2Byte로 처리되어 SMS 가 LMS로 처리될 가능성이 존재하므로 반드시 msg_type을 지정하여 사용하시기 바랍니다.
            /****************** 전송정보 설정끝 ***************/
            $sms['msg'] = stripslashes($_POST['msg']);
            $sms['receiver'] = $_POST['receiver'];
            $sms['destination'] = $_POST['destination'];
            $sms['sender'] = $_POST['sender'];
            $sms['rdate'] = $_POST['rdate'];
            $sms['rtime'] = $_POST['rtime'];
            $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
            $sms['title'] = $_POST['subject'];
            $sms['msg_type'] = $_POST['msg_type'];
            // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
            if(!empty($_FILES['image']['tmp_name'])) {
                $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
                if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
                else {
                    $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                    if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                        $_POST['image'] = $_savePath;
                    }
                }
            }
            // 이미지 전송 설정
            if(!empty($_POST['image'])) {
                if(file_exists($_POST['image'])) {
                    $tmpFile = explode('/',$_POST['image']);
                    $str_filename = $tmpFile[sizeof($tmpFile)-1];
                    $tmp_filetype = mime_content_type($_POST['image']);
                    if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                        $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                        curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                    } else {
                        $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                    }
                }
            }
            /*****/
            $host_info = explode("/", $sms_url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_PORT, $port);
            curl_setopt($oCurl, CURLOPT_URL, $sms_url);
            curl_setopt($oCurl, CURLOPT_POST, 1);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
            $ret = curl_exec($oCurl);
            curl_close($oCurl);
            $responseData["smslog"] = json_decode($ret);
        }
        /****************** 메시지 끝 ******************/

        $email = \Config\Services::email();

        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo('chip@selpasemicom.com, pixel@mediain.co.kr');
        $email->setSubject('[구매정보] 신규 무통장구매가 있습니다.');
        $email->setMessage('새로운 웹 구매가 있습니다.<br> 
        관리자 페이지에서 구매 내용을 확인하세요.<br>
        감사합니다.');

        if($email->send(false)){
         return $this->viewGuest('cart/transfer_return', $data);
        }else{
            echo "메일 전송에 문제가 있습니다.[A]";
        }

    }
    

    public function iniPay()
    {

        // echo "결제연결<br>";
        // exit;

        $inquiry_code = $this->request->getPost('inquiry_code');
        $dataRow = $this->request->getPost('dataRow');
        
        $payment_flg = $this->request->getPost('payment_flg');

        for($i=1;$i <= $dataRow;$i++):
        $inquiry_id_array[$i] = $this->request->getPost('inquiry_id'.$i);
        endfor;

        $data = $this->iqrpartModel->getBuyPartinfo($inquiry_code, $inquiry_id_array);
        $lists = $data['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
            $leadtime_id =  $item->leadtime;

            $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
            $lists[$key]->leadtime_info = $leadtime_info->days;

            $delivery_code = $now_product_info ->delivery_code;
            $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
            $lists[$key]->delivery_price = $delivery_code_info->price;
        }

        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        $data['firstitem_number'] = $this->request->getPost('firstitem_number');
        $data['inquiry_code'] = $this->request->getPost('inquiry_code');

        $data['price'] = round($this->request->getPost('price'));
        $data['buyername'] = $this->request->getPost('buyername');
        $data['member_code'] = $this->request->getPost('member_code');
        $data['buyeremail'] = $this->request->getPost('buyeremail');
        $data['buyertel'] = $this->request->getPost('buyertel');
        $data['shipping_name'] = $this->request->getPost('shipping_name');
        $data['shipping_phone'] = $this->request->getPost('shipping_phone');
        $data['delivery_phone'] = $this->request->getPost('delivery_phone');
        $data['company_name'] = $this->request->getPost('company_name');
        $data['shipping_zipocode'] = $this->request->getPost('shipping_zipocode');
        $data['shipping_add1'] = $this->request->getPost('shipping_add1');
        $data['shipping_add2'] = $this->request->getPost('shipping_add2');
        $data['shipping_message'] = $this->request->getPost('shipping_message');
        $data['notice'] = $this->request->getPost('notice');
        $data['invoice_type'] = $this->request->getPost('invoice_type');
        $data['invoice_com'] = $this->request->getPost('invoice_com');
        $data['invoice_biznum'] = $this->request->getPost('invoice_biznum');
        $data['invoice_ceo'] = $this->request->getPost('invoice_ceo');
        $data['payment_flg'] = $this->request->getPost('payment_flg');
        
        $data['selectinfo'] = "all";

        return $this->viewGuest('cart/inipaysheet',array_merge($data));

    }


    public function inistdpayreturn(){

        $merchantData = urldecode($this->request->getPost('merchantData'));
        // var_dump($merchantData);

        $merchantData_array = explode("|", $merchantData);

        $dataRow_array = explode("=", $merchantData_array[0]);
        if ($dataRow_array[0] == 'dataRow') {$dataRow = $dataRow_array[1];}
        $inquiry_code_array = explode("=", $merchantData_array[1]);
        if ($inquiry_code_array[0] == 'inquiry_code') {$inquiry_code = $inquiry_code_array[1];}
        $inquiry_id_all_array = explode("=", $merchantData_array[2]);
        if ($inquiry_id_all_array[0] == 'inquiry_id_all') {$inquiry_id_all = $inquiry_id_all_array[1];}
        $firstitem_code_array = explode("=", $merchantData_array[3]);
        if ($firstitem_code_array[0] == 'firstitem_code') {$firstitem_code = $firstitem_code_array[1];}
        $firstitem_number_array = explode("=", $merchantData_array[4]);
        if ($firstitem_number_array[0] == 'firstitem_number') {$firstitem_number = $firstitem_number_array[1];}
        $firstitem_image_array = explode("=", $merchantData_array[5]);
        if ($firstitem_image_array[0] == 'firstitem_image') {$firstitem_image = $firstitem_image_array[1];}
        $item_counts_array = explode("=", $merchantData_array[6]);
        if ($item_counts_array[0] == 'item_counts') {$item_counts = $item_counts_array[1];}
        $supply_price_array = explode("=", $merchantData_array[7]);
        if ($supply_price_array[0] == 'supply_price') {$supply_price = $supply_price_array[1];}
        $vat_array = explode("=", $merchantData_array[8]);
        if ($vat_array[0] == 'vat') {$vat = $vat_array[1];}
        $delivery_fee_array = explode("=", $merchantData_array[9]);
        if ($delivery_fee_array[0] == 'delivery_fee') {$delivery_fee = $delivery_fee_array[1];}
        $amount_total_array = explode("=", $merchantData_array[10]);
        if ($amount_total_array[0] == 'amount_total') {$amount_total = $amount_total_array[1];}
        $order_code_array = explode("=", $merchantData_array[11]);
        if ($order_code_array[0] == 'order_code') {$order_code = $order_code_array[1];}
        $orderer_name_array = explode("=", $merchantData_array[12]);
        if ($orderer_name_array[0] == 'orderer_name') {$orderer_name = $orderer_name_array[1];}
        $orderer_email_array = explode("=", $merchantData_array[13]);
        if ($orderer_email_array[0] == 'orderer_email') {$orderer_email = $orderer_email_array[1];}
        $orderer_phone_array = explode("=", $merchantData_array[14]);
        if ($orderer_phone_array[0] == 'orderer_phone') {$orderer_phone = $orderer_phone_array[1];}
        $shipping_name_array = explode("=", $merchantData_array[15]);
        if ($shipping_name_array[0] == 'shipping_name') {$shipping_name = $shipping_name_array[1];}
        $shipping_phone_array = explode("=", $merchantData_array[16]);
        if ($shipping_phone_array[0] == 'shipping_phone') {$shipping_phone = $shipping_phone_array[1];}
        $delivery_phone_array = explode("=", $merchantData_array[17]);
        if ($delivery_phone_array[0] == 'delivery_phone') {$delivery_phone = $delivery_phone_array[1];}
        $company_name_array = explode("=", $merchantData_array[18]);
        if ($company_name_array[0] == 'company_name') {$company_name = $company_name_array[1];}
        $shipping_zipocode_array = explode("=", $merchantData_array[19]);
        if ($shipping_zipocode_array[0] == 'shipping_zipocode') {$shipping_zipocode = $shipping_zipocode_array[1];}
        $shipping_add1_array = explode("=", $merchantData_array[20]);
        if ($shipping_add1_array[0] == 'shipping_add1') {$shipping_add1 = $shipping_add1_array[1];}
        $shipping_add2_array = explode("=", $merchantData_array[21]);
        if ($shipping_add2_array[0] == 'shipping_add2') {$shipping_add2 = $shipping_add2_array[1];}
        $shipping_message_array = explode("=", $merchantData_array[22]);
        if ($shipping_message_array[0] == 'shipping_message') {$shipping_message = $shipping_message_array[1];}
        $notice_array = explode("=", $merchantData_array[23]);
        if ($notice_array[0] == 'notice') {$notice = $notice_array[1];}


        $invoice_com_array = explode("=", $merchantData_array[24]);
        if ($invoice_com_array[0] == 'invoice_com') {$invoice_com = $invoice_com_array[1];}
        $invoice_biznum_array = explode("=", $merchantData_array[25]);
        if ($invoice_biznum_array[0] == 'invoice_biznum') {$invoice_biznum = $invoice_biznum_array[1];}
        $invoice_ceo_array = explode("=", $merchantData_array[26]);
        if ($invoice_ceo_array[0] == 'invoice_ceo') {$invoice_ceo = $invoice_ceo_array[1];}

        
        $gopaymethod_array = explode("=", $merchantData_array[27]);
        if ($gopaymethod_array[0] == 'gopaymethod') {$gopaymethod = $gopaymethod_array[1];}
        $member_code_array = explode("=", $merchantData_array[28]);
        if ($member_code_array[0] == 'member_code') {$member_code = $member_code_array[1];}
        $selectinfo_array = explode("=", $merchantData_array[29]);
        if ($selectinfo_array[0] == 'selectinfo') {$selectinfo = $selectinfo_array[1];}
        $delivery_date_array = explode("=", $merchantData_array[30]);
        if ($delivery_date_array[0] == 'delivery_date') {$delivery_date = $delivery_date_array[1];}

        // echo $selectinfo."<br>";

        if ($selectinfo == "not_all") {
            $data = $this->iqrpartModel->getChkPartinfo($inquiry_code);
        } else {
            $data = $this->iqrpartModel->getPartinfo($inquiry_code);
        }
        $lists = $data['lists'];
        // var_dump($lists);

        $orderPartinfo = new OrderPartinfo();
        $all_supply_price = 0;
        $inquiry_id_chk = explode( ',', $inquiry_id_all );

        foreach ($lists as $key => $item){
            $supply_price = $item->price * $item->qty;
            $price_vat = $supply_price*0.1;
            $amount_price = $supply_price+$price_vat;
            $inquiry_id = $item->inquiry_id;

            
            if ($inquiry_id == $inquiry_id_chk[$key])  {

            // 판매시재고감소

            $product_code = $item->part_sequence;
            $orderproduct_info = $this->productModel->findByProductInfo($product_code);
            $adjusted_qty = $orderproduct_info->qty - $item->qty;

            $orderPartinfo->order_code = $order_code;
            $orderPartinfo->item_code = $item->part_sequence;
            $orderPartinfo->category3_code = $item->category3_code;
            $orderPartinfo->part_number = $item->part_number;
            $orderPartinfo->manufacturer_name = $item->name;
            $orderPartinfo->qty = $item->qty;
            $orderPartinfo->price = $item->price;
            $orderPartinfo->supply_price = $supply_price;
            $orderPartinfo->vat = $price_vat;
            $orderPartinfo->amount = $amount_price;
            $orderPartinfo->stock_location = $item->stock_location;
            $orderPartinfo->delivery_code = $item->delivery_code;
            // var_dump($orderPartinfo);

                if ($orderPartinfo->qty != 0) {
                    $insertId = $this->orderpartinfoModel->save($orderPartinfo, true);
                    //$this->iqrpartModel->updateIdActiveFlg($inquiry_code, $inquiry_id);
                    $this->productModel->updateProductQty($product_code, $adjusted_qty);
                    $this->iqrpartModel->deleteInquiryId($inquiry_id);
                }
            }

            $all_supply_price = $all_supply_price + $supply_price;
        }

        $inquiry  = new OrderInfo();

        $inquiry->order_code = $order_code;
        $inquiry->order_status = '14';
        $inquiry->member_code = $member_code;
        $inquiry->orderer_name = $orderer_name;
        $inquiry->orderer_email = $orderer_email;
        $inquiry->orderer_phone = $orderer_phone;
        $inquiry->shipping_name = $shipping_name;
        $inquiry->delivery_phone = $delivery_phone;
        $inquiry->shipping_phone = $shipping_phone;
        $inquiry->company_name = $company_name;
        $inquiry->shipping_zipocode = $shipping_zipocode;
        $inquiry->shipping_add1 = $shipping_add1;
        $inquiry->shipping_add2 = $shipping_add2;
        $inquiry->shipping_message = $shipping_message;
        $inquiry->notice = $notice;
        $inquiry->invoice_com = $invoice_com;
        $inquiry->invoice_biznum = $invoice_biznum;
        $inquiry->invoice_ceo = $invoice_ceo;
        $inquiry->firstitem_code = $firstitem_code;
        $inquiry->firstitem_number = $firstitem_number;
        $inquiry->firstitem_image = $firstitem_image;
        $inquiry->item_counts = $item_counts;
        $inquiry->supply_price = $all_supply_price;
        $inquiry->vat = $vat;
        $inquiry->amount_total = $amount_total;
        $inquiry->delivery_fee = $delivery_fee;
        $inquiry->delivery_date = $delivery_date;
        $inquiry->payment_date = date('Y-m-d h:i:s ', time());
        $inquiry->payment_flg = $gopaymethod;
        //$inquiry->deposit_name = $deposit_name;
        //$inquiry->deposit_bank = $deposit_bank;

        // $insertId = $this->orderinfoModel->save($inquiry);
        $orderinId = $this->orderinfoModel->insert($inquiry, true);
        //echo "이니시스 결제작업 테스트";

        if($account = $this->memberModel->checkLoginCode($member_code)){
            $account->last_login_date = DateHelper::now();
            $this->memberModel->save($account);
            $account->remember = isset($remember) ? 1 : 0;
            AuthHelpers::setLoginGuest($account->toSession());
            if($account->remember == REMEMBER_FLG_ON){
                AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
            }
        }

        $inquiryCookiecode = AuthHelpers::getIqrCode();
        if(!$inquiryCookiecode) {
        AuthHelpers::resetIqrCode($inquiry_code);
        }

        /****************** 메시지 시작
        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo($inquiry->orderer_email);
        $email->setSubject('[구매정보] 구매신청하신 상품(들)이 발주처리 되었습니다.');
        $email->setMessage('저희 셀파세미컴 쇼핑몰을 이용해 주셔서 감사합니다.<br>
        고객님께서 구매신청하신 상품(들)은 "<a href="https://chipdirect.co.kr/orderinfo">주문내역</a>"에서 확인하실 수 있습니다.<br>
        주문번호 : '. $order_code .'<br>
        결제금액 : '. $inquiry->amount_total .'(VAT포함)<br>
        결제일시 : '. $inquiry->delivery_date .'<br>
        감사합니다.');
        
        $handphone = $inquiry->orderer_phone;
        $member_name = $inquiry->orderer_name;
        $content = "\n주문이 접수되었습니다. 쇼핑몰의 주문내역에서 정보를 확인하세요.";

        if ($handphone) {
            $receiver_name = $member_name;
            $receiver_phone = str_replace('-','',$handphone);

            $sms_url = "https://apis.aligo.in/send/"; // 전송요청 URL
            $sms['user_id'] = "chipdirect"; // SMS 아이디
            $sms['key'] = "5iomz2bals7kofy7siiynx33sxo5nxtp";//인증키

            $_POST['msg'] = '%고객명% '.$member_name.'님. '.$content; // 메세지 내용 : euc-kr로 치환이 가능한 문자열만 사용하실 수 있습니다. (이모지 사용불가능)
            $_POST['receiver'] = $receiver_phone; // 수신번호
            $_POST['destination'] = $receiver_phone.'|'.$receiver_name; // 수신인 %고객명% 치환
            $_POST['sender'] =""; // 발신번호
            $_POST['rdate'] = ''; // 예약일자 - 20161004 : 2016-10-04일기준
            $_POST['rtime'] = ''; // 예약시간 - 1930 : 오후 7시30분
            $_POST['testmode_yn'] = 'N'; // Y 인경우 실제문자 전송X , 자동취소(환불) 처리
            $_POST['subject'] = '테스트 발송'; //  LMS, MMS 제목 (미입력시 본문중 44Byte 또는 엔터 구분자 첫라인)
            // $_POST['image'] = '/tmp/pic_57f358af08cf7_sms_.jpg'; // MMS 이미지 파일 위치 (저장된 경로)
            $_POST['msg_type'] = 'SMS'; //  SMS, LMS, MMS등 메세지 타입을 지정
            // ※ msg_type 미지정시 글자수/그림유무가 판단되어 자동변환됩니다. 단, 개행문자/특수문자등이 2Byte로 처리되어 SMS 가 LMS로 처리될 가능성이 존재하므로 반드시 msg_type을 지정하여 사용하시기 바랍니다.

            $sms['msg'] = stripslashes($_POST['msg']);
            $sms['receiver'] = $_POST['receiver'];
            $sms['destination'] = $_POST['destination'];
            $sms['sender'] = $_POST['sender'];
            $sms['rdate'] = $_POST['rdate'];
            $sms['rtime'] = $_POST['rtime'];
            $sms['testmode_yn'] = empty($_POST['testmode_yn']) ? '' : $_POST['testmode_yn'];
            $sms['title'] = $_POST['subject'];
            $sms['msg_type'] = $_POST['msg_type'];
            // 만일 $_FILES 로 직접 Request POST된 파일을 사용하시는 경우 move_uploaded_file 로 저장 후 저장된 경로를 사용하셔야 합니다.
            if(!empty($_FILES['image']['tmp_name'])) {
                $tmp_filetype = mime_content_type($_FILES['image']['tmp_name']); 
                if($tmp_filetype != 'image/png' && $tmp_filetype != 'image/jpg' && $tmp_filetype != 'image/jpeg') $_POST['image'] = '';
                else {
                    $_savePath = "./".uniqid(); // PHP의 권한이 허용된 디렉토리를 지정
                    if(move_uploaded_file($_FILES['file']['tmp_name'], $_savePath)) {
                        $_POST['image'] = $_savePath;
                    }
                }
            }
            // 이미지 전송 설정
            if(!empty($_POST['image'])) {
                if(file_exists($_POST['image'])) {
                    $tmpFile = explode('/',$_POST['image']);
                    $str_filename = $tmpFile[sizeof($tmpFile)-1];
                    $tmp_filetype = mime_content_type($_POST['image']);
                    if ((version_compare(PHP_VERSION, '5.5') >= 0)) { // PHP 5.5버전 이상부터 적용
                        $sms['image'] = new CURLFile($_POST['image'], $tmp_filetype, $str_filename);
                        curl_setopt($oCurl, CURLOPT_SAFE_UPLOAD, true);
                    } else {
                        $sms['image'] = '@'.$_POST['image'].';filename='.$str_filename. ';type='.$tmp_filetype;
                    }
                }
            }

            $host_info = explode("/", $sms_url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $oCurl = curl_init();
            curl_setopt($oCurl, CURLOPT_PORT, $port);
            curl_setopt($oCurl, CURLOPT_URL, $sms_url);
            curl_setopt($oCurl, CURLOPT_POST, 1);
            curl_setopt($oCurl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($oCurl, CURLOPT_POSTFIELDS, $sms);
            curl_setopt($oCurl, CURLOPT_SSL_VERIFYPEER, FALSE);
            $ret = curl_exec($oCurl);
            curl_close($oCurl);
            $responseData["smslog"] = json_decode($ret);
        }
        
        메시지 끝 ******************/

        // var_dump($orderinsertId);
        // echo "<br>";
        // var_dump($data);
        // exit;

        // if($email->send(false)){
            $data["orderinId"] = $orderinId;   
            return $this->viewGuest('cart/INIstdpay_pc_return', $data);
        //}else{
       //     echo "메일 전송에 문제가 있습니다.[B]";
       // }

    }

    public function inistdpayclose(){
        $orderinId = $this->request->getPost('orderinId');
        $orderInfoItem = $this->orderinfoModel->find($orderinId);

        if(isset($orderInfoItem)){
            $inputs = $this->request->getPost();
            $inputs['active_flg'] = get_public_id($inputs['active_flg']);
            $orderInfoItem->fill($inputs);
            $this->orderinfoModel->save($orderInfoItem);

            $MOID = $this->request->getPost('MOID');
            $resultCode = $this->request->getPost('resultCode');
            $payMethod = $this->request->getPost('payMethod');

            if ($payMethod == "Card" && $resultCode == "0000" ){
                $this->orderinfoModel->updateStatus($MOID, 3);
                $this->orderpartinfoModel->updateStatus($MOID, 3);
            }

        }

        $email = \Config\Services::email();

        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo('chip@selpasemicom.com, pixel@mediain.co.kr');
        $email->setSubject('[구매정보] 신규 이니시결제구매가 있습니다.');
        $email->setMessage('새로운 웹 구매가 있습니다.<br> 
        관리자 페이지에서 구매 내용을 확인하세요.<br>
        감사합니다.');

        $orderInfo = $this->orderinfoModel->findInfoById($orderinId);
        $data['orderInfo'] = $orderInfo;
        return $this->viewGuest('cart/close', $data);        
    }

    public function buyNowMbr()
    {

        // $inquiry = new PartInquiry($this->request->getPost());

        $inquiry_code = AuthHelpers::getIqrCode();

            //Update Inquiry
            $cartPartinfo = new CartPartinfo();
            $dataRow = $this->request->getPost('dataRow');

            for($i=1;$i <= $dataRow;$i++):
                $cartPartinfo->check_flg = "";
                
                $cartPartinfo->inquiry_id = $this->request->getPost('inquiry_id'.$i);
                $cartPartinfo->qty = $this->request->getPost('p_num'.$i);
                $cartPartinfo->price = $this->request->getPost('price'.$i);
                $cartPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
                $cartPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

                $member_id = $this->request->getPost('member_id'.$i);
                $chk[$i] = $this->request->getPost('chk'.$i);
                $chk_ok = "active".$i;
                if ($chk[$i] == $chk_ok) {
                    $cartPartinfo->check_flg = "1";
                }

                if (!$member_id) {
                    $cartPartinfo->member_id = AuthHelpers::getLoginInfoGuest()->member_email;
                }

                $qty = $cartPartinfo->qty;
                $inquiry_code_ch = $this->request->getPost('inquiry_code'.$i);

                if ($inquiry_code == $inquiry_code_ch) {
                    if ($qty != 0) {
                        $insertId = $this->iqrpartModel->save($cartPartinfo, true);
                    }
                }

            endfor;

        //exit;

        $data = $this->iqrpartModel->getChkPartinfo($inquiry_code);
        $lists = $data['lists'];
        $num = count($lists);
        //var_dump($num);
        //exit;

        if ($num == 0) {
            // To Back url page
            $refererUrl = $_SERVER['HTTP_REFERER'];
            session()->setFlashdata('status_text', '3.선택주문은 구매하실 부품을 선택(채크)하셔야 합니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '진행할 수 없습니다.');
            } else {
            foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            if ($item->qty > $now_product_info->qty) {
                $refererUrl = $_SERVER['HTTP_REFERER'];
    
                session()->setFlashdata('status_text', '['.$now_product_info->part_number.']의 재고수량을 확인 바랍니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '주문가능수량 부족');
            }

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
            $leadtime_id =  $item->leadtime;
            $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
            $lists[$key]->leadtime_info = $leadtime_info->days;
            $delivery_code = $now_product_info ->delivery_code;
            $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
            $lists[$key]->delivery_price = $delivery_code_info->price;
            }

            $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

            $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
            $info = $this->memberModel->find($memberId);
            $membercode = $info->member_code;
            $subinfo = $this->memberSubModel->findByMemberCode($membercode);

            $data['userinfo'] = $info;
            $data['usersubinfo'] = $subinfo;
            $data['selectinfo'] = "not_all";

            return $this->viewGuest('cart/sheet',array_merge($data));
        }
    }

    
    public function buyNow() {
        $this->rules = $this->cartPartinfoModel->getValidationRules();

        if($this->checkValidation()){    
            $inquiry = new PartInquiry($this->request->getPost());

            $qty = $inquiry->qty;
            $price = $inquiry->price;
            $part_sequence =  $inquiry->part_sequence;
            $inquiry_code =  $inquiry->inquiry_code;
            $item = $this->productModel->findByProductCode($part_sequence);
            $inventory = $item->qty;

            if ($inventory < $qty){
                $refererUrl = $_SERVER['HTTP_REFERER'];
                session()->setFlashdata('status_text', '구매수량 보다 재고수량이 부족합니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '재고부족');
            }

        // [M] 카트에 동일 제품 유무 체크
        $containedPart =  $this->cartPartinfoModel->containedPart($inquiry_code, $part_sequence);
        $containedCount = count($containedPart['lists']);

        if ($containedCount == 0) {

            $price1 = $item->selling_price1;
            $quantity1 = $item->unit_mini_quantity1;
            $quantity1k = $quantity1 * 2;
            $price2 = $item->selling_price2;
            $quantity2 = $item->unit_mini_quantity2;
            $quantity2k = $quantity2 * 2;
            $price3 = $item->selling_price3;
            $quantity3 = $item->unit_mini_quantity3;
            $quantity3k = $quantity3 * 2;
            $price4 = $item->selling_price4;
            $quantity4 = $item->unit_mini_quantity4;
            $quantity4k = $quantity4 * 2;
            $price5 = $item->selling_price5;
            $quantity5 = $item->unit_mini_quantity5;
            $quantity5k = $quantity5 * 2;
            $price6 = $item->selling_price6;
            $quantity6 = $item->unit_mini_quantity6;
            $quantity6k = $quantity6 * 2;
    
            if ($qty >= $quantity6 and $price6 != 0) {
                    $price = $price6;
            } elseif ($qty >= $quantity5 and $price5 != 0) {
                    $price = $price5;
            } elseif ($qty >= $quantity4 and $price4 != 0) {
                    $price = $price4;
            } elseif ($qty >= $quantity3 and $price3 != 0) {
                    $price = $price3;
            } elseif ($qty >= $quantity2 and $price2 != 0) {
                    $price = $price2;
            } elseif ($qty >= $quantity1 and $price1 != 0) {
                    $price = $price1;
            }

            $inquiry->price = $price;
            $inquiry->check_flg = "1";
            $inquiry->member_id = AuthHelpers::getLoginInfoGuest()->member_email;

            // [M] 카트에 재고등록
            $this->cartPartinfoModel->save($inquiry);

            $inquiry_id = $this->cartPartinfoModel->insertID;

        } else {

            if ($containedCount == 1) {
                foreach ($containedPart['lists'] as $key => $upitem){
                    $inquiry_id = $upitem->inquiry_id;
                    $containedQty = $upitem->qty;
                }

                $upqty= $containedQty + $qty;

                $price1 = $item->selling_price1;
                $quantity1 = $item->unit_mini_quantity1;
                $quantity1k = $quantity1 * 2;
                $price2 = $item->selling_price2;
                $quantity2 = $item->unit_mini_quantity2;
                $quantity2k = $quantity2 * 2;
                $price3 = $item->selling_price3;
                $quantity3 = $item->unit_mini_quantity3;
                $quantity3k = $quantity3 * 2;
                $price4 = $item->selling_price4;
                $quantity4 = $item->unit_mini_quantity4;
                $quantity4k = $quantity4 * 2;
                $price5 = $item->selling_price5;
                $quantity5 = $item->unit_mini_quantity5;
                $quantity5k = $quantity5 * 2;
                $price6 = $item->selling_price6;
                $quantity6 = $item->unit_mini_quantity6;
                $quantity6k = $quantity6 * 2;
        
                if ($upqty >= $quantity6 and $price6 != 0) {
                        $price = $price6;
                } elseif ($upqty >= $quantity5 and $price5 != 0) {
                        $price = $price5;
                } elseif ($upqty >= $quantity4 and $price4 != 0) {
                        $price = $price4;
                } elseif ($upqty >= $quantity3 and $price3 != 0) {
                        $price = $price3;
                } elseif ($upqty >= $quantity2 and $price2 != 0) {
                        $price = $price2;
                } elseif ($upqty >= $quantity1 and $price1 != 0) {
                        $price = $price1;
                }

                $this->cartPartinfoModel->containedtUpqty($inquiry_code, $inquiry_id, $upqty, $price);
                    
            } else {

                $refererUrl = $_SERVER['HTTP_REFERER'];

                session()->setFlashdata('status_text', '바로구매 정보에 오류가 있습니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '구매정보 오류');
            }
            
        }

           $inquiry_code = AuthHelpers::getIqrCode();

           // var_dump($inquiry_code);
           // echo "<br>";
           // var_dump($inquiry_id);
           // exit;

           $data = $this->iqrpartModel->getBuyNowPartinfo($inquiry_code,$inquiry_id);

           $lists = $data['lists'];

            foreach ($lists as $key => $item){
                $part_sequence =  $item->part_sequence;
                $now_product_info = $this->productModel->findByProductInfo($part_sequence);

                if ($item->qty > $now_product_info->qty) {
                    $refererUrl = $_SERVER['HTTP_REFERER'];
                    session()->setFlashdata('status_text', '['.$now_product_info->part_number.']의 재고 확인을 위해 장바구니로 이동합니다.');
                    return redirect()->to($refererUrl)
                        ->with('status_icon', 'warning')
                        ->with('status', '주문가능수량 부족');
                   }

                $nowinfo = [
                    'product_code'   => $now_product_info ->product_code,
                    'part_number' => $now_product_info ->part_number,
                    'image_dir'   => $now_product_info ->image_dir,
                    'api_flg'   => $now_product_info ->api_flg,
                    'part_category3' => $now_product_info ->part_category3,
                    'selling_price1' => $now_product_info ->selling_price1,
                    'part_number_sequence' => $now_product_info ->part_number_sequence,
                    'brief_description' => $now_product_info ->brief_description,
                    'product_related' => $now_product_info ->product_related,
                    'stock_location' => $now_product_info ->stock_location,
                    'delivery_code' => $now_product_info ->delivery_code
                ];

                $lists[$key]->nowinfo = $nowinfo;

                $leadtime_id =  $item->leadtime;
                $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
                $lists[$key]->leadtime_info = $leadtime_info->days;
    
                $delivery_code = $now_product_info ->delivery_code;
                $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
                $lists[$key]->delivery_price = $delivery_code_info->price;
            }

            $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

            /*회원정보 호출 시작 */
            $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
            $info = $this->memberModel->find($memberId);
            $membercode = $info->member_code;
            $subinfo = $this->memberSubModel->findByMemberCode($membercode);

            $data['userinfo'] = $info;
            $data['usersubinfo'] = $subinfo;
            /*회원정보 호출 끝 */
            $data['nonmember'] = $this->request->getPost('nonmember');
            $data['selectinfo'] = "not_all";
            return $this->viewGuest('cart/buynowsheet',array_merge($data));
        }

    }

    
    public function buyNowNomem()
    {        
        $inquiry = new PartInquiry($this->request->getPost());

        // Create Inquiry
        $inquiry_code = AuthHelpers::getIqrCode();

            $cartPartinfo = new CartPartinfo();
            // $dataRow = $this->request->getPost('dataRow');
            $dataRow = 1;

            for($i=1;$i <= $dataRow;$i++):
                $cartPartinfo->check_flg = "";
                
                $cartPartinfo->inquiry_id = $this->request->getPost('inquiry_id'.$i);
                $cartPartinfo->qty = $this->request->getPost('p_num'.$i);
                $cartPartinfo->price = $this->request->getPost('price'.$i);
                $cartPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
                $cartPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

                $member_id = $this->request->getPost('member_id'.$i);
                $chk[$i] = $this->request->getPost('chk'.$i);
                $chk_ok = "active".$i;

                //echo $i." || ".$chk[$i]." || ".$chk_ok;
                //echo "<br>";
                //exit;

                if ($chk[$i] == $chk_ok) {
                    $cartPartinfo->check_flg = "1";
                }

                if (!$member_id) {
                    $cartPartinfo->member_id = AuthHelpers::getLoginInfoGuest()->member_email;
                }

                $qty = $cartPartinfo->qty;
                $inquiry_code_ch = $this->request->getPost('inquiry_code'.$i);

                if ($inquiry_code == $inquiry_code_ch) {
                    if ($qty != 0) {
                        $insertId = $this->iqrpartModel->save($cartPartinfo, true);
                    }
                }

            endfor;

        //exit;

        $data = $this->iqrpartModel->getChkPartinfo($inquiry_code);
        $lists = $data['lists'];

        $num = count($lists);
        //var_dump($num);
        //exit;

        if ($num == 0) {

            // To Back url page
            $refererUrl = $_SERVER['HTTP_REFERER'];

            session()->setFlashdata('status_text', '4.선택주문은 구매하실 부품을 선택(채크)하셔야 합니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '진행할 수 없습니다.');
        
        } else {

            foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            //echo $key." : ".$part_sequence."<br>";

            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            if ($item->qty > $now_product_info->qty) {

                $refererUrl = $_SERVER['HTTP_REFERER'];
    
                session()->setFlashdata('status_text', '['.$now_product_info->part_number.']의 재고수량을 확인 바랍니다.');
                return redirect()->to($refererUrl)
                    ->with('status_icon', 'warning')
                    ->with('status', '주문가능수량 부족');

               }

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];

            $lists[$key]->nowinfo = $nowinfo;
            $leadtime_id =  $item->leadtime;

            $leadtime_info = $this->leadtimeCategoryModel->findInfoById($leadtime_id);
            // var_dump($leadtime_info->days);
 
            $lists[$key]->leadtime_info = $leadtime_info->days;
 
            $delivery_code = $now_product_info ->delivery_code;
            $delivery_code_info = $this->deliverycodesModel->findByCategoryInfo($delivery_code);
            $lists[$key]->delivery_price = $delivery_code_info->price;
            // var_dump($delivery_code_info->price);
            }

            $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
            //var_dump($data['lists']);

            /*회원정보 호출 시작 */
            $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
            $info = $this->memberModel->find($memberId);
            $membercode = $info->member_code;
            //var_dump($info);

            $subinfo = $this->memberSubModel->findByMemberCode($membercode);
            //var_dump($subinfo);
            //exit;

            //$shop_id = AuthHelpers::getShopId();
            //$phone_num = AuthHelpers::getPhoneNum();
            //$userinfo = $this->iqrinfoModel->findByInquiryUser($phone_num);
            //$data['userinfo'] = $userinfo;

            $data['userinfo'] = $info;
            $data['usersubinfo'] = $subinfo;
                /*회원정보 호출 끝 */
            $data['nonmember'] = $this->request->getPost('nonmember');
            $data['selectinfo'] = "not_all";
            return $this->viewGuest('cart/cartsheet',array_merge($data));

        }
    }


    public function delete($inquiry_id){
        $data = $this->iqrpartModel->deleteInquiryId($inquiry_id);
        return redirect()->route('guest.cart');
    }

    public function changeQty(){
        $itemId = $this->request->getPost('item_id');
        $qty = $this->request->getPost('qty');
        AuthHelpers::changeCartQty($itemId, $qty);
        $data = AuthHelpers::getCart()->toArray();
        return $this->toJsonSuccess('Change qty success',$data);

    }

    public function changePrice(){
        $itemId = $this->request->getPost('item_id');
        $price = $this->request->getPost('price');
        AuthHelpers::changeCartPrice($itemId, $price);
        $data = AuthHelpers::getCart()->toArray();
        return $this->toJsonSuccess('Change price success',$data);
    }

    public function createCart(){

        //echo "There is a cart.create.";
        //exit;        

        $dataRow = $this->request->getPost('dataRow');
        $order_code = $this->request->getPost('order_code');
        $inquiry_code = AuthHelpers::getIqrCode();

        //var_dump($order_code);
        //echo "<br>";
        //exit;

        $orderPartinfo = new OrderPartinfo();

        for($i=1;$i < $dataRow;$i++):
            $inquiry_id = $this->request->getPost('inquiry_id'.$i);
            $orderPartinfo->order_code = $this->request->getPost('order_code');
            //$orderPartinfo->member_code = $this->request->getPost('member_id'.$i);
            $orderPartinfo->item_code = $this->request->getPost('item_code'.$i);
            $orderPartinfo->category3_code = $this->request->getPost('part_category3'.$i);
            $orderPartinfo->part_number = $this->request->getPost('part_number'.$i);
            $orderPartinfo->manufacturer_name = $this->request->getPost('manufacturer_name'.$i);
            $orderPartinfo->qty = $this->request->getPost('qty'.$i);
            $orderPartinfo->price = $this->request->getPost('price'.$i);
            $orderPartinfo->supply_price = $this->request->getPost('supply_price'.$i);
            $orderPartinfo->vat = $this->request->getPost('vat'.$i);
            $orderPartinfo->amount = $this->request->getPost('amount'.$i);
            $orderPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
            $orderPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

                $qty = $orderPartinfo->qty;
                if ($qty != 0) {
                    $insertId = $this->orderpartinfoModel->save($orderPartinfo, true);
                    $this->iqrpartModel->updateIdActiveFlg($inquiry_code, $inquiry_id);
                }

        endfor;

        // Create Inquiry
        $inquiry = new PartInquiry($this->request->getPost());
        
        //var_dump($inquiry);
        //exit;

        $this->orderinfoModel->save($inquiry);

        $message = "All quote success";
        
        return redirect()->route('guest.cart.complete')->with('message', $message);
    }

    
    public function createchkCart(){

        $dataRow = $this->request->getPost('dataRow');
        $order_code = $this->request->getPost('order_code');
        $inquiry_code = AuthHelpers::getIqrCode();

        $orderPartinfo = new OrderPartinfo();

        for($i=1;$i < $dataRow;$i++):
            $inquiry_id = $this->request->getPost('inquiry_id'.$i);
            $orderPartinfo->order_code = $this->request->getPost('order_code');
            //$orderPartinfo->member_code = $this->request->getPost('member_id'.$i);
            $orderPartinfo->item_code = $this->request->getPost('item_code'.$i);
            $orderPartinfo->category3_code = $this->request->getPost('part_category3'.$i);
            $orderPartinfo->part_number = $this->request->getPost('part_number'.$i);
            $orderPartinfo->manufacturer_name = $this->request->getPost('manufacturer_name'.$i);
            $orderPartinfo->qty = $this->request->getPost('qty'.$i);
            $orderPartinfo->price = $this->request->getPost('price'.$i);
            $orderPartinfo->supply_price = $this->request->getPost('supply_price'.$i);
            $orderPartinfo->vat = $this->request->getPost('vat'.$i);
            $orderPartinfo->amount = $this->request->getPost('amount'.$i);
            $orderPartinfo->stock_location = $this->request->getPost('stock_location'.$i);
            $orderPartinfo->delivery_code = $this->request->getPost('delivery_code'.$i);

            $chk[$i] = $this->request->getPost('chk'.$i);
            $chk_ok = "active".$i;

            if ($chk[$i] == $chk_ok) {

                $qty = $orderPartinfo->qty;
                if ($qty != 0) {
                    $insertId = $this->orderpartinfoModel->save($orderPartinfo, true);
                    $this->iqrpartModel->updateIdActiveFlg($inquiry_code, $inquiry_id);
                }

            }
            

        endfor;

        // Create Inquiry
        $inquiry = new PartInquiry($this->request->getPost());

        $this->orderinfoModel->save($inquiry);

        $message = "All quote success";
        return redirect()->route('guest.cart.complete')->with('message', $message);
    }

    public function createNow(){
        $order_code = $this->request->getPost('order_code');
        $inquiry_code = AuthHelpers::getIqrCode();

        $orderPartinfo = new OrderPartinfo();

            $inquiry_id = $this->request->getPost('inquiry_id');
            $orderPartinfo->order_code = $this->request->getPost('order_code');
            //$orderPartinfo->member_code = $this->request->getPost('member_id');
            $orderPartinfo->item_code = $this->request->getPost('item_code');
            $orderPartinfo->part_category3 = $this->request->getPost('part_category3');
            $orderPartinfo->part_number = $this->request->getPost('part_number');
            $orderPartinfo->manufacturer_name = $this->request->getPost('manufacturer_name');
            $orderPartinfo->qty = $this->request->getPost('qty');
            $orderPartinfo->price = $this->request->getPost('price');
            $orderPartinfo->supply_price = $this->request->getPost('supply_price');
            $orderPartinfo->vat = $this->request->getPost('vat');
            $orderPartinfo->amount = $this->request->getPost('amount');
            $orderPartinfo->stock_location = $this->request->getPost('stock_location');
            $orderPartinfo->delivery_code = $this->request->getPost('delivery_code');

                $qty = $orderPartinfo->qty;
                if ($qty != 0) {
                    $insertId = $this->orderpartinfoModel->save($orderPartinfo, true);

                }

        // Create Inquiry
        $inquiry = new PartInquiry($this->request->getPost());
        $this->orderinfoModel->save($inquiry);

        $message = "All quote success";
        return redirect()->route('guest.cart.complete')->with('message', $message);
    }

    public function completeCart(){
        return $this->viewGuest('cart/complete');
    }

}
