<?php
namespace App\Controllers\Guest;

// namespace App\Controllers;
 
use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\CartPartinfoModel;
use App\Models\ProductModel;

class CartModify extends BaseController {


    private $iqrpartModel;
    private $productModel;


    public function __construct()
    {
        $this->iqrpartModel = new CartPartinfoModel();
        $this->productModel = new ProductModel();
    }

    public function index() {
        echo "There is a cart_add Test.";
        exit;

        helper(['form', 'url']);

        $data['lists'] = $this->iqrpartModel->get_all_carts();
        return $this->viewGuest('cart/cart_view', $data);
    }
 
    public function cart_add() { 

        helper(['form', 'url']);

        $data = array(
            'part_sequence' => $this->request->getPost('part_sequence'),
            'part_number' => $this->request->getPost('part_number'),
            'name' => $this->request->getPost('name'),
            'qty' => $this->request->getPost('qty'),
            'price' => $this->request->getPost('price'),
        );
        $insert = $this->iqrpartModel->cart_add($data);
        echo json_encode(array("status" => TRUE));
    }
 
    public function ajax_edit($id) {
        // var_dump($inquiry_id);
        // echo "There is a ajax_edit Test.";
        // exit;

        $data = $this->iqrpartModel->findByInquiryId($id);
        echo json_encode($data);
    }
 
    public function cart_update() {
        //echo "There is a ajax_edit Test.";
        //exit;

        helper(['form', 'url']);

        $qty = $this->request->getPost('qty');
        $part_sequence = $this->request->getPost('part_sequence');
        $price = $this->request->getPost('price');

        $item = $this->productModel->findByProductCode($part_sequence);
        $moq = $item->moq;
        $mpq = $item->mpq;
        $mpq_num = $qty / $mpq;

        $inventory = $item->qty;

        if ($inventory < $qty){

            echo json_encode(array("status" => FALSE, "statusText" => "Not Found", "responseText" => "구매수량 보다 재고수량이 부족합니다.", "readyState" => "203"));

        } else {

            $price1 = $item->selling_price1;
            $quantity1 = $item->unit_mini_quantity1;
            $quantity1k = $quantity1 * 2;
            $price2 = $item->selling_price2;
            $quantity2 = $item->unit_mini_quantity2;
            $quantity2k = $quantity2 * 2;
            $price3 = $item->selling_price3;
            $quantity3 = $item->unit_mini_quantity3;
            $quantity3k = $quantity3 * 2;
            $price4 = $item->selling_price4;
            $quantity4 = $item->unit_mini_quantity4;
            $quantity4k = $quantity4 * 2;
            $price5 = $item->selling_price5;
            $quantity5 = $item->unit_mini_quantity5;
            $quantity5k = $quantity5 * 2;
            $price6 = $item->selling_price6;
            $quantity6 = $item->unit_mini_quantity6;
            $quantity6k = $quantity6 * 2;

            if ($qty >= $quantity6 and $price6 != 0) {
                    $price = $price6;
            } elseif ($qty >= $quantity5 and $price5 != 0) {
                    $price = $price5;
            } elseif ($qty >= $quantity4 and $price4 != 0) {
                    $price = $price4;
            } elseif ($qty >= $quantity3 and $price3 != 0) {
                    $price = $price3;
            } elseif ($qty >= $quantity2 and $price2 != 0) {
                    $price = $price2;
            } elseif ($qty >= $quantity1 and $price1 != 0) {
                    $price = $price1;
            }

            //정수값이면 1(참) 반환
            $mpq_result = is_int($mpq_num);

            if ($moq <= $qty){

                if ($mpq_result == 1){
                    
                $data = array(
                    // 'part_number' => $this->request->getPost('part_number'),
                    // 'name' => $this->request->getPost('name'),
                    'qty' => $qty,
                    'price' => $price,
                );

                $this->iqrpartModel->cart_update(array('inquiry_id' => $this->request->getPost('inquiry_id')), $data);
                echo json_encode(array("status" => TRUE, "statusText" => "OK", "responseText" => $moq." / ".$mpq." / ".$mpq_result, "readyState" => "200"));

                } else {

                    echo json_encode(array("status" => TRUE, "statusText" => "OK", "responseText" => "MPQ 수량을 만족하지 않습니다.", "readyState" => "202"));

                }

            } else {
                echo json_encode(array("status" => FALSE, "statusText" => "Not Found", "responseText" => "MOQ 수량을 만족하지 않습니다.", "readyState" => "201"));
            }
            
        }
    }
 
    public function cart_delete($id) {
         helper(['form', 'url']);

        //$this->iqrpartModel->delete_by_id($id);
        $this->iqrpartModel->delete(['inquiry_id' => $id]);

        echo json_encode(array("status" => TRUE));
    }
 
}