<?php 
namespace App\Controllers\Guest;

// use App\Entities\MemberDeferredpay;
use App\Entities\Deferredpay;
use App\Helpers\AuthHelpers;
// use App\Models\AppInfoModel;
// use App\Models\MemberDeferredpayModel;
use App\Models\DeferredpayModel;
use App\Models\DeferredpayCategoryModel;
use App\Services\DeferredpayService;
use App\Helpers\FileHelper;
use App\Models\DeferredpayFileModel;
use App\Entities\DeferredpayFile;

class DeferredpayController extends BaseController
{
    // protected $memberDeferredpayModel;
    protected $deferredpayModel;
    protected $deferredpayFileModel;
    protected $deferredpayCategoryModel;
    protected $deferredpayService;

    public function __construct()
    {
        // $this->memberDeferredpayModel = new MemberDeferredpayModel();
        // $this->appInfoModel = new AppInfoModel();

        $this->deferredpayModel = new DeferredpayModel();
        $this->deferredpayFileModel = new DeferredpayFileModel();
        $this->deferredpayCategoryModel = new DeferredpayCategoryModel();
        $this->deferredpayService = new DeferredpayService();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }


    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        $searchInput['member_code'] = AuthHelpers::getLoginInfoGuest()->member_code;
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->deferredpayModel->getSearchMem($searchInput,$perPage);

        $data['situation1'] = $this->deferredpayModel->getSearchMemCount($searchInput,1);
        $data['situation3'] = $this->deferredpayModel->getSearchMemCount($searchInput,3);
        //var_dump ($condition['member_code']);
        //exit;

        return $this->viewGuest('deferredpay/index', array_merge($data,$searchInput));
    }

    public function detail($deferredpayId){
        $item = $this->deferredpayModel->findInfoById($deferredpayId);
        $password = $item->password;

        if (!$password) {

        $files = $this->deferredpayFileModel->where('deferredpay_id',$deferredpayId)->findAll();
        $data['item'] = $item;
        $data['files'] = $files;
        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_DEFERREDPAY);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($deferredpayId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $deferredpayId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_DEFERREDPAY, $isViewSession);
            $this->deferredpayModel->update(['id' => $deferredpayId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('deferredpay/deferredpay_detail', $data);

        } else {


            session()->setFlashdata('status_text', '비밀글의 접근경로가 바르지 않습니다. 다시 확인 하시기 바랍니다.');
            return redirect()->to('/deferredpay')
                ->with('status_icon', 'warning')
                ->with('status', '접근경로 오류');


        }
    }

    public function detaillogin($deferredpayId){
        $data['deferredpayId'] = $deferredpayId;

        return $this->viewGuest('deferredpay/deferredpay_login', $data);
    }

    public function detailpost($deferredpayId){
        $item = $this->deferredpayModel->findInfoById($deferredpayId);
        $password = $item->password;
        $getpassword = md5($this->request->getPost('password'));

        if ($password == $getpassword) {

        $files = $this->deferredpayFileModel->where('deferredpay_id',$deferredpayId)->findAll();
        $data['item'] = $item;
        $data['files'] = $files;
        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_DEFERREDPAY);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($deferredpayId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $deferredpayId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_DEFERREDPAY, $isViewSession);
            $this->deferredpayModel->update(['id' => $deferredpayId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('deferredpay/deferredpay_detail', $data);

        } else {

                        // To Back url page
            $refererUrl = $_SERVER['HTTP_REFERER'];

            session()->setFlashdata('status_text', '비밀번호가 없거나 일치하지 않습니다.');
            return redirect()->to($refererUrl)
                ->with('status_icon', 'warning')
                ->with('status', '비밀번호 불일치');

        }
    }

    public function showCreate(){
        $this->rules = $this->deferredpayModel->getValidationRules();

        $categories = $this->deferredpayCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        // var_dump ($data);
        // exit;
        
        $account = AuthHelpers::getLoginInfoGuest();
        // var_dump ($account);
        // exit;
        $data['memberName'] = '';
        $data['memberEmail'] = '';
        $data['memberPhone'] = '';
        $data['memberCode'] = '';
        if(isset($account)){
            $data['memberName'] = $account->member_name;
            $data['memberEmail'] = $account->member_email;
            $data['memberPhone'] = $account->member_phone;
            $data['memberCode'] = $account->member_code;
        }

        return $this->viewGuest('deferredpay/deferredpay_create', $data);
    }

    public function create(){
        $this->rules = $this->deferredpayModel->getValidationRules();

        if($this->checkValidation()){
            $deferredpay = new Deferredpay($this->request->getPost());
            // var_dump($deferredpay);
            // exit;
            
            if ($deferredpay->password != "") {
                $deferredpay->password = md5($deferredpay->password);
            }

            $insertId = $this->deferredpayModel->insert($deferredpay, true);

            if($insertId > 0){
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_DEFERREDPAY, $insertId);
                            $deferredpayFile = new DeferredpayFile([
                                'deferredpay_id' => esc($insertId),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->deferredpayFileModel->save($deferredpayFile);
                        }
                    }
                }
            }

            $message = 'Create deferredpay success.';
            return redirect()->route('guest.deferredpay')->with('message' , $message);
        }else{
            return $this->viewGuest('deferredpay/deferredpay_create', [
                'validator' => $this->validator
            ]);
        }

    }

    public function showUpdate($id){
        $this->rules = $this->deferredpayModel->getValidationRules();
        $deferredpayItem = $this->deferredpayModel->find($id);
        $files = $this->deferredpayFileModel->where('deferredpay_id',$id)->findAll();
        $categories = $this->deferredpayCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $deferredpayItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        // var_dump($data);
        // exit;

        return $this->viewGuest('deferredpay/update', $data);
    }

    public function update($id){
        $this->rules = $this->deferredpayModel->getValidationRules();

        if($this->checkValidation()){
            // $this->deferredpayService->updateDeferredpay($id,$this->request);
            $deferredpayItem = $this->deferredpayModel->find($id);

            if(isset($deferredpayItem)){
                $inputs = $this->request->getPost();

                $inputs['public_flg'] = get_public_id($inputs['public_flg']);
                $deferredpayItem->fill($inputs);

                //var_dump($deferredpayItem);
                //exit;

                $this->deferredpayModel->save($deferredpayItem);
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_DEFERREDPAY, $insertId);
                            $deferredpayFile = new DeferredpayFile([
                                'deferredpay_id' => esc($id),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->deferredpayFileModel->save($deferredpayFile);
                        }
                    }
                }

            }


            $message = "Update deferredpay success";
            return redirect()->route('guest.deferredpay')->with('message',$message);
        }else{
            return view('deferredpay/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteNews($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->deferredpayService->deleteNews($ids);
            if($result) $message = "Delete deferredpay success";
        }
        return redirect()->route('guest.deferredpay')->with('message',$message);
    }

    public function deleteFile($deferredpayId,$fileNo){
        $this->deferredpayFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('guest.deferredpay.update',[$deferredpayId])->with('message',$message);;
    }

    public function viewFile($deferredpayId, $fileId){
        $file = $this->deferredpayFileModel->findDeferredpayFile($deferredpayId, $fileId);
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

}
