<?php 
namespace App\Controllers\Guest;

use App\Entities\Estimate;
use App\Entities\EstimatePartinfo;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Models\EstimateModel;
use App\Models\EstimateCategoryModel;
use App\Services\EstimateService;
use App\Helpers\FileHelper;
use App\Models\EstimateFileModel;
use App\Entities\EstimateFile;

use App\Models\ProductModel;
use App\Models\ProductsShippingModel;
use App\Models\StocklocationCategoryModel;
use App\Models\DeliverycodeModel;

use App\Models\EstimatePartinfoModel;

class EstimateController extends BaseController
{
    // protected $memberEstimateModel;
    protected $estimateModel;
    protected $estimateFileModel;
    protected $estimateCategoryModel;
    protected $estimateService;

    private $productModel;
    private $productsShippingModel;
    protected $stocklocationCategoryModel;
    protected $deliverycodesModel;

    public function __construct()
    {
        // $this->memberEstimateModel = new MemberEstimateModel();
        // $this->appInfoModel = new AppInfoModel();

        $this->estimateModel = new EstimateModel();
        $this->estimateFileModel = new EstimateFileModel();
        $this->estimateCategoryModel = new EstimateCategoryModel();
        $this->estimateService = new EstimateService();

        $this->productModel = new ProductModel();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->estimatePartinfoModel = new EstimatePartinfoModel();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }


    public function index(){   
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        $searchInput['member_code'] = AuthHelpers::getLoginInfoGuest()->member_code;
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->estimateModel->getSearchMem($searchInput,$perPage);

        $data['situation1'] = $this->estimateModel->getSearchMemCount($searchInput,1);
        $data['situation3'] = $this->estimateModel->getSearchMemCount($searchInput,3);
        
        return $this->viewGuest('estimate/index', array_merge($data,$searchInput));
    }


    public function detail($estimateId){
        $item = $this->estimateModel->findInfoById($estimateId);
        $password = $item->password;

        if (!$password) {

        $data['item'] = $item;
        $estimate_code = $item->estimate_code;

        $estimateparts = $this->estimatePartinfoModel->getEstimateParts($estimate_code);
        $lists = $estimateparts['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];
    
            $lists[$key]->nowinfo = $nowinfo;

            }
    
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['lists'] = $lists;

        $files = $this->estimateFileModel->where('estimate_id',$estimateId)->findAll();
        $data['files'] = $files;

        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($estimateId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $estimateId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY, $isViewSession);
            $this->estimateModel->update(['id' => $estimateId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('estimate/estimate_detail', $data);

        } else {


            session()->setFlashdata('status_text', '비밀글의 접근경로가 바르지 않습니다. 다시 확인 하시기 바랍니다.');
            return redirect()->to('/estimate')
                ->with('status_icon', 'warning')
                ->with('status', '접근경로 오류');


        }
    }


    public function detaillogin($estimateId){
        $data['estimateId'] = $estimateId;

        return $this->viewGuest('estimate/estimate_login', $data);
    }


    public function detailpost($estimateId){
        $item = $this->estimateModel->findInfoById($estimateId);
        $password = $item->password;

        $getpassword = md5($this->request->getPost('password'));

        if ($password == $getpassword) {

        $data['item'] = $item;
        $estimate_code = $item->estimate_code;

        $estimateparts = $this->estimatePartinfoModel->getEstimateParts($estimate_code);
        $lists = $estimateparts['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];
    
            $lists[$key]->nowinfo = $nowinfo;

            }
    
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $data['lists'] = $lists;

        $files = $this->estimateFileModel->where('estimate_id',$estimateId)->findAll();
        $data['files'] = $files;

        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($estimateId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $estimateId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY, $isViewSession);
            $this->estimateModel->update(['id' => $estimateId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('estimate/estimate_detail', $data);

        } else {
            // To Back url page
            $refererUrl = $_SERVER['HTTP_REFERER'];

            session()->setFlashdata('status_text', '비밀번호가 없거나 일치하지 않습니다.');
            return redirect()->to($refererUrl)
            ->with('status_icon', 'warning')
            ->with('status', '비밀번호 불일치');
        }
    }


    public function showCreate(){
        $this->rules = $this->estimateModel->getValidationRules();
        
        $inquiry_code = AuthHelpers::getIqrCode();
        $data = $this->estimatePartinfoModel->getPartinfo($inquiry_code);
        $lists = $data['lists'];
        
        AuthHelpers::setEstimateCode($estimatecode);
        $estimate_code = AuthHelpers::getEstimateCode();

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];
    
            $lists[$key]->nowinfo = $nowinfo;
    
            }

        $categories = $this->estimateCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        $account = AuthHelpers::getLoginInfoGuest();

        $data['estimate_code'] = $estimate_code;
        $data['inquiry_code'] = $inquiry_code;
        
        $data['memberName'] = '';
        $data['memberEmail'] = '';
        $data['memberPhone'] = '';
        $data['memberCode'] = '';
        if(isset($account)){
            $data['memberName'] = $account->member_name;
            $data['memberEmail'] = $account->member_email;
            $data['memberPhone'] = $account->member_phone;
            $data['memberCode'] = $account->member_code;
        }

        return $this->viewGuest('estimate/estimate_create', array_merge($data));
    }

    
    public function create(){
            $estimate = new Estimate($this->request->getPost());
            
            if ($estimate->password != "") {
            $estimate->password = md5($estimate->password);
            }

            $estimate_code = $this->request->getPost('estimate_code');
            $inquiry_code = $this->request->getPost('inquiry_code');

            $insertId = $this->estimateModel->insert($estimate, true);
            
            $this->estimatePartinfoModel->updateCodeinfo($inquiry_code, $estimate_code);

            if($insertId > 0){
                $this->estimatePartinfoModel->updateByActiveFlg($estimate_code);
            }

            $emailSubject ='[견적문의] 신규 견적문의가 도착했습니다.';
            $emailtMessage = '사이트에 새로운 견적문의가 도착했습니다.<br>관리자 페이지에서 견적문의 내용을 확인하세요.<br>감사합니다.';

            $this->toEmail($emailSubject, $emailtMessage);

            $message = 'Create estimate success.';
            return redirect()->route('guest.estimate')->with('message' , $message);
    }

    public function showUpdate($id){
        $this->rules = $this->estimateModel->getValidationRules();
        $estimateItem = $this->estimateModel->find($id);

        $data['item'] = $estimateItem;

        $estimate_code = $estimateItem->estimate_code;

        $estimateparts = $this->estimatePartinfoModel->getEstimateParts($estimate_code);
        $lists = $estimateparts['lists'];

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];
    
            $lists[$key]->nowinfo = $nowinfo;

            }
    
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();

        $data['lists'] = $lists;
        // var_dump($lists);
        // exit;



        $files = $this->estimateFileModel->where('estimate_id',$id)->findAll();
        $categories = $this->estimateCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        // var_dump($data);
        // exit;

        return $this->viewGuest('estimate/update', $data);
    }

    public function update($id){
        $this->rules = $this->estimateModel->getValidationRules();

        if($this->checkValidation()){
            // $this->estimateService->updateEstimate($id,$this->request);
            $estimateItem = $this->estimateModel->find($id);

            if(isset($estimateItem)){
                $inputs = $this->request->getPost();

                $inputs['public_flg'] = get_public_id($inputs['public_flg']);
                $estimateItem->fill($inputs);

                $this->estimateModel->save($estimateItem);
                $files = $this->request->getFiles();

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_INQUIRY, $insertId);
                            $estimateFile = new EstimateFile([
                                'estimate_id' => esc($id),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->estimateFileModel->save($estimateFile);
                        }
                    }
                }

            }


            $message = "Update estimate success";
            return redirect()->route('guest.estimate')->with('message',$message);
        }else{
            return view('estimate/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function downloadBom(){
        $fileName = 'bom_sample.xls';
        $filePath = PUBLIC_PATH. 'upload/document/'.$fileName;
        $this->setHeaderDownload($fileName, $filePath);
        exit;
    }

    public function toEmail($emailSubject, $emailtMessage) {

        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo('chip@selpasemicom.com, pixel@mediain.co.kr');
        $email->setSubject($emailSubject);
        $email->setMessage($emailtMessage);
        $email->send();

    }
}
