<?php 
namespace App\Controllers\Guest;
use App\Controllers\Guest\BaseController;

use App\Entities\IcKingInfo;
use App\Entities\ExchangeInfo;
use App\Helpers\FileHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Models\IcKingInfoModel;
use App\Models\IcKingPndataModel;
use App\Models\ExchangeInfoModel;
use App\Models\ApiPndataModel;

use Config\Services;

class IcKingInfoController extends BaseController
{
    protected $icKingInfoModel;
    protected $icKingPndataModel;
    protected $exchangeInfoModel;
    protected $apiPndataModel;

    public function __construct()
    {
        $this->icKingInfoModel = new IcKingInfoModel();
        $this->icKingPndataModel = new IcKingPndataModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
        $this->apiPndataModel = new ApiPndataModel();

    }


    public function index(){   
        echo "There is a Lcsc Api Info.";
        exit;
    }


    public function standardInfo(){

        $message = 'Pndata update success.';
        return redirect()->route('admin.ickinginfo.index')->with('message' , $message);
    }

    public function itemToDb()
    {
        // echo "Test itemToDb!!";
        // exit;

        $appid = 'SELPASEMICOM$CO$LTD_690';
        $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
        $timestamp = time();

        $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

        $url = 'https://openapi.ickey.cn/v2/new-token/create';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {

            echo 'no response';
            exit;

        }else{
            $tokenres = json_decode($response,true);
            $token = $tokenres["result"]["token"];
            // echo $token."<br>";
            // exit;

            ////////////////////////////////////////

            $incount = "100";
            $api_code = "ICK";
            $apiSeqIds = $this->icKingPndataModel->getIcKingId($api_code);
    
            // var_dump (count($apiSeqIds));
            // exit;
    
            if (count($apiSeqIds) > 0) {
                foreach ($apiSeqIds as $key => $itemId):
                    
                    if  ($incount > $key) {

                    // $keyword = "pic16f";
                    $keyword = $itemId->keyword;

            // var_dump ($keyword);
            // exit;
            ///////////////////////////////////////


            $url = 'https://openapi.ickey.cn/search-v1/products/get-single-goods-new';
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';

            $host_info = explode("/", $url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $ch_item = curl_init();

            curl_setopt($ch_item, CURLOPT_PORT, $port);
            curl_setopt($ch_item, CURLOPT_URL, $url);
            curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.'&keyword='.$keyword);

            $response_item = curl_exec($ch_item);

            curl_close($ch_item);

            if (!$response_item) {

                echo '<br>no response';

            }else{


                $details = json_decode($response_item,true);
                $results = $details["result"];

                $jsonRow = count($results);

                $ickinginfo = new IcKingInfo();

                // var_dump($jsonRow);
                // echo "<br>";
                // var_dump($results);

            
                if ($results) {
                    for($i=0;$i <= $jsonRow;$i++){

                        // echo $i." : ";
                        // var_dump($results[$i]);
                        // echo "<br>";

                        $issku = $results[$i]["sku"];

                        $isskucount = $this->icKingInfoModel->getIcKingCount($issku);

                        // echo $issku." / ".$isskucount."<br>";

                        if ($isskucount == 0) {
                            $ickinginfo->supplier = $results[$i]["supplier"];
                            $ickinginfo->categorylevel1_code ='038';
                            $ickinginfo->category_id1 ='38';
                            $ickinginfo->category_name1 ='Others';
                            $ickinginfo->categorylevel2_code ='038004';
                            $ickinginfo->category_id2 ='1343';
                            $ickinginfo->category_name2 ='Others';
                            $ickinginfo->sku = $results[$i]["sku"];
                            $ickinginfo->pro_name = $results[$i]["pro_name"];
                            $ickinginfo->pro_maf = $results[$i]["pro_maf"];
                            $ickinginfo->pro_desc = $results[$i]["pro_desc"];
                            $ickinginfo->date_code = $results[$i]["date_code"];
                            $ickinginfo->package = $results[$i]["package"];
                            $ickinginfo->stock = $results[$i]["stock"];
                            $ickinginfo->moq = $results[$i]["moq"];
                            $ickinginfo->spq = $results[$i]["spq"];
                            $ickinginfo->rmb0 = $results[$i]["rmb"][0];
                            $ickinginfo->rmb1 = $results[$i]["rmb"][1];
                            $ickinginfo->rmb2 = $results[$i]["rmb"][2];
                            $ickinginfo->rmb3 = $results[$i]["rmb"][3];
                            $ickinginfo->rmb4 = $results[$i]["rmb"][4];
                            $ickinginfo->rmb5 = $results[$i]["rmb"][5];
                            $ickinginfo->rmb6 = $results[$i]["rmb"][6];
                            $ickinginfo->rmb7 = $results[$i]["rmb"][7];
                            $ickinginfo->nums0 = $results[$i]["nums"][0];
                            $ickinginfo->nums1 = $results[$i]["nums"][1];
                            $ickinginfo->nums2 = $results[$i]["nums"][2];
                            $ickinginfo->nums3 = $results[$i]["nums"][3];
                            $ickinginfo->nums4 = $results[$i]["nums"][4];
                            $ickinginfo->nums5 = $results[$i]["nums"][5];
                            $ickinginfo->nums6 = $results[$i]["nums"][6];
                            $ickinginfo->nums7 = $results[$i]["nums"][7];
                            $ickinginfo->lead_time_cn = $results[$i]["lead_time_cn"];
                            $ickinginfo->data_sheet = $results[$i]["data_sheet"];
                            $ickinginfo->footprint = $results[$i]["footprint"];
                            $ickinginfo->cate_name = $results[$i]["cate_name"];
                            $ickinginfo->mpq = $results[$i]["mpq"];
                            $ickinginfo->img_url = $results[$i]["img_url"];
                            $ickinginfo->detail_url = $results[$i]["detail_url"];
                            $ickinginfo->is_cwh = $results[$i]["is_cwh"];
                            $ickinginfo->is_yx = $results[$i]["is_yx"];
                            $ickinginfo->usd0 = $results[$i]["usd"][0];
                            $ickinginfo->usd1 = $results[$i]["usd"][1];
                            $ickinginfo->usd2 = $results[$i]["usd"][2];
                            $ickinginfo->usd3 = $results[$i]["usd"][3];
                            $ickinginfo->usd4 = $results[$i]["usd"][4];
                            $ickinginfo->usd5 = $results[$i]["usd"][5];
                            $ickinginfo->usd6 = $results[$i]["usd"][6];
                            $ickinginfo->usd7 = $results[$i]["usd"][7];
                            $ickinginfo->lead_time_hk = $results[$i]["lead_time_hk"];

                            if ($results[$i]["pro_name"]) {
                                $this->icKingInfoModel->save($ickinginfo);
                            }
                        }

                    }

                }
            
            }

            
                $this->icKingPndataModel->updateActiveFlg($keyword);
                // 2초 지연 서버속도 맞춤.
                time_sleep_until(time() + 2);

            ////////////////////////////////////////

                    }

                endforeach;
            }

            ///////////////////////////////////////

        }

    }


    public function skuInfo(){
        $appid = 'SELPASEMICOM$CO$LTD_690';
        $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
        $timestamp = time();

        $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

        $url = 'https://openapi.ickey.cn/v2/new-token/create';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {

            echo 'no response';
            exit;
        }else{

            $tokenres = json_decode($response,true);
            $token = $tokenres["result"]["token"];
            $limit = 5;

            $sku_data = $_GET['skudata'];

            if ($sku_data) {

                $string = $sku_data;
                $fruits = explode(",", $string);
                $k = 0;

                foreach ($fruits as $value) {
                    $sku .= '&sku['.$k.']='.$value;
                    $k++;
                }

            } else {
                $skulist = $this->icKingInfoModel->getSku($limit);

                foreach ($skulist['lists'] as $key => $item){
                    $sku .= '&sku['.$key.']='.$item->sku;

                }

            }

            $url = 'https://openapi.ickey.cn/search-v1/products/sku-info';
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';
        
            $host_info = explode("/", $url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $ch_item = curl_init();
        
            curl_setopt($ch_item, CURLOPT_PORT, $port);
            curl_setopt($ch_item, CURLOPT_URL, $url);
            curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.''.$sku);
        
            $response_item = curl_exec($ch_item);
        
            curl_close($ch_item);
        
            if (!$response_item) {
                echo '<br>no response';
            }else{
                echo $response_item;
            }
        
        }

    }

    
    public function itemToTxt(){
        $appid = 'SELPASEMICOM$CO$LTD_690';
        $appkey = '51d3afa11c937ae7ea0d8c4a4a77c5c9';
        $timestamp = time();

        $sign = md5('_t='.$timestamp.'&appid='.$appid.'|'.$appkey);

        $url = 'https://openapi.ickey.cn/v2/new-token/create';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $host_info = explode("/", $url);
        $port = $host_info[0] == 'https:' ? 443 : 80;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_PORT, $port);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'appid='.$appid.'&_t='.$timestamp.'&sign='.$sign);

        $response = curl_exec($ch);
        curl_close($ch);

        if (!$response) {

            echo 'no response';
            exit;

        }else{

            $tokenres = json_decode($response,true);
            $token = $tokenres["result"]["token"];

            $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
            $pathFile = FileHelper::FOLDER_PATCH_ICK_TOTEXT;
            $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

            $result=opendir($filepath);

            while($file=readdir($result)) {
            if($file=="."||$file=="..") {continue;}
            $fileInfo = pathinfo($file);
            $fileExt = $fileInfo['extension'];
        
            If (empty($fileExt)){
                $dir_count++;
            } else {
                $file_count++;
            }
            }
            // echo"디렉토리 갯수는:".$dir_count."<br>";
            // echo"파일의 갯수는:".$file_count;
            // exit;

            $filenum = $file_count+1;
            $incount = "50"; // test
            $api_code = "ICK";

            $apiSeqIds = $this->apiPndataModel->getApiId($api_code, $incount);

            // $counrty_code = "CNY";
            // $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
            // $exchange_rat = $ExchangeRat->standard_amount;
            // var_dump($exchange_rat);

            foreach ($apiSeqIds["lists"] as $key => $item){
                $sku .= '&sku['.$key.']='.$item->api_partnumber;
            }

            $url = 'https://openapi.ickey.cn/search-v1/products/sku-info';
            $headers[] = 'Content-Type: application/x-www-form-urlencoded';
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';
        
            $host_info = explode("/", $url);
            $port = $host_info[0] == 'https:' ? 443 : 80;
            $ch_item = curl_init();
        
            curl_setopt($ch_item, CURLOPT_PORT, $port);
            curl_setopt($ch_item, CURLOPT_URL, $url);
            curl_setopt($ch_item, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch_item, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch_item, CURLOPT_POSTFIELDS, 'token='.$token.'&_t='.$timestamp.''.$sku);
        
            $response_item = curl_exec($ch_item);
        
            curl_close($ch_item);
        
            if (!$response_item) {
                echo '<br>no response';
            }else{
                $response = json_decode($response_item,true);
                $results = $response["result"];
                $jsonRow = count($results);
                // var_dump($jsonRow);

                if ($results) {
                    for($i=0;$i <= $jsonRow;$i++){
                        $skunum = $apiSeqIds["lists"][$i]->api_partnumber;
                        // var_dump($results[$skunum]);
                        // echo "<br>";

                        $sku = $results[$skunum]["sku"];
                        $pro_name = $results[$skunum]["pro_name"];
                        $pro_maf = $results[$skunum]["pro_maf"];
                        $pro_desc = $results[$skunum]["pro_desc"];
                        $stock = $results[$skunum]["stock"];
                        $moq = $results[$skunum]["moq"];
                        $spq = $results[$skunum]["spq"];
                        $rmb0 = $results[$skunum]["rmb"][0];
                        $rmb1 = $results[$skunum]["rmb"][1];
                        $rmb2 = $results[$skunum]["rmb"][2];
                        $rmb3 = $results[$skunum]["rmb"][3];
                        $rmb4 = $results[$skunum]["rmb"][4];
                        $rmb5 = $results[$skunum]["rmb"][5];
                        $rmb6 = $results[$skunum]["rmb"][6];
                        $rmb7 = $results[$skunum]["rmb"][7];
                        $nums0 = $results[$skunum]["nums"][0];
                        $nums1 = $results[$skunum]["nums"][1];
                        $nums2 = $results[$skunum]["nums"][2];
                        $nums3 = $results[$skunum]["nums"][3];
                        $nums4 = $results[$skunum]["nums"][4];
                        $nums5 = $results[$skunum]["nums"][5];
                        $nums6 = $results[$skunum]["nums"][6];
                        $nums7 = $results[$skunum]["nums"][7];
                        $lead_time_cn = $results[$skunum]["lead_time_cn"];
                        $img_url = $results[$skunum]["img_url"];
                        $usd0 = $results[$skunum]["usd"][0];
                        $usd1 = $results[$skunum]["usd"][1];
                        $usd2 = $results[$skunum]["usd"][2];
                        $usd3 = $results[$skunum]["usd"][3];
                        $usd4 = $results[$skunum]["usd"][4];
                        $usd5 = $results[$skunum]["usd"][5];
                        $usd6 = $results[$skunum]["usd"][6];
                        $usd7 = $results[$skunum]["usd"][7];
                        $lead_time_hk = $results[$skunum]["lead_time_hk"];
                        $status = $results[$skunum]["status"];

                        if ($sku) {
                        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
                        $pathFile = FileHelper::FOLDER_PATCH_ICK_TOTEXT;
                        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
                        $filename = $api_code."_itemstext".$filenum;

                        $fp = fopen($filepath.$filename.".csv", "a");
                        $text = '"'.$sku.'","'.$pro_name.'","'.$pro_maf.'","'.$pro_desc.'","'.$stock.'","'.$moq.'","'.$spq.'","'.$rmb0.'","'.$rmb1.'","'.$rmb2.'","'.$rmb3.'","'.$rmb4.'","'.$rmb5.'","'.$rmb6.'","'.$rmb7.'","'.$nums0.'","'.$nums1.'","'.$nums2.'","'.$nums3.'","'.$nums4.'","'.$nums5.'","'.$nums6.'","'.$nums7.'","'.$lead_time_cn.'","'.$img_url.'","'.$usd0.'","'.$usd1.'","'.$usd2.'","'.$usd3.'","'.$usd4.'","'.$usd5.'","'.$usd6.'","'.$usd7.'","'.$lead_time_hk.'","'.$status.'"';
                        fwrite($fp, $text."\n");
                        fclose($fp);

                        $this->apiPndataModel->updateActiveFlg($sku);

                        }

                    }
                }

            }

        }

        exit;
    }

    public function itemSorting(){
        $this->icKingInfoModel->sortingData();

        echo 'Data Sorting Success!';
        exit;
    }

}