<?php 
namespace App\Controllers\Guest;

use App\Entities\Inquiry;
use App\Entities\InquiryPartinfo;
use App\Helpers\AuthHelpers;
use App\Models\InquiryModel;
use App\Models\InquiryCategoryModel;
use App\Services\InquiryService;
use App\Helpers\FileHelper;
use App\Models\InquiryFileModel;
use App\Entities\InquiryFile;

use App\Models\ProductModel;
use App\Models\ProductsShippingModel;
use App\Models\StocklocationCategoryModel;
use App\Models\DeliverycodeModel;

use App\Models\InquiryPartinfoModel;

class InquiryController extends BaseController
{
    // protected $memberInquiryModel;
    protected $inquiryModel;
    protected $inquiryFileModel;
    protected $inquiryCategoryModel;
    protected $inquiryService;

    private $productModel;
    private $productsShippingModel;
    protected $stocklocationCategoryModel;
    protected $deliverycodesModel;

    public function __construct()
    {
        // $this->memberInquiryModel = new MemberInquiryModel();
        // $this->appInfoModel = new AppInfoModel();

        $this->inquiryModel = new InquiryModel();
        $this->inquiryFileModel = new InquiryFileModel();
        $this->inquiryCategoryModel = new InquiryCategoryModel();
        $this->inquiryService = new InquiryService();

        $this->productModel = new ProductModel();
        $this->productsShippingModel = new ProductsShippingModel();
        $this->stocklocationCategoryModel = new StocklocationCategoryModel();
        $this->deliverycodesModel = new DeliverycodeModel();
        $this->inquiryPartinfoModel = new InquiryPartinfoModel();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }


    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->inquiryModel->getSearch($searchInput,$perPage);

        $data['situation1'] = $this->inquiryModel->getSearchCount($searchInput,1);
        $data['situation3'] = $this->inquiryModel->getSearchCount($searchInput,3);
        //var_dump ($data);
        //exit;

        return $this->viewGuest('inquiry/index', array_merge($data,$searchInput));
    }

    public function detail($inquiryId){
        $item = $this->inquiryModel->findInfoById($inquiryId);
        $password = $item->password;

        if (!$password) {

        $files = $this->inquiryFileModel->where('inquiry_id',$inquiryId)->findAll();
        $data['item'] = $item;

        $item_code = $item->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);

        $data['productinfo'] = $productinfo;
        $data['files'] = $files;

        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($inquiryId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $inquiryId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY, $isViewSession);
            $this->inquiryModel->update(['id' => $inquiryId], ['hit_number' => $item->hit_number + 1]);
        }

            return $this->viewGuest('inquiry/inquiry_detail', $data);
        
        } else {

            session()->setFlashdata('status_text', '비밀글의 접근경로가 바르지 않습니다. 다시 확인 하시기 바랍니다.');
            return redirect()->to('/inquiry')
                ->with('status_icon', 'warning')
                ->with('status', '접근경로 오류');

        }
    }

    public function detaillogin($inquiryId){
        $data['inquiryId'] = $inquiryId;

        return $this->viewGuest('inquiry/inquiry_login', $data);
    }

    
    public function detailpost($inquiryId){
        $item = $this->inquiryModel->findInfoById($inquiryId);
        $password = $item->password;
        $getpassword = md5($this->request->getPost('password'));

        if ($password == $getpassword) {

        $files = $this->inquiryFileModel->where('inquiry_id',$inquiryId)->findAll();
        $data['item'] = $item;

        $item_code = $item->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);

        $data['productinfo'] = $productinfo;
        $data['files'] = $files;

        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($inquiryId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $inquiryId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_INQUIRY, $isViewSession);
            $this->inquiryModel->update(['id' => $inquiryId], ['hit_number' => $item->hit_number + 1]);
        }

        return $this->viewGuest('inquiry/inquiry_detail', $data);

        } else {

                // To Back url page
        $refererUrl = $_SERVER['HTTP_REFERER'];

        session()->setFlashdata('status_text', '비밀번호가 없거나 일치하지 않습니다.');
        return redirect()->to($refererUrl)
        ->with('status_icon', 'warning')
        ->with('status', '비밀번호 불일치');

        }
    }


    public function showCreate(){

        $this->rules = $this->inquiryModel->getValidationRules();
        
        $inquiry_code = AuthHelpers::getIqrCode();

        //$this->inquiryPartinfoModel->offByCheckFlg($inquiry_code);
 
        $data = $this->inquiryPartinfoModel->getPartinfo($inquiry_code);
        $lists = $data['lists'];
        //var_dump($lists);
        //exit;

        foreach ($lists as $key => $item){
            $part_sequence =  $item->part_sequence;
            $now_product_info = $this->productModel->findByProductInfo($part_sequence);

            $nowinfo = [
                'product_code'   => $now_product_info ->product_code,
                'part_number' => $now_product_info ->part_number,
                'image_dir'   => $now_product_info ->image_dir,
                'api_flg'   => $now_product_info ->api_flg,
                'part_category3' => $now_product_info ->part_category3,
                'selling_price1' => $now_product_info ->selling_price1,
                'part_number_sequence' => $now_product_info ->part_number_sequence,
                'brief_description' => $now_product_info ->brief_description,
                'product_related' => $now_product_info ->product_related,
                'stock_location' => $now_product_info ->stock_location,
                'delivery_code' => $now_product_info ->delivery_code
            ];
    
            $lists[$key]->nowinfo = $nowinfo;
    
            }

        $categories = $this->inquiryCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        //var_dump ($data);
        //exit;
    
        $data['stocklocationcategorys'] = $this->stocklocationCategoryModel->findAll();
        //var_dump($data['lists']);

        return $this->viewGuest('inquiry/inquiry_create', array_merge($data));
    }

    
    public function create(){
        $this->rules = $this->inquiryModel->getValidationRules();

        if($this->checkValidation()){
            $inquiry = new Inquiry($this->request->getPost());

            if ($inquiry->password != "") {
            $inquiry->password = md5($inquiry->password);
            }

            $inquiry_code = $this->request->getPost('inquiry_code');

            $insertId = $this->inquiryModel->insert($inquiry, true);

            if($insertId > 0){

                $this->inquiryPartinfoModel->updateByActiveFlg($inquiry_code);

                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_INQUIRY, $insertId);
                            $inquiryFile = new InquiryFile([
                                'inquiry_id' => esc($insertId),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->inquiryFileModel->save($inquiryFile);
                        }
                    }
                }
            }
        
            $emailSubject ='[상품문의] 신규 상품문의가 도착했습니다.';
            $emailtMessage = '사이트에 새로운 상품문의가 도착했습니다.<br>관리자 페이지에서 상품문의 내용을 확인하세요.<br>감사합니다.';

            $this->toEmail($emailSubject, $emailtMessage);

            $message = 'Create inquiry success.';
            return redirect()->route('guest.inquiry')->with('message' , $message);
        }else{
            return $this->viewGuest('inquiry/inquiry_create', [
                'validator' => $this->validator
            ]);
        }

    }

    public function showUpdate($id){
        $this->rules = $this->inquiryModel->getValidationRules();
        $inquiryItem = $this->inquiryModel->find($id);
        $data['item'] = $inquiryItem;
        
        $item_code = $inquiryItem->item_code;
        $productinfo = $this->productModel->findByProductCode($item_code);
        $data['productinfo'] = $productinfo;
   
        $files = $this->inquiryFileModel->where('inquiry_id',$id)->findAll();
        $categories = $this->inquiryCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        // var_dump($data);
        // exit;

        return $this->viewGuest('inquiry/update', $data);
    }

    public function update($id){
        $this->rules = $this->inquiryModel->getValidationRules();

        if($this->checkValidation()){
            // $this->inquiryService->updateInquiry($id,$this->request);
            $inquiryItem = $this->inquiryModel->find($id);

            if(isset($inquiryItem)){
                $inputs = $this->request->getPost();

                $inputs['public_flg'] = get_public_id($inputs['public_flg']);
                $inquiryItem->fill($inputs);

                //var_dump($inquiryItem);
                //exit;

                $this->inquiryModel->save($inquiryItem);
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_INQUIRY, $insertId);
                            $inquiryFile = new InquiryFile([
                                'inquiry_id' => esc($id),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->inquiryFileModel->save($inquiryFile);
                        }
                    }
                }

            }


            $message = "Update inquiry success";
            return redirect()->route('guest.inquiry')->with('message',$message);
        }else{
            return view('inquiry/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteNews($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->inquiryService->deleteNews($ids);
            if($result) $message = "Delete inquiry success";
        }
        return redirect()->route('guest.inquiry')->with('message',$message);
    }

    public function deleteFile($inquiryId,$fileNo){
        $this->inquiryFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('guest.inquiry.update',[$inquiryId])->with('message',$message);;
    }

    public function viewFile($inquiryId, $fileId){
        $file = $this->inquiryFileModel->findInquiryFile($inquiryId, $fileId);
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

    public function toEmail($emailSubject, $emailtMessage) {

        $email = \Config\Services::email();
        
        $config['protocol'] = 'html';
        $config['mailPath'] = '/usr/sbin/sendmail -t -i';
        $config['fromEmail'] = 'chipdirectmall@gmail.com';
        $config['fromName'] = 'ChipDirect';

        $email->initialize($config);
        $email->setFrom('chip@selpasemicom.com', 'ChipDirect');
        $email->setTo('chip@selpasemicom.com, pixel@mediain.co.kr');
        $email->setSubject($emailSubject);
        $email->setMessage($emailtMessage);
        $email->send();

    }

}
