<?php 
namespace App\Controllers\Guest;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use Config\Services;

class KakaoApiController extends BaseController
{

    protected $memberModel;
    protected $emailHelper;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->emailHelper = new EmailHelper();
    }

    public function index(){   
        echo "There is a Test.";
        exit;
    }

    public function kakaoLogin(){   
        return $this->viewGuest('kakaoapi/kakaologin');
    }

    public function kakaoInfo(){   
       // echo "There is a Info Test.";
       // exit;

        $REST_API_KEY   = "efbf6f87ffc71fde085dec391453d989"; // 내 애플리케이션 > 앱 설정 > 요약 정보
        $CLIENT_SECRET  = ""; // 내 애플리케이션 > 제품 설정 > 카카오 로그인 > 보안
        $REDIRECT_URI  = urlencode("https://chipdirect.co.kr/kakaoapi/kakaoinfo");
        // $REDIRECT_URI  = urlencode("https://chipdirect.co.kr/kakaoapi/kakaoinfo");

        function Call($callUrl, $method, $headers = array(), $data = array(), $returnType="jsonObject")
        {

            try {
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $callUrl);
                if ($method == "POST") {
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                } else {
                    curl_setopt($ch, CURLOPT_POST, false);
                }
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_HTTP200ALIASES, array(400));
                $response = curl_exec($ch);
                $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);

                // echo "<pre>".$status_code.":".$response."</pre>";
                if ($returnType=="jsonObject") return json_decode($response);
                else return $response;     
            } catch (Exception $e) {
                // echo $e;
            }    
        }

        if (!isset($_GET["code"])) die(); //code 받기 전이면 수행 안함

        function getToken($REST_API_KEY, $REDIRECT_URI, $CLIENT_SECRET) //로그인 : 토큰 조회
        {
            $code = $_GET["code"]; //Redirect URI로 돌아올 때, 받아온 파라메터 
            $callUrl = "https://kauth.kakao.com/oauth/token?grant_type=authorization_code&client_id=".$REST_API_KEY."&redirect_uri=".$REDIRECT_URI."&code=".$code."&client_secret=".$CLIENT_SECRET;
            $res = Call($callUrl, "POST");
            if($res->error_code == "KOE320") die("[KOE320] code 받은 후, 새로고침하면 code 재사용 불가 에러 : 다시 로그인 시도 할 것");
            return $res;
        }

        function getProfile($ACCESS_TOKEN) //로그인 : 플로필 조회
        {
            $callUrl = "https://kapi.kakao.com/v2/user/me";
            $headers[] = "Authorization: Bearer ".$ACCESS_TOKEN;
            $res = Call($callUrl, "POST", $headers);
            if($res->properties == "") die("내 애플리케이션>제품 설정>카카오 로그인> 동의항목 : profile 필수 설정");
            return $res;
        }    
    
        $ACCESS_TOKEN = getToken($REST_API_KEY, $REDIRECT_URI, $CLIENT_SECRET)->access_token; // 토큰 조회 및 토큰 저장
        $user_data = getProfile($ACCESS_TOKEN); // 프로필 조회

        $email = $user_data->kakao_account->email;
        $name =  $user_data->kakao_account->profile->nickname;

        // var_dump ($user_data);
        // var_dump ($email);
        // var_dump ($name);
        // exit;

        if($account = $this->memberModel->checkSNSLogin($email, $name)){

            $account->last_login_date = DateHelper::now();
            $this->memberModel->save($account);
            $account->remember = isset($remember) ? 1 : 0;
            AuthHelpers::setLoginGuest($account->toSession());
            if($account->remember == REMEMBER_FLG_ON){
                AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
            }

            $refererUrl =  AuthHelpers::getSession()->get(AuthHelpers::BACK_URL_LOGIN);
            $arrayNotBack = ['forgot-password', 'login', 'register'];
            if(ArrayHelper::searchValueContainArray($refererUrl,$arrayNotBack) === false ){
                AuthHelpers::getSession()->remove(AuthHelpers::BACK_URL_LOGIN);
                return redirect()->to($refererUrl);
            }

            return redirect()->route('guest.home')->withInput();
        }else{

            $data = [
                'member_email' => $email,
                'member_name'  => $name,
                'member_phone' => $mobile
            ];

            return $this->viewGuest('kakaoapi/kakaoinfo', $data);
        }

    }

}
