<?php namespace App\Controllers\Guest\Layout;

use App\Controllers\Guest\BaseController;
use App\Helpers\AuthHelpers;
use App\Models\AppInfoModel;
use App\Models\ManufacturerModel;
use App\Models\CartPartinfoModel;
use App\Models\EstimatePartinfoModel;
use App\Models\BannerinfoModel;
use App\Models\Categorylevel1Model;
use App\Models\SearchRankingModel;

class SubHeaderController extends BaseController
{
    private $manufacturerModel;
    private $iqrpartModel;
    protected $estimatePartinfoModel;
    protected $bannerinfosModel;
    protected $appInfoModel;
    protected $categorylevel1Model;
    protected $searchRankingModel;

    public function __construct()
    {
        $this->manufacturerModel = new ManufacturerModel();
        $this->iqrpartModel = new CartPartinfoModel();
        $this->estimatePartinfoModel = new EstimatePartinfoModel();
        $this->bannerinfosModel = new BannerinfoModel();
        $this->categorylevel1Model = new Categorylevel1Model();
        $this->searchRankingModel = new SearchRankingModel();
    }

    public function index()
    {
        $products = $this->manufacturerModel->findAll();
        $cartCount = 0;
        $estimateCount = 0;
        $inquiry_code = AuthHelpers::getIqrCode();
        
        if($inquiry_code){
        $cartCount = $this->iqrpartModel->getPartinfoCount($inquiry_code);
        $estimateCount = $this->estimatePartinfoModel->getPartinfoCount($inquiry_code);
        }

        $data=[
            'products' => $products,
            'cartCount' => $cartCount,
            'estimateCount' => $estimateCount
        ];

        $categorylevel1Model = new Categorylevel1Model();
		$data['categorylevel1'] = $categorylevel1Model->orderBy('categorylevel1_name', 'ASC')->findAll();

        $bannertop01 = $this->bannerinfosModel->getBannerimg(1);
        $data['bannertop01'] = $bannertop01;
        $bannertop02 = $this->bannerinfosModel->getBannerimg(2);
        $data['bannertop02'] = $bannertop02;
        $bannertop03 = $this->bannerinfosModel->getBannerimg(3);
        $data['bannertop03'] = $bannertop03;

        // var_dump($bannertop01);
        // exit;


        return view($this->base_view_layout.'/__sub_header', $data);
    }

}
