<?php 
namespace App\Controllers\Guest;
use App\Controllers\Guest\BaseController;

use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Helpers\FileHelper;

use App\Entities\CategorysCollect;
use App\Entities\ItemsCollect;
use App\Models\CategorysCollectModel;
use App\Models\ItemsCollectModel;

// use App\Models\ExchangeInfoModel;
use Config\Services;

class LcscApiController extends BaseController
{

    protected $categorysCollectModel;
    // protected $exchangeInfoModel;

    public function __construct()
    {

        $this->categorysCollectModel = new CategorysCollectModel();
        $this->itemsCollectModel = new ItemsCollectModel();

        // $this->exchangeInfoModel = new ExchangeInfoModel();
    }


    public function index(){   
        echo "There is a Lcsc Api Info.";
        exit;
    }


    public function categoryCollect () {
        // echo "There is a Category Collect.";
        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
        $nonce = "63yeike7dy6c2kjd";

        $timestamp = time();
        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
        $str_encode = sha1($str);

        $url = 'https://ips.lcsc.com/rest/wmsc2agent/category?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode;;
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $ch_response = curl_exec($ch);
        $err = curl_error($ch);

        if ($err) {
        echo "cURL Error #:" . $err;
        curl_close($ch);
        } else {
        curl_close($ch);
        // echo "받은 정보 : <br>";
        // var_dump ($ch_response);

            $details = json_decode($ch_response,true);
            $results = $details["result"];

            if ($results) {
                foreach($results as $resultsdata){
                    /*
                    var_dump ($resultsdata["id"]);
                    echo "<br>";
                    var_dump ($resultsdata["name"]);
                    echo "<br>";
                    var_dump ($resultsdata["product_quantity"]);
                    exit;
                    */
                    
                    $childrens = $resultsdata["children"];

                    foreach($childrens as $childrensdata){

                        $categorysCollect = new CategorysCollect();

                            $categorysCollect->level1_id = $resultsdata["id"];
                            $categorysCollect->level1_name = $resultsdata["name"];
                            $categorysCollect->level1_product_quantity = $resultsdata["product_quantity"];
                            $categorysCollect->level2_id = $childrensdata["id"];
                            $categorysCollect->level2_name = $childrensdata["name"];
                            $categorysCollect->level2_product_quantity = $childrensdata["product_quantity"];

                        $this->categorysCollectModel->insert($categorysCollect);
                    }
                }
            }
        }
    }


    public function itemToTxt () {
        // echo "There is a Item List.";
        // exit;

        // $category_id = "11260";
        // $end_page = 8;

        // https://chipdirect.co.kr/lcscapi/itemtotxt?category_id=11260&end_page=8

        $category_id = $this->request->getGet('category_id');
        $end_page = $this->request->getGet('end_page');
        
        // echo $category_id."<br>".$end_page;
        // exit;

        $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
        $pathFile = FileHelper::FOLDER_PATCH_API_DETAILTOTEXT;
        $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';

        $dir_count = 0;
        $file_count = 0;

        $result=opendir($filepath);
        while($file=readdir($result)) {
           if($file=="."||$file=="..") {continue;}
           $fileInfo = pathinfo($file);
           $fileExt = $fileInfo['extension'];
      
           If (empty($fileExt)){
              $dir_count++;
           } else {
              $file_count++;
           }
           
         }

        $filenum = $file_count+1;

        for($j=1;$j <= $end_page;$j++){

        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
        $nonce = "63yeike7dy6c2kjd";

        $dataRow = 99;

        $timestamp = time();

        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
        $str_encode = sha1($str);

        $url = 'https://ips.lcsc.com/rest/wmsc2agent/category/product/'.$category_id.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode.'&current_page='.$j;

        echo $url."<br>";
              
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $ch_response = curl_exec($ch);
        $err = curl_error($ch);

        if ($err) {
        echo "cURL Error #:" . $err;
        curl_close($ch);
        } else {
        curl_close($ch);

        // var_dump($ch_response);
        // exit;

            $details = json_decode($ch_response,true);
            $results = $details["result"];

            if ($results) {
                for($i=0;$i <= $dataRow;$i++){
                foreach($results as $key => $resultsdata){

                    $item_id = $resultsdata[$i]["id"];
                    $item_number = $resultsdata[$i]["number"];
                    $category_id1 = $resultsdata[$i]["category"]["id1"];
                    $category_name1 = $resultsdata[$i]["category"]["name1"];
                    $category_id2 = $resultsdata[$i]["category"]["id2"];
                    $category_name2 = $resultsdata[$i]["category"]["name2"];
                    $manufacturer_id = $resultsdata[$i]["manufacturer"]["id"];
                    $manufacturer_name = $resultsdata[$i]["manufacturer"]["name"];
                    $package = $resultsdata[$i]["package"];
                    $title = $resultsdata[$i]["title"];
                    $mpn = $resultsdata[$i]["mpn"];
                    $quantity = $resultsdata[$i]["quantity"];
                    $whs_js = $resultsdata[$i]["whs-js"];
                    $whs_zh = $resultsdata[$i]["whs-zh"];
                    $whs_hk = $resultsdata[$i]["whs-hk"];
                    $moq = $resultsdata[$i]["moq"];
                    $order_multiple = $resultsdata[$i]["order_multiple"];
                    $weight= $resultsdata[$i]["weight"];
                    $packaging = $resultsdata[$i]["packaging"];
                    $sell_unit = $resultsdata[$i]["sell_unit"];
                    $packing_num = $resultsdata[$i]["packing_num"];
                    $packing_unit = $resultsdata[$i]["packing_unit"];
                    $prices0_min_qty = $resultsdata[$i]["prices"][0]["min_qty"];
                    $prices0_max_qty = $resultsdata[$i]["prices"][0]["max_qty"];
                    $prices0_currency = $resultsdata[$i]["prices"][0]["currency"];
                    $prices0_price = $resultsdata[$i]["prices"][0]["price"];
                    $prices1_min_qty = $resultsdata[$i]["prices"][1]["min_qty"];
                    $prices1_max_qty = $resultsdata[$i]["prices"][1]["max_qty"];
                    $prices1_currency = $resultsdata[$i]["prices"][1]["currency"];
                    $prices1_price = $resultsdata[$i]["prices"][1]["price"];
                    $prices2_min_qty = $resultsdata[$i]["prices"][2]["min_qty"];
                    $prices2_max_qty = $resultsdata[$i]["prices"][2]["max_qty"];
                    $prices2_currency = $resultsdata[$i]["prices"][2]["currency"];
                    $prices2_price = $resultsdata[$i]["prices"][2]["price"];
                    $prices3_min_qty = $resultsdata[$i]["prices"][3]["min_qty"];
                    $prices3_max_qty = $resultsdata[$i]["prices"][3]["max_qty"];
                    $prices3_currency = $resultsdata[$i]["prices"][3]["currency"];
                    $prices3_price = $resultsdata[$i]["prices"][3]["price"];
                    $prices4_min_qty = $resultsdata[$i]["prices"][4]["min_qty"];
                    $prices4_max_qty = $resultsdata[$i]["prices"][4]["max_qty"];
                    $prices4_currency = $resultsdata[$i]["prices"][4]["currency"];
                    $prices4_price = $resultsdata[$i]["prices"][4]["price"];
                    $prices5_min_qty = $resultsdata[$i]["prices"][5]["min_qty"];
                    $prices5_max_qty = $resultsdata[$i]["prices"][5]["max_qty"];
                    $prices5_currency = $resultsdata[$i]["prices"][5]["currency"];
                    $prices5_price = $resultsdata[$i]["prices"][5]["price"];
                    $datasheet_pdf = $resultsdata[$i]["datasheet"]["pdf"];
                    $images0 = $resultsdata[$i]["images"][0]["900x900"];
                    $images1 = $resultsdata[$i]["images"][1]["900x900"];
                    $images2 = $resultsdata[$i]["images"][2]["900x900"];
                    $rohs = $resultsdata[$i]["rohs"];
                    $description = $resultsdata[$i]["description"];
                    $isPreSale = $resultsdata[$i]["isPreSale"];

                    if ($item_id) {

                    $uploadpath = FileHelper::FOLDER_PATH_UPLOAD;
                    $pathFile = FileHelper::FOLDER_PATCH_API_TOTEXT;
                    $filepath = PUBLIC_PATH.$uploadpath.'/'.$pathFile.'/';
                    $filename = "itemstext".$filenum;
            

                    $fp = fopen($filepath.$filename.".csv", "a");
                    $text = $item_id.','.$item_number.','.$category_id1.','.$category_name1.','.$category_id2.','.$category_name2.','.$manufacturer_id.',"'.$manufacturer_name.'",'.$package.',"'.$title.'",'.$mpn.','.$quantity.','.$whs_js.','.$whs_zh.','.$whs_hk.','.$moq.','.$order_multiple.','.$weight.','.$packaging.','.$sell_unit.','.$packing_num.','.$packing_unit.','.$prices0_min_qty.','.$prices0_max_qty.','.$prices0_currency.','.$prices0_price.','.$prices1_min_qty.','.$prices1_max_qty.','.$prices1_currency.','.$prices1_price.','.$prices2_min_qty.','.$prices2_max_qty.','.$prices2_currency.','.$prices2_price.','.$prices3_min_qty.','.$prices3_max_qty.','.$prices3_currency.','.$prices3_price.','.$prices4_min_qty.','.$prices4_max_qty.','.$prices4_currency.','.$prices4_price.','.$prices5_min_qty.','.$prices5_max_qty.','.$prices5_currency.','.$prices5_price.','.$datasheet_pdf.','.$images0.','.$images1.','.$images2.','.$rohs.',"'.$description.'",'.$isPreSale;

                    fwrite($fp, $text."\n");
                    fclose($fp);

                    }

                }

              }
            }

          }

        }

    }
    

    public function itemList () {
        $key = "BsC95BSUFCR95DftYEpz0bCAUvMK7OD";
        $secret = "O3PsFLzjbVQNaj7Eqn4uf5WFT5AwTIlfSR4FJ";
        $nonce = "63yeike7dy6c2kjd";

        $category_id = "612";

        $end_current_page = 8;
        // $current_page = 50;

        $dataRow = 99;
        $timestamp = time();

        for($current_page=1;$current_page <= $end_current_page;$current_page++):

        $str = 'key='.$key.'&nonce='.$nonce.'&secret='.$secret.'&timestamp='.$timestamp;
        $str_encode = sha1($str);
        $url = 'https://ips.lcsc.com/rest/wmsc2agent/category/product/'.$category_id.'?key='.$key.'&nonce='.$nonce.'&timestamp='.$timestamp.'&signature='.$str_encode.'&current_page='.$current_page;
        $headers[] = 'Accept: application/json';
        $headers[] = 'Cache-Control: no-cache';

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $ch_response = curl_exec($ch);
        $err = curl_error($ch);

        if ($err) {
        echo "cURL Error #:" . $err;
        curl_close($ch);
        } else {
        curl_close($ch);
            $details = json_decode($ch_response,true);
            $results = $details["result"];

            if ($results) {
                for($i=0;$i <= $dataRow;$i++):

                foreach($results as $resultsdata){

                    $item_id = $resultsdata[$i]["id"];
                    $item_number = $resultsdata[$i]["number"];
                    $category_id1 = $resultsdata[$i]["category"]["id1"];
                    $category_name1 = $resultsdata[$i]["category"]["name1"];
                    $category_id2 = $resultsdata[$i]["category"]["id2"];
                    $category_name2 = $resultsdata[$i]["category"]["name2"];
                    $manufacturer_id = $resultsdata[$i]["manufacturer"]["id"];
                    $manufacturer_name = $resultsdata[$i]["manufacturer"]["name"];
                    $package = $resultsdata[$i]["package"];
                    $title = $resultsdata[$i]["title"];
                    $mpn = $resultsdata[$i]["mpn"];
                    $quantity = $resultsdata[$i]["quantity"];
                    $whs_js = $resultsdata[$i]["whs-js"];
                    $whs_zh = $resultsdata[$i]["whs-zh"];
                    $whs_hk = $resultsdata[$i]["whs-hk"];
                    $moq = $resultsdata[$i]["moq"];
                    $order_multiple = $resultsdata[$i]["order_multiple"];
                    $weight= $resultsdata[$i]["weight"];
                    $packaging = $resultsdata[$i]["packaging"];
                    $sell_unit = $resultsdata[$i]["sell_unit"];
                    $packing_num = $resultsdata[$i]["packing_num"];
                    $packing_unit = $resultsdata[$i]["packing_unit"];
                    $prices0_min_qty = $resultsdata[$i]["prices"][0]["min_qty"];
                    $prices0_max_qty = $resultsdata[$i]["prices"][0]["max_qty"];
                    $prices0_currency = $resultsdata[$i]["prices"][0]["currency"];
                    $prices0_price = $resultsdata[$i]["prices"][0]["price"];
                    $prices1_min_qty = $resultsdata[$i]["prices"][1]["min_qty"];
                    $prices1_max_qty = $resultsdata[$i]["prices"][1]["max_qty"];
                    $prices1_currency = $resultsdata[$i]["prices"][1]["currency"];
                    $prices1_price = $resultsdata[$i]["prices"][1]["price"];
                    $prices2_min_qty = $resultsdata[$i]["prices"][2]["min_qty"];
                    $prices2_max_qty = $resultsdata[$i]["prices"][2]["max_qty"];
                    $prices2_currency = $resultsdata[$i]["prices"][2]["currency"];
                    $prices2_price = $resultsdata[$i]["prices"][2]["price"];
                    $prices3_min_qty = $resultsdata[$i]["prices"][3]["min_qty"];
                    $prices3_max_qty = $resultsdata[$i]["prices"][3]["max_qty"];
                    $prices3_currency = $resultsdata[$i]["prices"][3]["currency"];
                    $prices3_price = $resultsdata[$i]["prices"][3]["price"];
                    $prices4_min_qty = $resultsdata[$i]["prices"][4]["min_qty"];
                    $prices4_max_qty = $resultsdata[$i]["prices"][4]["max_qty"];
                    $prices4_currency = $resultsdata[$i]["prices"][4]["currency"];
                    $prices4_price = $resultsdata[$i]["prices"][4]["price"];
                    $prices5_min_qty = $resultsdata[$i]["prices"][5]["min_qty"];
                    $prices5_max_qty = $resultsdata[$i]["prices"][5]["max_qty"];
                    $prices5_currency = $resultsdata[$i]["prices"][5]["currency"];
                    $prices5_price = $resultsdata[$i]["prices"][5]["price"];
                    $datasheet_pdf = $resultsdata[$i]["datasheet"]["pdf"];
                    $images0 = $resultsdata[$i]["images"][0]["900x900"];
                    $images1 = $resultsdata[$i]["images"][1]["900x900"];
                    $images2 = $resultsdata[$i]["images"][2]["900x900"];
                    $rohs = $resultsdata[$i]["rohs"];
                    $description = $resultsdata[$i]["description"];
                    $isPreSale = $resultsdata[$i]["isPreSale"];

                    if ($item_id) {
                    $text = $item_id.','.$item_number.','.$category_id1.','.$category_name1.','.$category_id2.','.$category_name2.','.$manufacturer_id.',"'.$manufacturer_name.'",'.$package.',"'.$title.'",'.$mpn.','.$quantity.','.$whs_js.','.$whs_zh.','.$whs_hk.','.$moq.','.$order_multiple.','.$weight.','.$packaging.','.$sell_unit.','.$packing_num.','.$packing_unit.','.$prices0_min_qty.','.$prices0_max_qty.','.$prices0_currency.','.$prices0_price.','.$prices1_min_qty.','.$prices1_max_qty.','.$prices1_currency.','.$prices1_price.','.$prices2_min_qty.','.$prices2_max_qty.','.$prices2_currency.','.$prices2_price.','.$prices3_min_qty.','.$prices3_max_qty.','.$prices3_currency.','.$prices3_price.','.$prices4_min_qty.','.$prices4_max_qty.','.$prices4_currency.','.$prices4_price.','.$prices5_min_qty.','.$prices5_max_qty.','.$prices5_currency.','.$prices5_price.','.$datasheet_pdf.','.$images0.','.$images1.','.$images2.','.$rohs.',"'.$description.'",'.$isPreSale;
                    echo $text."<br>";
                    }


                    /*
                    $itemsCollect = new ItemsCollect();
                    $itemsCollect->item_id = $resultsdata[$i]["id"];
                    $itemsCollect->item_number = $resultsdata[$i]["number"];
                    $itemsCollect->category_id1 = $resultsdata[$i]["category"]["id1"];
                    $itemsCollect->category_name1 = $resultsdata[$i]["category"]["name1"];
                    $itemsCollect->category_id2 = $resultsdata[$i]["category"]["id2"];
                    $itemsCollect->category_name2 = $resultsdata[$i]["category"]["name2"];
                    $itemsCollect->manufacturer_id = $resultsdata[$i]["manufacturer"]["id"];
                    $itemsCollect->manufacturer_name = $resultsdata[$i]["manufacturer"]["name"];
                    $itemsCollect->package = $resultsdata[$i]["package"];
                    $itemsCollect->title = $resultsdata[$i]["title"];
                    $itemsCollect->mpn = $resultsdata[$i]["mpn"];
                    $itemsCollect->quantity = $resultsdata[$i]["quantity"];
                    $itemsCollect->whs_js = $resultsdata[$i]["whs-js"];
                    $itemsCollect->whs_zh = $resultsdata[$i]["whs-zh"];
                    $itemsCollect->whs_hk = $resultsdata[$i]["whs-hk"];
                    $itemsCollect->moq = $resultsdata[$i]["moq"];
                    $itemsCollect->order_multiple = $resultsdata[$i]["order_multiple"];
                    $itemsCollect->weight= $resultsdata[$i]["weight"];
                    $itemsCollect->packaging = $resultsdata[$i]["packaging"];
                    $itemsCollect->sell_unit = $resultsdata[$i]["sell_unit"];
                    $itemsCollect->packing_num = $resultsdata[$i]["packing_num"];
                    $itemsCollect->packing_unit = $resultsdata[$i]["packing_unit"];
                    $itemsCollect->prices0_min_qty = $resultsdata[$i]["prices"][0]["min_qty"];
                    $itemsCollect->prices0_max_qty = $resultsdata[$i]["prices"][0]["max_qty"];
                    $itemsCollect->prices0_currency = $resultsdata[$i]["prices"][0]["currency"];
                    $itemsCollect->prices0_price = $resultsdata[$i]["prices"][0]["price"];
                    $itemsCollect->prices1_min_qty = $resultsdata[$i]["prices"][1]["min_qty"];
                    $itemsCollect->prices1_max_qty = $resultsdata[$i]["prices"][1]["max_qty"];
                    $itemsCollect->prices1_currency = $resultsdata[$i]["prices"][1]["currency"];
                    $itemsCollect->prices1_price = $resultsdata[$i]["prices"][1]["price"];
                    $itemsCollect->prices2_min_qty = $resultsdata[$i]["prices"][2]["min_qty"];
                    $itemsCollect->prices2_max_qty = $resultsdata[$i]["prices"][2]["max_qty"];
                    $itemsCollect->prices2_currency = $resultsdata[$i]["prices"][2]["currency"];
                    $itemsCollect->prices2_price = $resultsdata[$i]["prices"][2]["price"];
                    $itemsCollect->prices3_min_qty = $resultsdata[$i]["prices"][3]["min_qty"];
                    $itemsCollect->prices3_max_qty = $resultsdata[$i]["prices"][3]["max_qty"];
                    $itemsCollect->prices3_currency = $resultsdata[$i]["prices"][3]["currency"];
                    $itemsCollect->prices3_price = $resultsdata[$i]["prices"][3]["price"];
                    $itemsCollect->prices4_min_qty = $resultsdata[$i]["prices"][4]["min_qty"];
                    $itemsCollect->prices4_max_qty = $resultsdata[$i]["prices"][4]["max_qty"];
                    $itemsCollect->prices4_currency = $resultsdata[$i]["prices"][4]["currency"];
                    $itemsCollect->prices4_price = $resultsdata[$i]["prices"][4]["price"];
                    $itemsCollect->prices5_min_qty = $resultsdata[$i]["prices"][5]["min_qty"];
                    $itemsCollect->prices5_max_qty = $resultsdata[$i]["prices"][5]["max_qty"];
                    $itemsCollect->prices5_currency = $resultsdata[$i]["prices"][5]["currency"];
                    $itemsCollect->prices5_price = $resultsdata[$i]["prices"][5]["price"];
                    $itemsCollect->datasheet_pdf = $resultsdata[$i]["datasheet"]["pdf"];
                    $itemsCollect->images0 = $resultsdata[$i]["images"][0]["900x900"];
                    $itemsCollect->images1 = $resultsdata[$i]["images"][1]["900x900"];
                    $itemsCollect->images2 = $resultsdata[$i]["images"][2]["900x900"];
                    $itemsCollect->rohs = $resultsdata[$i]["rohs"];
                    $itemsCollect->description = $resultsdata[$i]["description"];
                    $itemsCollect->isPreSale = $resultsdata[$i]["isPreSale"];
                    $this->itemsCollectModel->insert($itemsCollect);
                    */

                }
                endfor;
            }
        }
        endfor;
    }
    

}