<?php
namespace App\Controllers\Guest;


//use App\Controllers\BaseController;
use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use App\Models\QsManufacturerModel;

class MakersController extends BaseController
{

    protected $qsManufacturerModel;

    public function __construct()
    {

        $this->qsManufacturerModel = new QsManufacturerModel();

    }


    public function index()
    {
        return $this->viewGuest('autosearch/index3');
    }

    public function getMakers(){

        $request = service('request');
        $postData = $request->getPost();

        $response = array();

        // Read new token and assign in $response['token']
        $response['token'] = csrf_hash();
        $data = array();

        if(isset($postData['search'])){

            $search = $postData['search'];

            // Fetch record
            $makerlist =  $this->qsManufacturerModel->select('id,name')
                ->like('name',$search)
                ->orderBy('name')
                ->findAll(8);

            foreach($makerlist as $maker){
                $data[] = array(
                    "value" => $maker['id'],
                    "label" => $maker['name'],
                );
            }
        }

        $response['data'] = $data;

        return $this->response->setJSON($response);

    }
}
