<?php namespace App\Controllers\Guest;


use App\Helpers\AuthHelpers;
use App\Helpers\FileHelper;
use App\Models\MemberModel;
use App\Models\MemberSubModel;

class MyInfoController extends BaseController
{
    private $memberModel;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->memberSubModel = new MemberSubModel();
    }

    public function validationMapFieldLabels()
    {
        return [
            'member_name' => lang_register('name'),
            'member_email' => lang_register('email'),
        ];
    }

    public function index(){
        $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
        $info = $this->memberModel->find($memberId);

        $membercode = $info->member_code;
        // var_dump($membercode);

        $subinfo = $this->memberSubModel->findByMemberCode($membercode);
        // var_dump($subinfo);
        // exit;

        $data['item'] = $info;
        $data['itemsub'] = $subinfo;
        
        $this->rules = $this->memberModel->getValidationRules(
            [
                'only' => array('member_email'),
                'except_rule' => [
                    'member_email' => 'is_unique'
                ]
            ]);

        $this->rules['member_email'] = $this->rules['member_email'].'|is_unique[members.member_email,member_id,'.$memberId.']';

        return $this->viewGuest('my/edit_info', $data);
    }

    public function update(){
        $this->rules = $this->memberModel->getValidationRules(
            [
                'only' => array('member_email'),
                'except_rule' => [
                    'member_email' => 'is_unique'
                ]
            ]);

        $memberId = AuthHelpers::getLoginInfoGuest()->member_id;

        $info = $this->memberModel->find($memberId);

        $member_name = $info->member_name;
        $category_id = $info->category_id;
        $member_phone = $info->member_phone;
        $member_zipcode = $info->member_zipcode;
        $member_address1 = $info->member_address1;
        $member_address2 = $info->member_address2;

        $old_info = json_encode($info);
        // echo $old_info;
        // exit;

        $membercode = $info->member_code;
        $subinfo = $this->memberSubModel->findByMemberCode($membercode);

        $old_subinfo = json_encode($subinfo);
        //echo $old_subinfo;
        //exit;

        $inputs = $this->request->getPost();

        if(isset($info)){
            $this->rules['member_email'] = $this->rules['member_email'].'|is_unique[members.member_email,member_id,'.$memberId.']';
            $info->member_name = $this->request->getPost('member_name');
            $info->category_id = $this->request->getPost('category_id');
            $info->member_phone = $this->request->getPost('member_phone');
            $info->member_zipcode = $this->request->getPost('member_zipcode');
            $info->member_address1 = $this->request->getPost('member_address1');
            $info->member_address2 = $this->request->getPost('member_address2');

            $old_password = $this->request->getPost('old_password');
            $password = $this->request->getPost('password');
            $pass_confirm = $this->request->getPost('pass_confirm');


            if($old_password){

                if($password){
                    if($account = $this->memberModel->checkCode($membercode, $old_password)){

                        if($password == $pass_confirm){
                            $info->password = md5($password);
                            //var_dump($password);
                            //exit;
                        } else {
                            $refererUrl = $_SERVER['HTTP_REFERER'];
        
                            session()->setFlashdata('status_text', '새비밀번호와 확인이 일치하지 않습니다.');
                            return redirect()->to($refererUrl)
                                ->with('status_icon', 'warning')
                                ->with('status', '정보 불일치');
                        }
        
                    } else {
                        $refererUrl = $_SERVER['HTTP_REFERER'];
    
                        session()->setFlashdata('status_text', '기존 비밀번호가 일치하지 않습니다.');
                        return redirect()->to($refererUrl)
                            ->with('status_icon', 'warning')
                            ->with('status', '정보 불일치');
                    }
                
                } else {
                    $refererUrl = $_SERVER['HTTP_REFERER'];

                    session()->setFlashdata('status_text', '비밀번호를 변경하려면 새 비밀번호과 확인을 모두 입력하세요.');
                    return redirect()->to($refererUrl)
                        ->with('status_icon', 'warning')
                        ->with('status', '정보 없음');
                }
        
            }


            $new_info = json_encode($info);
            //echo $new_info;
            //exit;

            if(isset($subinfo)){
                $subinfo->com_name =  $this->request->getPost('com_name');
                $subinfo->com_englishname = $this->request->getPost('com_englishname');
                $subinfo->biz_number = $this->request->getPost('biz_number');
                $subinfo->ceo_name = $this->request->getPost('ceo_name');
                $subinfo->com_zipcode = $this->request->getPost('com_zipcode');
                $subinfo->com_address1 = $this->request->getPost('com_address1');
                $subinfo->com_address2 = $this->request->getPost('com_address2');
                $subinfo->com_phone = $this->request->getPost('com_phone');
                $subinfo->com_fax = $this->request->getPost('com_fax');
                $subinfo->invoice_email = $this->request->getPost('invoice_email');
                $subinfo->homepage = $this->request->getPost('homepage');
                $subinfo->sectors = $this->request->getPost('sectors');
                $subinfo->condition = $this->request->getPost('condition');
                $subinfo->account_bankname = $this->request->getPost('account_bankname');
                $subinfo->account_number = $this->request->getPost('account_number');
                $subinfo->account_depositor = $this->request->getPost('account_depositor');

                $new_subinfo = json_encode($subinfo);
                // echo $new_subinfo;
                // exit;
            }

            // if($this->checkValidation($inputs)){

            if($inputs){
                // $fileImage = $this->request->getFile('avatar_dir');
                // $newImageName = $fileImage->getClientName();

                if($new_info != $old_info || $newImageName){
                    
                    if(isset($fileImage) && !empty($fileImage->getClientName())){
                        FileHelper::deleteFile($info->avatar_dir);
                        $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_MEMBER, $memberId);
                        $info->avatar_dir = $fileImagePath;
                    }

                    $this->memberModel->save($info);
                }

                if($new_subinfo != $old_subinfo){
                    $this->memberSubModel->save($subinfo);
                }

                AuthHelpers::setLoginGuest($info->toSession());
                return redirect()->route('guest.my.info_edit')->with('message', '정보 업데이트 성공');
                //return $this->subupdate($subinfo, $inputs);
            }else{
                return redirect()->route('guest.my.info_edit')->withInput();
            }
        }
        return redirect()->route('guest.my.info_edit')->with('error', 'Member do not exit.');
    }

    /*
    public function subupdate($subinfo, $inputs){
                $this->memberSubModel->save($subinfo);
                return redirect()->route('guest.my.info_edit')->with('message', '정보 업데이트 성공');
    }
    */

}
