<?php 
namespace App\Controllers\Guest;

use App\Controllers\Guest\BaseController;
use App\Entities\Member;
use App\Helpers\ArrayHelper;
use App\Helpers\AuthHelpers;
use App\Helpers\Common\EmailHelper;
use App\Helpers\DateHelper;
use App\Helpers\NumberHelper;
use App\Models\MemberModel;
use Config\Services;

class NaverApiController extends BaseController
{

    protected $memberModel;
    protected $emailHelper;

    public function __construct()
    {
        $this->memberModel = new MemberModel();
        $this->emailHelper = new EmailHelper();
    }

    public function index(){   
        //echo "There is a Test.";
        //exit;
        return $this->viewGuest('naverapi/index');
    }

    public function naverLogin(){   
        //echo "There is a Login Test.";
        //exit;
        return $this->viewGuest('naverapi/naverlogin');
    }

    public function naverInfo(){   
 
        session_start();
 
        define('NAVER_CLIENT_ID', 'bS6uqBpR00835BFLFGDa');
        define('NAVER_CLIENT_SECRET', 'aETxh2Ecip');

        define('NAVER_CALLBACK_URL', 'https://chipdirect.co.kr/naverapi/naverinfo');
        $naver_curl = "https://nid.naver.com/oauth2.0/token?grant_type=authorization_code&client_id=".NAVER_CLIENT_ID."&state=NAVER_LOGIN_TEST&client_secret=".NAVER_CLIENT_SECRET."&redirect_uri=".urlencode(NAVER_CALLBACK_URL)."&code=".$_GET['code'];

        // define('NAVER_CALLBACK_URL', 'http://localhost/naverapi/naverinfo');
        // $naver_curl = "https://nid.naver.com/oauth2.0/token?grant_type=authorization_code&client_id=".NAVER_CLIENT_ID."&state=NAVER_LOGIN_TEST&client_secret=".NAVER_CLIENT_SECRET."&redirect_uri=".urlencode(NAVER_CALLBACK_URL)."&code=".$_GET['code'];
        
        // 토큰값 가져오기 
        $is_post = false; 
        $ch = curl_init(); 
        curl_setopt($ch, CURLOPT_URL, $naver_curl); 
        curl_setopt($ch, CURLOPT_POST, $is_post); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
         
        $response = curl_exec ($ch); 
        $status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE); 
        curl_close ($ch); 
         
        if($status_code == 200){ 
            $responseArr = json_decode($response, true); 
         
              // 토큰값으로 네이버 회원정보 가져오기 
              $headers = array( 'Content-Type: application/json', sprintf('Authorization: Bearer %s', $responseArr['access_token']) ); 
              $is_post = false; 
              $me_ch = curl_init(); 
              curl_setopt($me_ch, CURLOPT_URL, "https://openapi.naver.com/v1/nid/me"); 
              curl_setopt($me_ch, CURLOPT_POST, $is_post ); 
              curl_setopt($me_ch, CURLOPT_HTTPHEADER, $headers); 
              curl_setopt($me_ch, CURLOPT_RETURNTRANSFER, true); 
              $res = curl_exec ($me_ch); 
              curl_close ($me_ch); 
              $res_data = json_decode($res , true);

              //var_dump($res_data);
              //exit;

              $email = $res_data["response"]["email"];
              $mobile = $res_data["response"]["mobile"];
              $name = $res_data["response"]["name"];
              // var_dump ($email);

            if($account = $this->memberModel->checkNeverLogin($email, $mobile)){
                $account->last_login_date = DateHelper::now();
                $this->memberModel->save($account);
                $account->remember = isset($remember) ? 1 : 0;
                AuthHelpers::setLoginGuest($account->toSession());
                if($account->remember == REMEMBER_FLG_ON){
                    AuthHelpers::setCookieLoginGuest($account,$this->redirectResponse);
                }

                $refererUrl =  AuthHelpers::getSession()->get(AuthHelpers::BACK_URL_LOGIN);

                if (!$refererUrl) {

                    return redirect()->route('guest.home')->withInput();

                }else{

                    $arrayNotBack = ['forgot-password', 'login', 'register'];
                    if(ArrayHelper::searchValueContainArray($refererUrl,$arrayNotBack) === false ){
                        AuthHelpers::getSession()->remove(AuthHelpers::BACK_URL_LOGIN);
                        return redirect()->to($refererUrl);
                    }

                    return redirect()->route('guest.home')->withInput();
                    
                }

            }else{

                $data = [
                    'member_email' => $email,
                    'member_name'  => $name,
                    'member_phone' => $mobile
                ];

                return $this->viewGuest('naverapi/naverinfo', $data);

            }

        
        }

    }

}
