<?php 
namespace App\Controllers\Guest;

// use App\Entities\MemberInquiry;
use App\Entities\Notice;
use App\Helpers\AuthHelpers;
// use App\Models\AppInfoModel;
// use App\Models\MemberInquiryModel;
use App\Models\NoticeModel;
use App\Models\NoticeCategoryModel;
use App\Services\NoticeService;
use App\Helpers\FileHelper;
use App\Models\NoticeFileModel;
use App\Entities\NoticeFile;

class NoticeController extends BaseController
{
    // protected $memberInquiryModel;
    protected $noticeModel;
    protected $noticeFileModel;
    protected $noticeCategoryModel;
    protected $noticeService;

    public function __construct()
    {
        // $this->memberInquiryModel = new MemberInquiryModel();
        // $this->appInfoModel = new AppInfoModel();

        $this->noticeModel = new NoticeModel();
        $this->noticeFileModel = new NoticeFileModel();
        $this->noticeCategoryModel = new NoticeCategoryModel();
        $this->noticeService = new NoticeService();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }

    /*
    public function location()
    {
        $appInfo = $this->appInfoModel->fistInfo();
        $data['appInfo'] = $appInfo;
        return $this->viewGuest('notice/location', $data);
    }

    public function inquiry()
    {
        $this->rules = $this->memberInquiryModel->getValidationRules();
        $account = AuthHelpers::getLoginInfoGuest();
        $data['memberName'] = '';
        $data['memberEmail'] = '';
        if(isset($account)){
            $data['memberName'] = $account->member_name;
            $data['memberEmail'] = $account->member_email;
        }
        return $this->viewGuest('notice/inquiry', $data);
    }

    public function createInquiry(){
        $this->rules = $this->memberInquiryModel->getValidationRules();
        if($this->checkValidation()){
            //Create Inquiry
            $inquiry = new MemberInquiry($this->request->getPost());
            $this->memberInquiryModel->save($inquiry);
            $message = 'Create inquiry success.';
            return redirect()->route('guest.contact.inquiry')->with('message' , $message);
        }else{
            return redirect('guest.contact.inquiry')->withInput();
        }
    }
    */

    public function index(){        
        $perPage = $this->request->getGet('perpage');
        $searchInput = $this->request->getGet();
        if( isset($searchInput['title']) && $searchInput['title'] != '' ) $searchInput['is_search'] = true;
        $data = $this->noticeModel->getSearch($searchInput,$perPage);
        //var_dump ($data);
        //exit;
        return $this->viewGuest('notice/index', array_merge($data,$searchInput));
    }

    public function detail($noticeId){
        $item = $this->noticeModel->findInfoById($noticeId);
        $files = $this->noticeFileModel->where('notice_id',$noticeId)->findAll();
        $data['item'] = $item;
        $data['files'] = $files;
        //increase hit
        $isViewSession = AuthHelpers::getSession()->get(AuthHelpers::SESSION_INCREASE_HIT_NOTICE);
        if(!isset($isViewSession) || (is_array($isViewSession) && !in_array($noticeId, $isViewSession))){
            if(!isset($isViewSession)) $isViewSession = [];
            $isViewSession[] = $noticeId;
            AuthHelpers::getSession()->set(AuthHelpers::SESSION_INCREASE_HIT_NOTICE, $isViewSession);
            $this->noticeModel->update(['id' => $noticeId], ['hit_number' => $item->hit_number + 1]);
        }
        return $this->viewGuest('notice/notice_detail', $data);
    }

    public function showCreate(){
        $this->rules = $this->noticeModel->getValidationRules();

        $categories = $this->noticeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['maxFiles'] = 10;
        // var_dump ($data);
        // exit;

        return $this->viewGuest('notice/notice_create', $data);
    }

    public function create(){
        $this->rules = $this->noticeModel->getValidationRules();

        if($this->checkValidation()){
            $notice = new Notice($this->request->getPost());
            $insertId = $this->noticeModel->insert($notice, true);

            if($insertId > 0){
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NOTICE, $insertId);
                            $noticeFile = new NoticeFile([
                                'notice_id' => esc($insertId),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->noticeFileModel->save($noticeFile);
                        }
                    }
                }
            }
        

            /*
            // $this->rules = $this->noticeModel->getValidationRules();
            // echo "There is a Test.";
            // exit;
            */

            // 관리자 정보추가
            // $accountManger = AuthHelpers::getLoginInfoAdmin();
            // $this->noticeService->saveNotice($this->request,$accountManger->account_id);
            // $this->noticeService->saveNotice($this->request);

            $message = 'Create notice success.';
            return redirect()->route('guest.notice')->with('message' , $message);
        }else{
            return $this->viewGuest('notice/notice_create', [
                'validator' => $this->validator
            ]);
        }

    }

    public function showUpdate($id){
        $this->rules = $this->noticeModel->getValidationRules();
        $noticeItem = $this->noticeModel->find($id);
        $files = $this->noticeFileModel->where('notice_id',$id)->findAll();
        $categories = $this->noticeCategoryModel->findAll();
        $data['categories'] = $categories;
        $data['item'] = $noticeItem;
        $data['files'] = $files;
        $data['maxFiles'] = 10 - count($files);
        // var_dump($data);
        // exit;

        return $this->viewGuest('notice/update', $data);
    }

    public function update($id){
        $this->rules = $this->noticeModel->getValidationRules();

        if($this->checkValidation()){
            // $this->noticeService->updateNotice($id,$this->request);
            $noticeItem = $this->noticeModel->find($id);

            if(isset($noticeItem)){
                $inputs = $this->request->getPost();

                $inputs['public_flg'] = get_public_id($inputs['public_flg']);
                $noticeItem->fill($inputs);

                //var_dump($noticeItem);
                //exit;

                $this->noticeModel->save($noticeItem);
                $files = $this->request->getFiles();
                // var_dump($files);
                // exit;

                if(isset($files)){
                    foreach ($files as $file){
                        $fileName = $file->getClientName();
                        if(isset($fileName) && !empty($fileName)){
                            $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NOTICE, $insertId);
                            $noticeFile = new NoticeFile([
                                'notice_id' => esc($id),
                                'file_name' => esc($fileName),
                                'file_dir' => esc($filePath)
                            ]);
                            $this->noticeFileModel->save($noticeFile);
                        }
                    }
                }

            }


            $message = "Update notice success";
            return redirect()->route('guest.notice')->with('message',$message);
        }else{
            return view('notice/update', [
                'validator' => $this->validator
            ]);
        }
    }

    public function deleteNews($strIds){
        $message = "";
        if(isset($strIds)){
            $ids = explode(',',$strIds);
            $result = $this->noticeService->deleteNews($ids);
            if($result) $message = "Delete notice success";
        }
        return redirect()->route('guest.notice')->with('message',$message);
    }

    public function deleteFile($noticeId,$fileNo){
        $this->noticeFileModel->delete($fileNo);
        $message = "Delete file success";
        return redirect()->route('guest.notice.update',[$noticeId])->with('message',$message);;
    }

    public function viewFile($noticeId, $fileId){
        $file = $this->noticeFileModel->findNoticeFile($noticeId, $fileId);
        if(isset($file)){
            $pdfPath = $file->file_dir;
            $filename = "$file->file_name";
            $this->setHeaderViewFile($filename,PUBLIC_PATH . $pdfPath);
        }
        exit;
    }

}
