<?php 
namespace App\Controllers\Guest;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use App\Helpers\AuthHelpers;
use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use App\Entities\OrderInfo;
use App\Models\OrderInfoModel;
use App\Models\OrderPartinfoModel;
use App\Services\OrderInfoService;
use App\Models\ProductModel;
use App\Models\MemberModel;

class OrderController extends BaseController
{
    protected $orderInfoModel;
    protected $orderPartinfoModel;
    protected $orderInfoService;
    protected $productModel;
    protected $memberModel;

    public function __construct()
    {
        $this->orderInfoModel = new OrderInfoModel();
        $this->orderPartinfoModel = new OrderPartinfoModel();
        $this->orderInfoService = new OrderInfoService();
        $this->productModel = new ProductModel();
        $this->memberModel = new MemberModel();
    }

    /*
    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }
    */

    /*
    public function index(){        
        //var_dump ($member_code);
        //exit;

    }
    */

    /**
     * 네이버페이 결제
    */


    #########################################################
    ## 주문 정보 전송
    #########################################################

    public function naver_pay_post()
    {
        // exit; //Kevin.jung

        $request = \Config\Services::request();
        $param = $request->getPost();

        self::naver_pay_get($param);
    }
    
    public function naver_pay_get($object) {

        //  echo "naver_pay_get 실행됨.";        
        // var_dump ($object);
        
        $request =  $this->genOrderForm($object);
        header('Content-Type: application/xml;charset=utf-8');

        // echo $request;
        // exit;
   
        // 주문 등록 API 호출
        //$url = "https://test-api.pay.naver.com/o/customer/api/order/v20/register"; //네이버 페이 테스트
        $url = "https://api.pay.naver.com/o/customer/api/order/v20/register";
        $ci = curl_init();

        $headers = array('Content-Type: application/xml; charset=utf-8');

        curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ci, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ci, CURLOPT_URL, $url);
        curl_setopt($ci, CURLOPT_POST, TRUE);
        curl_setopt($ci, CURLOPT_TIMEOUT, 10);
        curl_setopt($ci, CURLOPT_POSTFIELDS, $request);
        
        // 주문 등록 후 결과값 확인
        $response = curl_exec($ci);
        
        curl_close ($ci);

        $param = explode(':', $response);
        if ($param[0] == "SUCCESS") { // 성공일 경우
        $requestParam = "/".$param[1]."/".$param[2];
        }

        // 주문서 URL 재전송(redirect)
        //$redirectUrl = "https://test-order.pay.naver.com/customer/buy".$requestParam; //네이버 페이 테스트
        $redirectUrl = "https://order.pay.naver.com/customer/buy".$requestParam;
        header("Location:".$redirectUrl);

        exit();

   }

   public function genOrderForm($product) {

    $item = $this->productModel->findByProductCode($product['part_sequence']);

    /*회원정보 호출 시작 */
    $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
    $info = $this->memberModel->find($memberId);
    $membercode = $info->member_code;

    $merchantId = "np_yyqii399489";
    $certiKey = "72A5F1F5-91A0-47E7-A01E-EBE5D3359AB2";
    $groupId = "ORD_NPY_".date(time());

    $goods_code = str_replace(' ','',$product['part_sequence']);
    $goods_name = $product['part_number'];

    if ($item->image_dir){
        // $goods_img = str_replace(' ','',$item->image_dir);
        $image_dir_str = substr($item->image_dir, 0, 4); 
        if ($image_dir_str == "http") {
            $goods_img = $item->image_dir;
        } else {
            $goods_img = asset_public($item->image_dir);
        }
    } else {
        $goods_img = asset_public('images/no_image_available.jpg');
    }

    $deli_cost = $item->delivery_price;
    $goods_brand = $item->name;
    $goods_cnt = $product['qty'];
    //$backUrl = "http://localhost/sale/detail/".$goods_code;
    //$goods_info_url = "http://localhost/sale/detail/".$goods_code;
    $backUrl = "https://chipdirect.co.kr/sale/detail/".$goods_code;
    $goods_info_url = "https://chipdirect.co.kr/sale/detail/".$goods_code;


    $price1 = $item->selling_price1;
    $quantity1 = $item->unit_mini_quantity1;
    $price2 = $item->selling_price2;
    $quantity2 = $item->unit_mini_quantity2;
    $price3 = $item->selling_price3;
    $quantity3 = $item->unit_mini_quantity3;
    $price4 = $item->selling_price4;
    $quantity4 = $item->unit_mini_quantity4;
    $price5 = $item->selling_price5;
    $quantity5 = $item->unit_mini_quantity5;
    $price6 = $item->selling_price6;
    $quantity6 = $item->unit_mini_quantity6;

    if ($goods_cnt >= $quantity6 and $price6 != 0) {
        $selling_price =  $price6;
    } elseif ($goods_cnt >= $quantity5 and $price5 != 0) {
        $selling_price =  $price5;
    } elseif ($goods_cnt >= $quantity4 and $price4 != 0) {
        $selling_price =  $price4;
    } elseif ($goods_cnt >= $quantity3 and $price3 != 0) {
        $selling_price =  $price3;
    } elseif ($goods_cnt >= $quantity2 and $price2 != 0) {
        $selling_price =  $price2;
    } elseif ($goods_cnt >= $quantity1 and $price1 != 0) {
        $selling_price =  $price1;
    }

    $goods_selling_vqt = round($selling_price*0.1);
    $goods_selling_price = $selling_price+$goods_selling_vqt;

    // $goods_selling_price = $item->selling_price1;

    $all_amount_price  = 0;
    $amount_price = 0;

    $amount_price = $goods_selling_price * $goods_cnt;
    $all_amount_price = $all_amount_price + $amount_price;

    $delivery_free_standard = 30000; // 배송료무료 기준설정

    /*
    if ($all_amount_price > $delivery_free_standard) {
        $deli_cost = 0;
    }
    */

    header('Content-Type: application/xml;charset=utf-8');
    $data = '<?xml version="1.0" encoding="utf-8"?>';

    $data .= '<order>';
        $data .= '<product>';
                        
        $data .= '<basePrice><![CDATA['.$goods_selling_price.']]></basePrice>';         
        $data .= '<id>'.$goods_code.'</id>';
        $data .= '<merchantProductId>'.$goods_code.'</merchantProductId>'; //판매자 상품 번호. 최대 100 자.
        $data .= '<imageUrl>'.$goods_img.'</imageUrl>';
        $data .= '<infoUrl><![CDATA['.$goods_info_url.']]></infoUrl>';
        $data .= '<name>'.htmlspecialchars($goods_name).'</name>';

        //$data .= '<single>';
        //$data .= '<quantity>'.$goods_cnt.'</quantity>';
        //$data .= '</single>';

        $data .= '<option>';
        $data .= '<quantity>'.$goods_cnt.'</quantity>';
        
            $data .= '<selectedItem>';
            $data .= '<type>INPUT</type>';
            $data .= '<name>브랜드</name>';                
            $data .= '<value>';
            $data .= '<id>BL</id>';
            $data .= '<text>'.$goods_brand.'</text>';
            $data .= '</value>';
            $data .= '</selectedItem>';

            $data .= '<selectedItem>';
            $data .= '<type>INPUT</type>';
            $data .= '<name>판매단가</name>';                
            $data .= '<value>';
            $data .= '<id>UP</id>';
            $data .= '<text>'.number_format($goods_selling_price).'원</text>';
            $data .= '</value>';
            $data .= '</selectedItem>';

            if ($membercode) {
                $data .= '<selectedItem>';
                $data .= '<type>INPUT</type>';
                $data .= '<name>UMID</name>';
                $data .= '<value>';
                $data .= '<id>UP</id>';
                $data .= '<text>'.$membercode.'</text>';
                $data .= '</value>';
                $data .= '</selectedItem>';
            }

        $data .= '</option>';


        $data .= '<shippingPolicy>';
        $data .= '<groupId>CHIPDIRECT</groupId>';

        if ($deli_cost == '0'){
            $data .= '<feePayType>FREE</feePayType>';   //배송비 결제 방법(무료)
            //$data .= '<feePayType>CASH_ON_DELIVERY</feePayType>';   //배송비 결제 방법(착불)
            $data .= '<feePrice>'.$deli_cost.'</feePrice>';    //기본 배송비
            $data .= '<feeType>FREE</feeType>';   //배송비 유형
        } else{
            $data .= '<feePayType>PREPAYED</feePayType>';   //배송비 결제 방법(선불)
            $data .= '<feePrice>'.$deli_cost.'</feePrice>';    //기본 배송비
            $data .= '<feeType>CONDITIONAL_FREE</feeType>';   //배송비 유형
            $data .= '<conditionalFree>';
            $data .= '<basePrice>'.$delivery_free_standard.'</basePrice>';
            $data .= '</conditionalFree>';
        }
            // $data .= '<groupId>'.$groupId.'</groupId>';   //Group Id
            $data .= '<method>DELIVERY</method>';   //배송 방법.
        $data .= '</shippingPolicy>';

        $data .= '</product>';

        $data .= '<merchantId>' . $merchantId . '</merchantId>';
        $data .= '<certiKey>' . $certiKey . '</certiKey>';
        $data .= '<backUrl><![CDATA[' . $backUrl.']]></backUrl>';
        $data .= '<interface>';
            $data .= '<cpaInflowCode>'.$_COOKIE['CPAValidator'].'</cpaInflowCode>';     /*네이버쇼핑 CPA 코드*/
            $data .= '<naverInflowCode>'.$_COOKIE['NA_CO'].'</naverInflowCode>';        /*네이버 서비스 유입 경로 코드*/
            $data .= '<saClickId>'.$_COOKIE['NVADID'].'</saClickId>';                   /*SA CLICK ID*/
        $data .= '</interface>';
        $data .= '</order>'; 

//echo($data);
//exit;

        return $data;

   }
    

    #########################################################
    ## 찜 정보 전송
    #########################################################

    function get_device_type() {
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $mobile_agents = array('iphone','ipod','ipad','android','webos','blackberry','nokia','opera mini','windows mobile','windows phone','iemobile');
        foreach($mobile_agents as $mobile_agent) {
            if (strpos(strtolower($user_agent), strtolower($mobile_agent)) !== false) {
                return 'mobile';
            }
        }
        return 'PC';
    }

    public function naver_pick()
    {

        // $data = [
        //     'status' => 'fail',
        //     'message' => '잠시 후 다시 시도해주세요.'
        // ];

        // $data_result = $this->response->setJSON($data);

        // 위에것이 테스트 할때 확인.

        $device_type = $this->get_device_type();

        $request = \Config\Services::request();
        $param = $request->getPost();
        

        $queryString = 'SHOP_ID='.urlencode('np_yyqii399489');
        $queryString .= '&CERTI_KEY='.urlencode('72A5F1F5-91A0-47E7-A01E-EBE5D3359AB2');
        $queryString .= '&RESERVE1=&RESERVE2=&RESERVE3=&RESERVE4=&RESERVE5=';
    
        $queryString .= '&ITEM_ID='.urlencode($param['goods_cd']);
        $queryString .= '&ITEM_NAME='.urlencode($param['goods_name']);
        $queryString .= '&ITEM_UPRICE='.$param['goods_price'];
        $queryString .= '&ITEM_IMAGE='.urlencode($param['goods_img']);
        $queryString .= '&ITEM_URL='.urlencode(base_url().'/sale/detail/'.$param['goods_cd']);
    
        //$req_addr = 'ssl://test-pay.naver.com';  //네이버 페이 테스트
        $req_addr = 'ssl://pay.naver.com';    
        $req_url = 'POST /customer/api/CP949/wishlist.nhn HTTP/1.1'; // utf-8
        //$req_host = 'test-pay.naver.com';  //네이버 페이 테스트
        $req_host = 'pay.naver.com';
        $req_port = 443;
    
        $nc_sock = @fsockopen($req_addr, $req_port, $errno, $errstr);
        if ($nc_sock) {
            fwrite($nc_sock, $req_url."\r\n" );
            fwrite($nc_sock, "Host: ".$req_host.":".$req_port."\r\n" );
            fwrite($nc_sock, "Content-type: application/x-www-form-urlencoded; charset=utf8\r\n"); // utf-8
            fwrite($nc_sock, "Content-length: ".strlen($queryString)."\r\n");
            fwrite($nc_sock, "Accept: */*\r\n");
            fwrite($nc_sock, "\r\n");
            fwrite($nc_sock, $queryString."\r\n");
            fwrite($nc_sock, "\r\n");
    
            // get header
            while(!feof($nc_sock)){
                $header=fgets($nc_sock,4096);
                if($header=="\r\n"){
                    break;
                } else {
                    $headers .= $header;
                }
            }
            // get body
            while(!feof($nc_sock)){
                $bodys.=fgets($nc_sock,4096);
            }
    
            fclose($nc_sock);
    
            $resultCode = substr($headers,9,3);
    
            if ($resultCode == 200) {
                // success
                $itemId = $bodys;

                if ($device_type == "mobile") {
                    //$wishlistPopupUrl = "https://test-m.pay.naver.com/mobile/customer/wishList.nhn"; //네이버 페이 테스트
                    $wishlistPopupUrl = "https://m.pay.naver.com/mobile/customer/wishList.nhn";
                } else {
                    //$wishlistPopupUrl = "https://test-pay.naver.com/customer/wishlistPopup.nhn "; //네이버 페이 테스트
                    $wishlistPopupUrl = "https://pay.naver.com/customer/wishlistPopup.nhn ";
                }

                //$this->response(array('status'=>'ok', 'itemId'=>$itemId, 'url'=>$wishlistPopupUrl),200);

                $data = [
                    'status' => 'ok',
                    'itemId' => $itemId,
                    'url' => $wishlistPopupUrl,
                ];
        
                $data_result = $this->response->setJSON($data);
            } else {
                // fail
                //$this->response(array('status'=>'fail', 'message'=>'잠시 후 다시 시도해주세요.'),200);

                $data = [
                    'status' => 'fail',
                    'message' => '잠시 후 다시 시도해주세요.'
                ];
        
                $data_result = $this->response->setJSON($data);
            }
        } else {
            exit(-1);
            //$this->response(array('status'=>'fail', 'message'=>'잠시 후 다시 시도해주세요.'),200);

            $data = [
                    'status' => 'fail',
                    'message' => '잠시 후 다시 시도해주세요.'
                ];
        
                $data_result = $this->response->setJSON($data);
        }
    


        return $data_result;
        
        

        //self::npay_cart_get($param);
    }
   

    #########################################################
    ## CART 주문정보 전송
    #########################################################

    public function npay_cart()
    {
        
        $request = \Config\Services::request();
        $param = $request->getPost();

        self::npay_cart_get($param);
    }
    
    public function npay_cart_get($object) {

        $request =  $this->cartOrderForm($object);
        header('Content-Type: application/xml;charset=utf-8');

        // 주문 등록 API 호출
        //$url = "https://test-api.pay.naver.com/o/customer/api/order/v20/register"; //네이버 페이 테스트
        $url = "https://api.pay.naver.com/o/customer/api/order/v20/register";
        $ci = curl_init();

        $headers = array('Content-Type: application/xml; charset=utf-8');

        curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ci, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
        curl_setopt($ci, CURLOPT_URL, $url);
        curl_setopt($ci, CURLOPT_POST, TRUE);
        curl_setopt($ci, CURLOPT_TIMEOUT, 10);
        curl_setopt($ci, CURLOPT_POSTFIELDS, $request);
        
        // 주문 등록 후 결과값 확인
        $response = curl_exec($ci);
        
        curl_close ($ci);

        $param = explode(':', $response);
        if ($param[0] == "SUCCESS") { // 성공일 경우
        $requestParam = "/".$param[1]."/".$param[2];
        }

        // 주문서 URL 재전송(redirect)
        //$redirectUrl = "https://test-order.pay.naver.com/customer/buy".$requestParam; //네이버 페이 테스트
        $redirectUrl = "https://order.pay.naver.com/customer/buy".$requestParam;
        header("Location:".$redirectUrl);

        exit();

   }

   public function cartOrderForm($product) {

    //echo($product['inquiry_code']."<br>");
    //var_dump ($product);
    //exit;

    /*회원정보 호출 시작 */
    $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
    $info = $this->memberModel->find($memberId);
    $membercode = $info->member_code;

    $merchantId = "np_yyqii399489";
    $certiKey = "72A5F1F5-91A0-47E7-A01E-EBE5D3359AB2";
    //$backUrl = "http://localhost/cart";
    $backUrl = "https://chipdirect.co.kr/cart";

    $groupId = "ORD_NPY_".date(time()); 

    header('Content-Type: application/xml;charset=utf-8');
    $data = '<?xml version="1.0" encoding="utf-8"?>';
    $data .= '<order>';
    
    $all_amount_price = $product['all_amount_price'];
    $delivery_free_standard = 30000; // 배송료무료 기준설정
    $dataRow = $product['dataRow']-1;

    for($i=1;$i <= $dataRow;$i++):

        $part_sequence = $product['product_code'.$i];
        // var_dump ($part_sequence);
        
        $item = $this->productModel->findByProductCode($part_sequence);

        $goods_code = str_replace(' ','',$part_sequence);
        $goods_name = $product['part_number'.$i];
        $deli_cost = $item->delivery_price;

        if ($item->image_dir){
            // $goods_img = str_replace(' ','',$item->image_dir);
            $image_dir_str = substr($item->image_dir, 0, 4); 
            if ($image_dir_str == "http") {
                $goods_img = $item->image_dir;
            } else {
                $goods_img = asset_public($item->image_dir);
            }
        } else {
            $goods_img = asset_public('images/no_image_available.jpg');
        }

        $inquiry_code = $product['inquiry_code'.$i];
        $goods_brand = $item->name;
        $goods_cnt = $product['p_num'.$i];
        //$goods_info_url = "http://localhost/sale/detail/".$goods_code;
        $goods_info_url = "https://chipdirect.co.kr/sale/detail/".$goods_code;
        $goods_selling_vqt = round($product['price'.$i]*0.1);
        $goods_selling_price = $product['price'.$i]+$goods_selling_vqt;


        $data .= '<product>';
                        
        $data .= '<basePrice><![CDATA['.$goods_selling_price.']]></basePrice>';         
        $data .= '<id>'.$goods_code.'</id>';
        $data .= '<merchantProductId>'.$goods_code.'</merchantProductId>'; //판매자 상품 번호. 최대 100 자.
        $data .= '<imageUrl>'.$goods_img.'</imageUrl>';
        $data .= '<infoUrl><![CDATA['.$goods_info_url.']]></infoUrl>';
        $data .= '<name>'.htmlspecialchars($goods_name).'</name>';

        //$data .= '<single>';
        //$data .= '<quantity>'.$goods_cnt.'</quantity>';
        //$data .= '</single>';

        $data .= '<option>';
            $data .= '<quantity>'.$goods_cnt.'</quantity>';
            $data .= '<selectedItem>';
            $data .= '<type>INPUT</type>';
            $data .= '<name>브랜드</name>';                
            $data .= '<value>';
            $data .= '<id>BL</id>';
            $data .= '<text>'.$goods_brand.'</text>';
            $data .= '</value>';
            $data .= '</selectedItem>';

            $data .= '<selectedItem>';
            $data .= '<type>INPUT</type>';
            $data .= '<name>판매단가</name>';                
            $data .= '<value>';
            $data .= '<id>UP</id>';
            $data .= '<text>'.number_format($goods_selling_price).'원</text>';
            $data .= '</value>';
            $data .= '</selectedItem>';

            $data .= '<selectedItem>';
            $data .= '<type>INPUT</type>';
            $data .= '<name>IQRCD</name>';                
            $data .= '<value>';
            $data .= '<id>UP</id>';
            $data .= '<text>'.$inquiry_code.'</text>';
            $data .= '</value>';
            $data .= '</selectedItem>';

            if ($membercode) {
                $data .= '<selectedItem>';
                $data .= '<type>INPUT</type>';
                $data .= '<name>UMID</name>';
                $data .= '<value>';
                $data .= '<id>UP</id>';
                $data .= '<text>'.$membercode.'</text>';
                $data .= '</value>';
                $data .= '</selectedItem>';
            }

        $data .= '</option>';


        $data .= '<shippingPolicy>';
            $data .= '<groupId>CHIPDIRECT</groupId>';

            if ($deli_cost == '0'){
                $data .= '<feePayType>FREE</feePayType>';   //배송비 결제 방법(무료)
                $data .= '<feePrice>'.$deli_cost.'</feePrice>';    //기본 배송비
                $data .= '<feeType>FREE</feeType>';   //배송비 유형
            } else{
                $data .= '<feePayType>PREPAYED</feePayType>';   //배송비 결제 방법(선불)
                $data .= '<feePrice>'.$deli_cost.'</feePrice>';    //기본 배송비
                $data .= '<feeType>CONDITIONAL_FREE</feeType>';   //배송비 유형
                $data .= '<conditionalFree>';
                $data .= '<basePrice>'.$delivery_free_standard.'</basePrice>';
                $data .= '</conditionalFree>';
            }

            $data .= '<method>DELIVERY</method>';   //배송 방법.
        $data .= '</shippingPolicy>';

        $data .= '</product>';
    endfor;
       
        $data .= '<merchantId>' . $merchantId . '</merchantId>';
        $data .= '<certiKey>' . $certiKey . '</certiKey>';
        $data .= '<backUrl><![CDATA[' . $backUrl.']]></backUrl>';
        $data .= '<interface>';
        $data .= '<cpaInflowCode>'.$_COOKIE['CPAValidator'].'</cpaInflowCode>';     /*네이버쇼핑 CPA 코드*/
        $data .= '<naverInflowCode>'.$_COOKIE['NA_CO'].'</naverInflowCode>';        /*네이버 서비스 유입 경로 코드*/
        $data .= '<saClickId>'.$_COOKIE['NVADID'].'</saClickId>';                   /*SA CLICK ID*/
        $data .= '</interface>';
        $data .= '</order>'; 

    //echo($data);
    //exit;

    return $data;

   }



   public function productsInfo() {

    $param = $this->request->getGet();
    $paramCount = count($param['product']); 

    // var_dump ($param);
    // var_dump ($paramCount);
    // exit;

    /*회원정보 호출 시작 */
    $memberId = AuthHelpers::getLoginInfoGuest()->member_id;
    $info = $this->memberModel->find($memberId);
    $membercode = $info->member_code;

    header('Content-Type: application/xml;charset=utf-8');
    $data = '<?xml version="1.0" encoding="utf-8"?>';
    $data .= '<products>';

    for($i=0;$i <= $paramCount;$i++):

        $part_sequence = $this->request->getGet('product['.$i.'][id]');

        if ($part_sequence) {
            // var_dump ($part_sequence);
            $item = $this->productModel->findByProductCode($part_sequence);

            $goods_cnt = 1;
            $deli_cost = $item->delivery_price;
            $goods_selling_vqt = round($item->selling_price1*0.1);
            $goods_selling_price = $item->selling_price1+$goods_selling_vqt;
            $delivery_free_standard = 30000; // 배송료무료 기준설정

            /*
            if ($goods_selling_price >= $delivery_free_standard) {
                $deli_cost = 0;
            }
            */

            $data .= '<product>';

            $data .= '<id>'.$part_sequence.'</id>'; //상품 번호. 최대 30 자.
            $data .= '<merchantProductId>'.$item->product_code.'</merchantProductId>'; //판매자 상품 번호. 최대 100 자.
            $data .= '<optionSupport>true</optionSupport>';
            $data .= '<name>'.htmlspecialchars($item->part_number).'</name>'; //상품 이름. 최대 100 자.

            $data .= '<option>';
            // $data .= '<quantity>'.$goods_cnt.'</quantity>';
                $data .= '<optionItem>';
                $data .= '<type>INPUT</type>';
                $data .= '<name>브랜드</name>';                
                $data .= '<value>';
                $data .= '<id>BL</id>';
                $data .= '<text>'.$item->name.'</text>';
                $data .= '</value>';
                $data .= '</optionItem>';

                $data .= '<optionItem>';
                $data .= '<type>INPUT</type>';
                $data .= '<name>판매단가</name>';                
                $data .= '<value>';
                $data .= '<id>UP</id>';
                $data .= '<text>'.number_format($goods_selling_price).'원</text>';
                $data .= '</value>';
                $data .= '</optionItem>';
                
                if ($membercode) {
                    $data .= '<selectedItem>';
                    $data .= '<type>INPUT</type>';
                    $data .= '<name>UMID</name>';
                    $data .= '<value>';
                    $data .= '<id>UP</id>';
                    $data .= '<text>'.$membercode.'</text>';
                    $data .= '</value>';
                    $data .= '</selectedItem>';
                }

            $data .= '</option>';

            $data .= '<basePrice>'.$goods_selling_price.'</basePrice>'; //본상품 1 개의 판매 가격. 1 이상만 입력 가능.
            $data .= '<infoUrl>https://chipdirect.co.kr/sale/detail/'.$item->product_code.'</infoUrl>'; //상품 상세 페이지 URL
            $data .= '<imageUrl>'.str_replace(' ','',$item->image_dir).'</imageUrl>'; //상품 원본 이미지 URL
            $data .= '<stockQuantity>'.$item->qty.'</stockQuantity>'; //본상품의 재고 수량

            if ($item->qty == '0') {
                $data .= '<status>SOLD_OUT</status>'; //판매중: ON_SALE, 품절: SOLD_OUT, 구매불가: NOT_SALE
            } else {
            $data .= '<status>ON_SALE</status>';
            }

            $data .= '<shippingPolicy>';
                $data .= '<groupId>CHIPDIRECT</groupId>';

            if ($deli_cost == '0'){
                $data .= '<feePayType>FREE</feePayType>';   //배송비 결제 방법(무료)
                $data .= '<feePrice>'.$deli_cost.'</feePrice>';    //기본 배송비
                $data .= '<feeType>FREE</feeType>';   //배송비 유형
            } else{
                $data .= '<feePayType>PREPAYED</feePayType>';   //배송비 결제 방법(선불)
                $data .= '<feePrice>'.$deli_cost.'</feePrice>';    //기본 배송비
                $data .= '<feeType>CONDITIONAL_FREE</feeType>';   //배송비 유형
                $data .= '<conditionalFree>';
                $data .= '<basePrice>'.$delivery_free_standard.'</basePrice>';
                $data .= '</conditionalFree>';
            }

                $data .= '<method>DELIVERY</method>';   //배송 방법.
            $data .= '</shippingPolicy>';

            $data .= '</product>';
        }

    endfor;

    $data .= '</products>';

    //echo($data);
    //exit;

    return $data;

   }
   
}
