<?php 
namespace App\Controllers\Guest;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use App\Helpers\AuthHelpers;
use App\Models\ProductModel;
use App\Models\ReviewModel;
use App\Models\InquiryModel;

class ReviewModify extends BaseController {

    protected $productModel;
    protected $reviewModel;    
    protected $inquiryModel;


    public function __construct()
    {
        $this->productModel = new ProductModel();
        $this->reviewModel = new ReviewModel();
        $this->inquiryModel = new InquiryModel();
    }

    public function index() {
        helper(['form', 'url']);

        $lists = $this->productModel->findByProductId(1);
        $account = AuthHelpers::getLoginInfoGuest();
        if(isset($account)){
            $lists->memberName = $account->member_name;
            $lists->memberEmail = $account->member_email;
            $lists->memberPhone = $account->member_phone;
            $lists->memberCode = $account->member_code;
        }

        $data['lists'] = $lists;

        //var_dump ($lists);
        //exit;

        //var_dump ($data);
        exit;

        // return $this->viewGuest('cart/cart_view', $data);
    }

    public function review_add() { 
        helper(['form', 'url']);

        $stage = $this->request->getPost('stage');
        $member_code = $this->request->getPost('member_code');

        if ($member_code) {

            $data = array(
                'title' => $this->request->getPost('title'),
                'category_id' => 1,
                'item_code' => $this->request->getPost('item_code'),
                'part_number' => $this->request->getPost('part_number'),
                'manufacturer_code' => $this->request->getPost('manufacturer_code'),
                'member_code' => $this->request->getPost('member_code'),
                'user_name' => $this->request->getPost('user_name'),
                'user_email' => $this->request->getPost('user_email'),
                'user_phone' => $this->request->getPost('user_phone'),
                'content' => $this->request->getPost('content'),
                'password' => "",
            );
            
        } else {

            $password = $this->request->getPost('password');

            if ($password != "") {
                $md5password = md5($password);
                }

            $data = array(
                'title' => $this->request->getPost('title'),
                'category_id' => 1,
                'item_code' => $this->request->getPost('item_code'),
                'part_number' => $this->request->getPost('part_number'),
                'manufacturer_code' => $this->request->getPost('manufacturer_code'),
                'member_code' => $this->request->getPost('member_code'),
                'user_name' => $this->request->getPost('user_name'),
                'user_email' => $this->request->getPost('user_email'),
                'user_phone' => $this->request->getPost('user_phone'),
                'content' => $this->request->getPost('content'),
                'password' => $md5password,
            );

        }

        if ($stage =='inquiry') {
            $insert = $this->inquiryModel->inquiry_add($data, true);
        } else {
            $insert = $this->reviewModel->review_add($data, true);
        }

        echo json_encode(array("status" => TRUE));
    }
 
    public function ajax_find($productId) {
        $data = $this->productModel->findByProductId($productId);
        
        $account = AuthHelpers::getLoginInfoGuest();
        if(isset($account)){
            $data->user_name = $account->member_name;
            $data->user_email = $account->member_email;
            $data->user_phone = $account->member_phone;
            $data->member_code = $account->member_code;
        }

        echo json_encode($data);
    }
 
}