<?php 
namespace App\Controllers\Guest;

use App\Entities\Todaystat;
use App\Entities\ExchangeInfo;
use App\Helpers\AuthHelpers;
use App\Models\TodaystatModel;
use App\Services\TodaystatService;
use App\Models\OrderInfoModel;
use App\Models\ProductModel;
use App\Models\MemberModel;
use App\Models\ExchangeCounrtyModel;
use App\Models\ExchangeInfoModel;

class TodayStatController extends BaseController
{
    protected $todaystatModel;
    protected $todaystatService;
    protected $orderInfoModel;
    protected $productModel;
    protected $memberModel;
    protected $exchangeCounrtyModel;
    protected $exchangeInfoModel;

    public function __construct()
    {
        $this->todaystatModel = new TodaystatModel();
        $this->todaystatService = new TodaystatService();
        $this->orderInfoModel = new OrderInfoModel();
        $this->productModel = new ProductModel();
        $this->memberModel = new MemberModel();
        $this->exchangeCounrtyModel = new ExchangeCounrtyModel();
        $this->exchangeInfoModel = new ExchangeInfoModel();
    }

    public function validationMapFieldLabels()
    {
        return [
            'memo_content' => 'Memo'
        ];
    }

    public function index(){
        echo "Test";
        exit;
    }

    public function autoCreate(){

        $today = date('Y-m-d', time());

        $todayOrder = $this->orderInfoModel->where("created_at >=",$today)->findAll();
        $todayOrder_count = count($todayOrder);
        $todayPay = $this->orderInfoModel->where("payment_date >=",$today)->findAll();
        $todayPay_count = count($todayPay);
        $todaySales = $this->orderInfoModel->where("created_at >=",$today)->selectSum('supply_price', 'sumQuantities')->get()->getRow()->sumQuantities;
        if ($todaySales) {
            $todaySales = $todaySales;
        } else {
            $todaySales = "0";
        }
        $todaySignUp = $this->memberModel->where("created_at >=",$today)->findAll();
        $todaySignUp_count = count($todaySignUp);

        $allProduct = $this->productModel->countAll();
        $totalproduct_count = $allProduct;
        $event = $this->productModel->notLike("event_set", 0)->findAll();
        $event_count = count($event);
        $newproduct = $this->productModel->Like('newproduct_chk', 1)->findAll();
        $newproduct_count = count($newproduct);
        $bestproduct = $this->productModel->Like('bestproduct_chk', 1)->findAll();
        $bestproduct_count = count($bestproduct);
        $recomproduct = $this->productModel->Like('recomproduct_chk', 1)->findAll();
        $recomproduct_count = count($recomproduct);
        $brandproduct = $this->productModel->Like('brandproduct_chk', 1)->findAll();
        $brandproduct_count = count($brandproduct);
        $navershop = $this->productModel->Like('navershop_chk', 1)->findAll();
        $navershop_count =  count($navershop);

        $todaystat = new Todaystat([
            'todayorder'=>$todayOrder_count,
            'todaypayment'=>$todayPay_count,
            'todaysales'=>$todaySales,
            'todaymember'=>$todaySignUp_count,
            'totalproduct' => $totalproduct_count,            
            'eventproduct' => $event_count,
            'newproduct' => $newproduct_count,
            'bestproduct' => $bestproduct_count,
            'recomproduct' => $recomproduct_count,
            'brandproduct' => $brandproduct_count,
            'nshopproduct' => $navershop_count,
        ]);

        // var_dump ($todaystat);
        // exit;

        $this->todaystatModel->insert($todaystat, true);
        exit;

    }


    public function exchangeRatGet($counrty){
        
        if ($counrty == "KRW") {

            $exchangeInfo = new ExchangeInfo;
            $exchangeInfo = [
                'counrty_code'       => "KRW",
                'standard_amount'    => 1,
                'del_flg' => 0
            ];

            $this->exchangeInfoModel->save($exchangeInfo);

        } else {

            $url = 'https://v6.exchangerate-api.com/v6/c8b12ee70053da2aeacac2f6/latest/'.$counrty;
            $headers[] = 'Accept: application/json';
            $headers[] = 'Cache-Control: no-cache';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            curl_close($ch);

            $jsonExchange = json_decode($response,true);
            $standard_amount = round($jsonExchange["conversion_rates"]["KRW"], 2); 
            $counrty_code = $jsonExchange["base_code"];

            $exchangeInfo = new ExchangeInfo;
            $exchangeInfo = [
                'counrty_code'       => $counrty_code,
                'standard_amount'    => $standard_amount,
                'del_flg' => 0
            ];

            $this->exchangeInfoModel->save($exchangeInfo);
            
        }

        $counrty_code = $counrty;
        $ExchangeRat = $this->exchangeInfoModel->where('counrty_code',$counrty_code)->orderBy('created_at desc')->first();
        $exchange_rat = $ExchangeRat->standard_amount;

        echo "오늘 기준화율 : ". $exchange_rat." (".$counrty_code.")<br>";

    }

    public function exchangeRat(){
        $dayago = date('Y-m-d', strtotime('-30 Day'));
        $dayExchange = $this->exchangeInfoModel->Where("created_at <",$dayago)->delete();
        // var_dump($dayExchange);

        $exchangecounrty = $this->exchangeCounrtyModel->selectAll();
        foreach ($exchangecounrty as $exchange_counrty){
            $this->exchangeRatGet($exchange_counrty->counrty_code);
        }

    }

}
