<?php namespace App\Entities;

use App\Helpers\NumberHelper;
use App\Models\AppInfoModel;

class CartInfo
{
    public $items = [];
    public $amount = 0;
    public $qty_total = 0;
    private $percent_vat = 0;
    public $amount_vat = 0;
    public $amount_total = 0;
    public $memberId;

    public function __construct($member_id)
    {
        $this->memberId = $member_id;
        $appInfo = (new AppInfoModel())->fistInfo();
        $this->percent_vat = isset($appInfo->app_vat) ? $appInfo->app_vat : 0;
    }

    public function addCart(Item $item, $quantity, $price){
        $item_id = $item->item_id;
        if(isset($this->items[$item_id])){
            $this->items[$item_id]->qty+= $quantity;
            $this->items[$item_id]->price = $price;
            $this->items[$item_id]->amount = $quantity * $price;
        }else{
            $cartItem = $item->cloneItemAddCart();
            $cartItem->qty= $quantity;
            $cartItem->price = $price;
            $cartItem->amount = $quantity * $price;
            $this->items[$item_id] = $cartItem;
        }
        $this->calculatorCart();
    }

    public function deleteItem($itemIds)
    {
        if(is_array($itemIds)){
            foreach ($itemIds as $itemId){
                if (isset($this->items[$itemId])) {
                    unset($this->items[$itemId]);
                }
            }
        }else{
            if (isset($this->items[$itemIds])) {
                unset($this->items[$itemIds]);
            }
        }
        $this->calculatorCart();
    }

    public function updateQtyItem($itemId, $qty){
        if (isset($this->items[$itemId])) {
            $this->items[$itemId]->qty = $qty;
            $this->items[$itemId]->amount = $qty * $this->items[$itemId]->price;
            $this->calculatorCart();
        }
    }

    public function updatePriceItem($itemId, $price){
        if (isset($this->items[$itemId])) {
            $this->items[$itemId]->price = $price;
            $this->items[$itemId]->amount = $price * $this->items[$itemId]->qty;
            $this->calculatorCart();
        }
    }

    private function calculatorCart(){
        $this->amount = 0;
        $this->qty_total = 0;
        foreach ($this->items as $item){
            $this->amount+= $item->amount;
            $this->qty_total+= $item->qty;
        }
        $this->amount_vat = NumberHelper::roundDown($this->amount * 0.1);
        $this->amount = NumberHelper::round($this->amount);
        $this->amount_total = NumberHelper::round($this->amount + $this->amount_vat);
    }

    public function toArray(){
        $data = [
            'qty_total' => NumberHelper::format(count($this->items)),
            'amount' => NumberHelper::format($this->amount),
            'amount_vat' => NumberHelper::format($this->amount_vat),
            'amount_total' => NumberHelper::format($this->amount_total)
        ];
        $dataItems = [];
        foreach ($this->items as $item){
            $key = 'I'.$item->item_id;
            $dataItems[$key] = $item->toArrayData([
                Item::PART_NUMBER,
                Item::MANUFACTURER_NAME,
                Item::QTY,
                Item::PRICE,
                Item::AMOUNT
            ]);
            $dataItems[$key][Item::QTY] = NumberHelper::format($dataItems[$key][Item::QTY]);
            $dataItems[$key][Item::PRICE] = NumberHelper::format($dataItems[$key][Item::PRICE]);
            $dataItems[$key][Item::AMOUNT] = NumberHelper::format($dataItems[$key][Item::AMOUNT]);
        }
        $data['items'] = $dataItems;
        return $data;
    }

    public function toJson(){
        return json_encode($this->toArray());
    }

    public function getCartById($itemIds){
        $cart = new CartInfo($this->memberId);
        if(isset($itemIds)){
            $items = [];
            foreach ($itemIds as $itemId){
                if(isset($this->items[$itemId])){
                    $item = $this->items[$itemId];
                    $items[] = $item;
                }
            }
            $cart->items = $items;
        }
        $cart->calculatorCart();
        return $cart;
    }

    public function isEmpty(){
        if(isset($this->items) && count($this->items) > 0) return false;
        return true;
    }
}