<?php namespace App\Entities;

class Categorylevel1 extends BaseEntity
{

    public const CATEGORYLEVEL1_ID = "categorylevel1_id";
    public const CATEGORYLEVEL1_CODE = "categorylevel1_code";
    public const CATEGORYLEVEL1_NAME = "categorylevel1_name";
    public const CATEGORYLEVEL1_NAME_ENG = "categorylevel1_name_eng";
    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";


    public function toArrayData($columns = []){
        $data = [
            self::CATEGORYLEVEL1_ID => $this->categorylevel1_id,
            self::CATEGORYLEVEL1_CODE => $this->categorylevel1_code,
            self::CATEGORYLEVEL1_NAME => $this->categorylevel1_name,
            self::CATEGORYLEVEL1_NAME_ENG => $this->categorylevel1_name_eng,
            self::ACTIVE_FLG => $this->active_flg,
            self::DEL_FLG => $this->del_flg,
            self::CREATED_AT => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }

    public function toSession(){
        $data = new Categorylevel1();
        $data->categorylevel1_id = $this->categorylevel1_id;
        $data->categorylevel1_name = $this->categorylevel1_name;
        return $data;
    }

    public function toJson(){
        $data = [
            'categorylevel1_id' => $this->categorylevel1_id,
            'categorylevel1_name' => $this->categorylevel1_name
        ];
        return json_encode($data);
    }

    public function decodeJson($strJson){
        $json = json_decode($strJson);
        $this->categorylevel1_id = $json->categorylevel1_id;
        $this->categorylevel1_name = $json->categorylevel1_name;
    }
}