<?php namespace App\Entities;

class Categorylevel2 extends BaseEntity
{

    public const CATEGORYLEVEL2_ID = "categorylevel2_id";
    public const CATEGORYLEVEL1_ID = "categorylevel1_id";
    public const CATEGORYLEVEL2_CODE = "categorylevel2_code";
    public const CATEGORYLEVEL1_CODE = "categorylevel1_code";
    public const CATEGORYLEVEL2_NAME = "categorylevel2_name";
    public const CATEGORYLEVEL2_NAME_ENG = "categorylevel2_name_eng";
    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";

    public function toArrayData($columns = []){
        $data = [
            self::CATEGORYLEVEL2_ID => $this->categorylevel2_id,
            self::CATEGORYLEVEL1_ID => $this->categorylevel1_id,
            self::CATEGORYLEVEL2_CODE => $this->categorylevel2_code,
            self::CATEGORYLEVEL1_CODE => $this->categorylevel1_code,
            self::CATEGORYLEVEL2_NAME => $this->categorylevel2_name,
            self::CATEGORYLEVEL2_NAME_ENG => $this->categorylevel2_name_eng,
            self::ACTIVE_FLG => $this->active_flg,
            self::DEL_FLG => $this->del_flg,
            self::CREATED_AT => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }


    public function toSession(){
        $data = new Categorylevel2();
        $data->categorylevel2_id = $this->categorylevel2_id;
        $data->categorylevel1_id = $this->categorylevel1_id;
        $data->categorylevel2_name = $this->categorylevel2_name;
        $data->categorylevel2_name_eng = $this->categorylevel2_name_eng;
        return $data;
    }

    public function toJson(){
        $data = [
            'categorylevel2_id' => $this->categorylevel2_id,
            'categorylevel2_name' => $this->categorylevel2_name,
            'categorylevel2_name_eng' => $this->categorylevel2_name_eng
        ];
        return json_encode($data);
    }

    public function decodeJson($strJson){
        $json = json_decode($strJson);
        $this->categorylevel2_id = $json->categorylevel2_id;
        $this->categorylevel2_name = $json->categorylevel2_name;
        $this->categorylevel2_name_eng = $json->categorylevel2_name_eng;
    }
}