<?php namespace App\Entities;

class Member extends BaseEntity
{

    public const MEMBER_ID = "member_id";
    public const MEMBER_CODE = "member_code";
    public const MEMBER_NAME = "member_name";
    public const MEMBER_EMAIL = "member_email";
    public const CATEGORY_ID = "category_id";
    public const PASSWORD = "password";
    public const PASSWORD_RANDOM = "password_random";
    public const MEMBER_PHONE = "member_phone";
    public const MEMBER_ZIPCODE = "member_zipcode";
    public const MEMBER_ADDRESS1 = "member_address1";
    public const MEMBER_ADDRESS2 = "member_address2";
    public const LAST_LOGIN_DATE = "last_login_date";
    public const API_TYPE = "api_type";
    public const AVATAR_DIR = "avatar_dir";
    public const ACCESS_CODE = "access_code";
    public const ACCESS_FLG = "access_flg";
    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";


    public function toArrayData($columns = []){
        $data = [
            self::MEMBER_ID => $this->member_id,
            self::MEMBER_CODE => $this->member_code,
            self::MEMBER_NAME => $this->member_name,
            self::MEMBER_EMAIL => $this->member_email,
            self::CATEGORY_ID => $this->category_id,
            self::PASSWORD => $this->password,
            self::PASSWORD_RANDOM => $this->password_random,
            self::MEMBER_PHONE => $this->member_phone,
            self::MEMBER_ZIPCODE => $this->member_zipcode,
            self::MEMBER_ADDRESS1 => $this->member_address1,
            self::MEMBER_ADDRESS2 => $this->member_address2,
            self::LAST_LOGIN_DATE => $this->last_login_date,
            self::API_TYPE => $this->api_type,
            self::AVATAR_DIR => $this->avatar_dir,
            self::ACCESS_CODE => $this->access_code,
            self::ACCESS_FLG => $this->access_flg,
            self::ACTIVE_FLG => $this->active_flg,
            self::DEL_FLG => $this->del_flg,
            self::CREATED_AT => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }


    public function toSession(){
        $data = new Member();
        $data->member_code = $this->member_code;
        $data->member_id = $this->member_id;
        $data->member_name = $this->member_name;
        $data->member_email = $this->member_email;
        $data->category_id = $this->category_id;
        $data->member_phone = $this->member_phone;
        $data->member_zipcode = $this->member_zipcode;
        $data->member_address1 = $this->member_address1;
        $data->member_address2 = $this->member_address2;
        $data->active_flg = $this->active_flg;
        $data->remember = $this->remember;
        $data->avatar_dir = $this->avatar_dir;
        return $data;
    }

    public function toJson(){
        $data = [
            'member_code' => $this->member_code,
            'member_id' => $this->member_id,
            'member_name' => $this->member_name,
            'avatar_dir' => $this->avatar_dir
        ];
        return json_encode($data);
    }

    public function decodeJson($strJson){
        $json = json_decode($strJson);
        $this->member_code = $json->member_code;
        $this->member_id = $json->member_id;
        $this->member_name = $json->member_name;
    }
}