<?php namespace App\Entities;

class OrderInfo extends BaseEntity
{
    public const INFO_ID = "info_id";
    public const ORDER_CODE = "order_code";
    public const ORDER_TYPE = "order_type";
    public const ORDER_STATUS = "order_status";
    public const MEMBER_CODE = "member_code";
    public const ORDERER_NAME = "orderer_name";
    public const ORDERER_EMAIL = "orderer_email";
    public const ORDERER_PHONE = "orderer_phone";
    public const SHIPPING_RECIPIENT = "shipping_recipient";
    public const SHIPPING_NAME = "shipping_name";
    public const DELIVERY_PHONE = "delivery_phone";
    public const SHIPPING_PHONE = "shipping_phone";
    public const COMPANY_NAME = "company_name";
    public const SHIPPING_ZIPOCODE = "shipping_zipocode";
    public const SHIPPING_ADD1 = "shipping_add1";
    public const SHIPPING_ADD2 = "shipping_add2";
    public const SHIPPING_MESSAGE = "shipping_message";
    public const NOTICE = "notice";
    public const INVOICE_TYPE = "invoice_type";
    public const INVOICE_COM = "invoice_com";
    public const INVOICE_BIZNUM = "invoice_biznum";
    public const INVOICE_CEO = "invoice_ceo";
    public const SHIP_METHOD_FLG = "ship_method_flg";
    public const SHIP_CODE = "ship_code";
    public const SHIP_COMPANY = "ship_company";
    public const SHIP_DATE = "ship_date";
    public const INVOICE_NUM = "invoice_num";
    public const FIRSTITEM_CODE = "firstitem_code";
    public const FIRSTITEM_NUMBER = "firstitem_number";
    public const FIRSTITEM_IMAGE = "firstitem_image";
    public const ITEM_COUNTS = "item_counts";
    public const SUPPLY_PRICE = "supply_price";
    public const VAT = "vat";
    public const AMOUNT_TOTAL = "amount_total";
    public const DELIVERY_FEE = "delivery_fee";
    public const DELIVERY_DATE = "delivery_date";
    public const CHANGE_FLG = "change_flg";
    public const REFUND_FLG = "refund_flg";
    public const PAYMENT_DATE = "payment_date";
    public const PAYMENT_FLG = "payment_flg";
    public const DEPOSIT_NAME = "deposit_name";
    public const DEPOSIT_BANK = "deposit_bank";
    public const DEPOSIT_DATE = "deposit_date";
    public const RESULTCODE = "resultCode";
    public const RESULTMSG = "resultMsg";
    public const TID = "tid";
    public const MOID = "MOID";
    public const TOTPRICE = "TotPrice";
    public const GOODNAME = "goodName";
    public const APPLDATE = "applDate";
    public const APPLTIME = "applTime";
    public const PAYMETHOD = "payMethod";
    public const APPLNUM = "applNum";
    public const P_FN_NM = "P_FN_NM";
    public const VACT_NUM = "VACT_Num";
    public const VACT_BANKCODE = "VACT_BankCode";
    public const VACTBANKNAME = "vactBankName";
    public const VACT_DATE = "VACT_Date";
    public const PAYDEVICE = "payDevice";
    public const SALES_PROOF_FLG = "sales_proof_flg";
    public const AMOUNT_PAYMENT = "amount_payment";
    public const TAXINVOICE_STATUS = "taxinvoice_status";
    public const TAXINVOICE_CREATED = "taxinvoice_created";
    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";

    public function toArrayData($columns = []){
        $data = [
            self::INFO_ID => $this->info_id,
            self::ORDER_CODE => $this->order_code,
            self::ORDER_TYPE => $this->order_type,
            self::ORDER_STATUS => $this->order_status,
            self::MEMBER_CODE => $this->member_code,
            self::ORDERER_NAME => $this->orderer_name,
            self::ORDERER_EMAIL => $this->orderer_email,
            self::ORDERER_PHONE => $this->orderer_phone,
            self::SHIPPING_RECIPIENT => $this->shipping_recipient,
            self::SHIPPING_NAME => $this->shipping_name,
            self::DELIVERY_PHONE => $this->delivery_phone,
            self::SHIPPING_PHONE => $this->shipping_phone,
            self::COMPANY_NAME => $this->company_name,
            self::SHIPPING_ZIPOCODE => $this->shipping_zipocode,
            self::SHIPPING_ADD1 => $this->shipping_add1,
            self::SHIPPING_ADD2 => $this->shipping_add2,
            self::SHIPPING_MESSAGE => $this->shipping_message,
            self::NOTICE => $this->notice,
            self::INVOICE_TYPE => $this->invoice_type,
            self::INVOICE_COM => $this->invoice_com,
            self::INVOICE_BIZNUM => $this->invoice_biznum,
            self::INVOICE_CEO => $this->invoice_ceo,
            self::SHIP_METHOD_FLG => $this->ship_method_flg,
            self::SHIP_CODE => $this->ship_code,
            self::SHIP_COMPANY => $this->ship_company,
            self::SHIP_DATE => $this->ship_date,
            self::INVOICE_NUM => $this->invoice_num,
            self::FIRSTITEM_CODE => $this->firstitem_code,
            self::FIRSTITEM_NUMBER => $this->firstitem_number,
            self::FIRSTITEM_IMAGE => $this->firstitem_image,
            self::ITEM_COUNTS => $this->item_counts,
            self::SUPPLY_PRICE => $this->supply_price,
            self::VAT => $this->vat,
            self::AMOUNT_TOTAL => $this->amount_total,
            self::DELIVERY_FEE => $this->delivery_fee,
            self::DELIVERY_DATE => $this->delivery_date,
            self::CHANGE_FLG => $this->change_flg,
            self::REFUND_FLG => $this->refund_flg,
            self::PAYMENT_DATE => $this->payment_date,
            self::PAYMENT_FLG => $this->payment_flg,
            self::DEPOSIT_NAME => $this->deposit_name,
            self::DEPOSIT_BANK => $this->deposit_bank,
            self::DEPOSIT_DATE => $this->deposit_date,
            self::RESULTCODE => $this->resultCode,
            self::RESULTMSG => $this->resultMsg,
            self::TID => $this->tid,
            self::MOID => $this->MOID,
            self::TOTPRICE => $this->TotPrice,
            self::GOODNAME => $this->goodName,
            self::APPLDATE => $this->applDate,
            self::APPLTIME => $this->applTime,
            self::PAYMETHOD => $this->payMethod,
            self::APPLNUM => $this->applNum,
            self::P_FN_NM => $this->P_FN_NM,
            self::VACT_NUM => $this->VACT_Num,
            self::VACT_BANKCODE => $this->VACT_BankCode,
            self::VACTBANKNAME => $this->vactBankName,
            self::VACT_DATE => $this->VACT_Date,
            self::PAYDEVICE => $this->payDevice,
            self::SALES_PROOF_FLG => $this->sales_proof_flg,
            self::AMOUNT_PAYMENT => $this->amount_payment,
            self::TAXINVOICE_STATUS => $this->taxinvoice_status,
            self::TAXINVOICE_CREATED => $this->taxinvoice_created,
            self::ACTIVE_FLG => $this->active_flg,
            self::DEL_FLG => $this->del_flg,
            self::CREATED_AT => $this->created_at,
            self::UPDATED_AT => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }

    public function cloneOrderInfoAddCart(){
        $orderInfo = new OrderInfo();
        $orderInfo->info_id = $this->info_id;
        $orderInfo->order_code = $this->order_code;
        $orderInfo->member_code = $this->member_code;
        $orderInfo->shipping_recipient = $this->shipping_recipient;
        $orderInfo->shipping_name = $this->shipping_name;

        return $orderInfo;
    }
}