<?php namespace App\Entities;

class ProductmpEvent extends BaseEntity
{
    public const PRODUCT_ID = "product_id";
    public const PRODUCT_CODE = "product_code";
    public const PART_NUMBER = "part_number";
    public const REPLACEMENT_ITEMS = "replacement_items";
    public const ACTIVE_FLG = "active_flg";
    public const DEL_FLG = "del_flg";
    public const CREATED_AT = "created_at";
    public const UPDATED_AT = "updated_at";

    public function toArrayData($columns = []){
        $data = [
            self::PRODUCT_ID  => $this->product_id,
            self::PRODUCT_CODE  => $this->product_code,
            self::PART_NUMBER  => $this->part_number,
            self::REPLACEMENT_ITEMS  => $this->replacement_items,
            self::ACTIVE_FLG  => $this->active_flg,
            self::DEL_FLG  => $this->del_flg,
            self::CREATED_AT  => $this->created_at,
            self::UPDATED_AT  => $this->updated_at
        ];
        if(!isset($columns) || count($columns) <= 0) return $data;
        $resultData = [];
        foreach($columns as $column){
            if(isset($data[$column])){
                $resultData[$column] = $data[$column];
            }
        }
        return $resultData;
    }

    public function cloneProductAddCart(){
        $productmpevent = new ProductmpEvent();
        $productmpevent->product_id = $this->product_id;
        $productmpevent->product_code = $this->product_code;
        $productmpevent->part_number = $this->part_number;
        $productmpevent->replacement_items = $this->replacement_items;
        return $productmpevent;

    }
}