<?php namespace App\Filters\Common;

use App\Helpers\AuthHelpers;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class DetailSaveBackListFilter implements FilterInterface
{
    private $mapUrlBack =  [];
    public function __construct()
    {
        //Guest
        $this->mapUrlBack[route_to('guest.sale.index')] = [
            'url' => route_to('guest.sale.detail','1'),
            'route_back' => 'guest.sale.index'
        ];
        $this->mapUrlBack[route_to('guest.contact.news')] = [
            'url' => route_to('guest.contact.news.detail','1'),
            'route_back' => 'guest.contact.news'
        ];
        $this->mapUrlBack[route_to('guest.my.quotation_history')] = [
            'url' => route_to('guest.my.quotation_history.detail','1'),
            'route_back' => 'guest.my.quotation_history'
        ];

        //Admin
        $this->mapUrlBack[route_to('admin.sale.quote.index')] = [
            'url' => route_to('admin.sale.quote.detail','1'),
            'route_back' => 'admin.sale.quote.index'
        ];
        $this->mapUrlBack[route_to('admin.sale.index')] = [
            'url' => route_to('admin.sale.show_update','1'),
            'route_back' => 'admin.sale.index'
        ];
        $this->mapUrlBack[route_to('admin.news.index')] = [
            'url' => route_to('admin.news.show_update','1'),
            'route_back' => 'admin.news.index'
        ];
        $this->mapUrlBack[route_to('admin.inquiry.index')] = [
            'url' => route_to('admin.inquiry.detail','1'),
            'route_back' => 'admin.inquiry.index'
        ];
        $this->mapUrlBack[route_to('admin.member.index')] = [
            'url' => route_to('admin.member.show_update','1'),
            'route_back' => 'admin.member.index'
        ];
    }

    public function before(RequestInterface $request, $arguments = null)
    {
        $requestUri = $_SERVER['PATH_INFO'];
        if(isset($this->mapUrlBack[$requestUri])){
            if(isset($_SERVER['HTTP_REFERER'])){
                $refererUrl = $_SERVER['HTTP_REFERER'];
                if(isset($refererUrl) && !empty($refererUrl)){
                    $valueUrl = $this->mapUrlBack[$requestUri]['url'];
                    $valueUrl = preg_replace('/\/\d+$/','',$valueUrl);
                    $queryString =$_SERVER['QUERY_STRING'];
                    //Check query string not content keyword
                    if(strpos($refererUrl,$valueUrl) && strpos($queryString, 'keyword') === false){
                        $mapBackUrl =  AuthHelpers::getSession()->get(AuthHelpers::BACK_URL);
                        $queryString = $mapBackUrl[$requestUri];
                        if(!empty($queryString)){
                            $url = $requestUri . '?' . $queryString;
                            unset($mapBackUrl[$requestUri]);
                            AuthHelpers::getSession()->set(AuthHelpers::BACK_URL,$mapBackUrl);
                            return redirect()->to($url);
                        }
                    }
                }
                $queryString = $_SERVER['QUERY_STRING'];
                $mapBackUrl[$requestUri] = $queryString;
                AuthHelpers::getSession()->set(AuthHelpers::BACK_URL,$mapBackUrl);
            }
        }
    }

    //--------------------------------------------------------------------

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
    }
}