<?php namespace App\Helpers\Common;

class EmailHelper{
    private $email;
    private $emailFrom;
    private $nameFrom;

    public function __construct()
    {
        $this->email = \Config\Services::email();
        $config['protocol'] = 'html';
        $config['wordWrap'] = true;
        $config['mailPath'] = env('email.mailPath','/usr/sbin/sendmail -t -i');
        $config['fromEmail'] = env('email.fromEmail','kyungyeon.jung@gmail.com') ;
        $config['fromName'] = env('email.fromName','ChipDirect');
        // $config['SMTPHost'] = env('email.host','');
        // $config['SMTPUser'] = env('email.user','');
        // $config['SMTPPass'] = env('email.pass','');
        // $config['SMTPPort'] = env('email.port','');
        $this->email->initialize($config);
    }

    /**
     * @return \CodeIgniter\Email\Email|mixed
     */
    public function getEmail(){
        return $this->email;
    }

    public function sendMail($subject, $message, $email){
        $this->email->setTo($email)
            ->setSubject($subject)
            ->setMessage($message);
        $this->email->send();
    }
}